
/* This can all easily be less static */

/* Height of an entire dot column in words.  17 in * 360 dpi / 32 bits/wd */
/* This number should be odd (for cache efficiency). */

#define NWCOL 195

/* Height of a column in bytes */

#define NBCOL (NWCOL * 4)

/* Height of a column in dots */

#define NH (NBCOL * 8)

/* Number of columns, 8.5 inches * 360 dpi */
/* The manual says that the print width is clipped to 8 in by the hw */

#define NW 3060

/* The bit map */

extern unsigned long page[NW * NWCOL];


/* See Ghostscript's gdevbj10.c for a good discussion.

   The printer prints an 8-inch-wide swath positioned by dip switch 1
   to center it on 8.5-inch paper (1/4 in margins) or A4 paper (about
   1/8 inch).  Software cannot control this.

   The paper length is unknown to the printer, but you can't print 
   all the way to the end because the paper handling mechanism must
   still have hold of the paper.  The top-of-form position gets you
   (on mine) within about 1/4 inch of the top, and you can print to
   about that far from the bottom.  We get the paper length from
   the user via the -paper-length flag, and insure that we don't 
   print below the bottom printable line.  This requires some 
   juggling to align the bottom of the last line printed with the
   bottom of the printable area -- it can be less than 48 dots high. */

#define BJ200_TOP_MARGIN		0.12
#define BJ200_BOTTOM_MARGIN		0.29
#define BJ200_LETTER_SIDE_MARGIN	0.25
#define BJ200_A4_SIDE_MARGIN		0.13

#define X0 ((int) (360 * BJ200_LETTER_SIDE_MARGIN + 0.5))
#define XN (X0 + 360 * 8)
#define Y0 ((int) (360 * BJ200_TOP_MARGIN + 0.5))
/*#define YN ((int) (360 * (11.0 - BJ200_BOTTOM_MARGIN) + 0.5))*/
extern int YN;
