#include <forms.h>
#include "load_data.h"
#include "sort_buttons.h"
#include "main_window.h"

extern BS_data_list data;  
extern FD_main_window *main_window;

void
quick_sort(int size, int bottomstart, int topstart, 
     BS_sort_list feld[size])
{
  int irun1;
  int ref    =  (int)((bottomstart+topstart)/2.0);
  int bottom,top;
  BS_sort_list stack;
  char ref_el[5000];

  memmove(ref_el,feld[ref].text,strlen(feld[ref].text)+1);
  
  top=topstart;
  bottom=bottomstart;
  do
    {
      while(strcmp(feld[bottom].text,ref_el) < 0 && bottom < top)
	bottom++;
      while(strcmp(feld[top].text,ref_el) > 0 && bottom < top)
	top--;
      stack=feld[bottom];
      feld[bottom]=feld[top];
      feld[top]=stack;
      if(bottom < top)bottom++;
    }while(bottom < top);

  if(topstart-bottomstart>1)
    {
      if(top == bottom)bottom--;
      if(bottomstart<bottom)
	quick_sort(size,bottomstart,bottom, feld);
      if(topstart>top)
	quick_sort(size,top ,topstart, feld);
    }
  return;
}

void
remove_chr(char names[])
{
  int i,istart,irun,brackets;



  i=0;

  brackets=0;
  /* exchange {and's} by a@d */
  while(i <strlen(names))
    {

      while(i < strstr(names,"and")-&names[0] && i <strlen(names))
	{

	  if(names[i]=='{' && names[MAX(0,i-1)]!='\\')
	    brackets++;
	  if(names[i]=='}' && names[MAX(0,i-1)]!='\\')
	    brackets--;
	  i++;
	}
      if(i <strlen(names))
	{ 
	  if(brackets)
	    memmove(strstr(names,"and"),"a@d",3);
	  else
	    memmove(strstr(names,"and"),"@n@ ",3);
	}
    }

  brackets=0;
  i=0;
  /* remove von's, de's, du's etc. except in {} */
  while(i <strlen(names)-1)
    {

      while(i <strlen(names)-1)
	{
	  if(names[i]=='{' && names[MAX(0,i-1)]!='\\')
	    {
	      brackets++;
	      i++;
	    }
	  if(names[i]=='}' && names[MAX(0,i-1)]!='\\')
	    {
	      brackets--;
	      i++;
	    }
	  if(brackets==0)
	    if(islower(names[i]) && (i==0 || names[MAX(0,i-1)]==' '))
	      while(names[i]!=' '&& islower(names[i])&&i < strlen(names))names[i++]=' ';
	  
	  i++;
	}
    }

  brackets=0;
  i=0;
  /* remove everything after a ',' but not in {} */
  while(i <strlen(names)-1)
    {

      while(i <strlen(names)-1)
	{
	  if(names[i]=='{' && names[MAX(0,i-1)]!='\\')
	    {
	      brackets++;
	      i++;
	    }
	  if(names[i]=='}' && names[MAX(0,i-1)]!='\\')
	    {
	      brackets--;
	      i++;
	    }
	  if(brackets==0)
	    if(names[i] == ',')
	      while(!(names[MIN( i ,strlen(names))]=='@' && 
		      names[MIN(i+1,strlen(names))]=='n' && 
		      names[MIN(i+2,strlen(names))]=='@') && 
		    i  <strlen(names))
		{
		  names[i++]=' ';
		}
	  i++;
	}
    }

  brackets=0;
  i=0;
  /* remove christian names  {} */
  i=MIN(strstr(names,"@n@")-&names[0], strlen(names)-1);
  istart=0;
  while(i > istart && i<= strlen(names))
    {
      while(names[--i] ==' ' && i >= istart)
	;
      while((names[i] !=' ' || brackets!=0) && i >= istart )
	{
	  if(names[i]=='}' )
	    brackets++;
	  if(names[i]=='{')
	    brackets--;
i--;
	}
      while( --i >= istart)
	names[i]=' ';
      
      istart=MIN(strstr(names,"@n@")-&names[0], strlen(names))-1;
      if(strstr(names,"@n@"))
	memmove(strstr(names,"@n@"),"   ",3);
      i=MIN(strstr(names,"@n@")-&names[0], strlen(names))-1;
      
    }

  /* remove @n@ and a@d \? and { }*/
  while(strstr(names,"@n@"))memmove(strstr(names,"@n@"),"   ",3);
  while(strstr(names,"a@d"))memmove(strstr(names,"a@d"),"   ",3);
  while(strstr(names,"\\"))memmove(strstr(names,"\\"),"  ",2);
  while(strstr(names,"{"))memmove(strstr(names,"{")," ",1);
  while(strstr(names,"}"))memmove(strstr(names,"}")," ",1);
  while(names[strlen(names)-1]==' ')
    names[strlen(names)-1]='\0';
  while(strstr(names,"  "))
    {
      memmove(strstr(names,"  "),
	      strstr(names,"  ")+1,
	      strlen(names)-(strstr(names,"  ")-&names[0])+1);
    }
  if(names[0]==' ')
    memmove(names,
	    names+1,
	    strlen(names));
  
  return;
}

int
sort_by_else(int choice)
{
    BS_sort_list names[fl_get_browser_maxline(main_window->list)];
    BS_data_list first_entry, present_entry,last_entry;
    
    int i,irun,list_entries;

    char buffer[BUFFERSIZE];
    present_entry=data;
    list_entries=fl_get_browser_maxline(main_window->list);


    /* save first entry */

    first_entry=present_entry;
    
    irun=-1;
    while(++irun<list_entries)
      {
	
	memmove(buffer,present_entry->field_text[choice],
		strlen(present_entry->field_text[choice])+1);

	names[irun].text=(char *)malloc(strlen(buffer)+1);
	memmove(names[irun].text,buffer,strlen(buffer)+1);
	names[irun].pointer=present_entry;	

	present_entry=present_entry->next_entry;
	
      }
    /* save last entry */
    
    last_entry=present_entry;
    
    /* sort names */
    
    quick_sort(irun,0,irun-1,names);
    
    irun=-1;
    present_entry=names[0].pointer;
    while(++irun < list_entries-1)
      {
	present_entry->next_entry=names[irun+1].pointer;
	present_entry=present_entry->next_entry;
      }
    present_entry->next_entry=last_entry;
    while(present_entry->next_entry != first_entry)
      present_entry=present_entry->next_entry;
    present_entry->next_entry=names[0].pointer;
    data=names[0].pointer;

    irun=-1;
    while(++irun<list_entries)
      free(names[irun].text);

    return list_entries;
}


int
sort_by_author()
{
    BS_sort_list names[fl_get_browser_maxline(main_window->list)];
    BS_data_list first_entry, present_entry,last_entry;
    
    int i,irun,list_entries;

    char buffer[BUFFERSIZE];
    present_entry=data;
    list_entries=fl_get_browser_maxline(main_window->list);


    /* save first entry */

    first_entry=present_entry;
    
    irun=-1;
    while(++irun<list_entries)
      {
	
	memmove(buffer,present_entry->field_text[2],
		strlen(present_entry->field_text[2])+1);
		/* remove christian names from names */
	
	if(strlen(buffer))
	  remove_chr(buffer);
	
	names[irun].text=(char *)malloc(strlen(buffer)+1);
	memmove(names[irun].text,buffer,strlen(buffer)+1);
	names[irun].pointer=present_entry;	

	present_entry=present_entry->next_entry;
	
      }
    /* save last entry */
    
    last_entry=present_entry;
    
    /* sort names */
    
    quick_sort(irun,0,irun-1,names);
    
    irun=-1;
    present_entry=names[0].pointer;
    while(++irun < list_entries-1)
      {
	present_entry->next_entry=names[irun+1].pointer;
	present_entry=present_entry->next_entry;
      }
    present_entry->next_entry=last_entry;
    while(present_entry->next_entry != first_entry)
      present_entry=present_entry->next_entry;
    present_entry->next_entry=names[0].pointer;
    data=names[0].pointer;

    irun=-1;
    while(++irun<list_entries)
      free(names[irun].text);


    return list_entries;
}

void
cb_sortbuttons(FL_OBJECT *ob, long button)
{
  int list_entries;
  int choice=fl_get_choice(main_window->sort_by);

  if(choice == 2)
      list_entries=sort_by_author();
  else
      list_entries=sort_by_else(choice);

  list_data(list_entries);
}




