/*****

      $Source: d:\gunther\source\grc/RCS/rccparse.l,v $
      $Author: gunther $
      $Date: 1996/01/02 23:17:24 $
      $Revision: 1.6 $

	Changed by: Fred Kiefer (kiefer@isys.de) 1996/6/2

 *****/

%{

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#include "resnt.h"
#include "yystype.h"
#include "rccparse.h"

/* uncomment for flex 2.5.3
#define yy_flex_alloc malloc
#define yy_flex_realloc realloc
#define yy_flex_free free
*/
/*	extern int yywrap YY_PROTO(( void )); */
#define yy_strcpy strcpy

/*
UMLAUT	    [A]
NUMBER      [0-9]*|0(x|X)[(0-9)|(a-f)|(A-F)]*L{0,1}
CHAR        [a-zA-Z0-9_] | {UMLAUT}
NOCHAR      [^{CHAR}]
STRING      ([A-Z]|[a-z]|{UMLAUT})({CHAR}*)
*/

%}

WHITESPACE  [ \t]
UMLAUT	    [A]
NUMBER      [0-9]*|0(x|X)[(0-9)|(a-f)|(A-F)]*L{0,1}
CHAR        [a-zA-Z0-9_]
NOCHAR      [^a-zA-Z0-9_]
STRING      ([A-Z]|[a-z])([((a-z)|(A-Z))|(0-9)|_]*)
QUOTEDSTRING    ("\"""\"")|("\""[^"]*"\"")
COMMENT         \/\*.*\*\/

%%
          
\{		return BEG;
\}		return END;
\~		return NOT;

{COMMENT}           /* eat up */

\/\/                {
                        /* c++ comment */
                        int c;
                        
                        while((c = input()) != '\n');
                        lines++;      /* increment the line counter */
                        return '\n';  /* return a newline character to yyparse() */
                    }

"+"{0,1}{NUMBER}    {
		yylval.value = strtoul(yytext, 0, 0);

                        if(yylval.value == 0x7fffffff)
                        {
                            yyerror("Numeric value too long");
                            return 0;
                        }

                        return NUMBER;
                    }

"-"{NUMBER}         {
                        yylval.value = strtol(yytext, 0, 0);
                        return NUMBER;
                    }

{QUOTEDSTRING}	{
		int length = yyleng;
		char *start = yytext;

		if (start[0] == '\"')
		{
			start++;
			length--;
		}
		if (start[length-1] == '\"')
			length--;
		if (length > MAX_RES_STRING - 1)
		{
			fprintf(stderr, "%s: %d: WARN: buffer too small for text\n", currentFile, lines);
			fprintf(stderr, "\tsize is %d, but should be at max %d\n", length, MAX_RES_STRING - 1);
			length = MAX_RES_STRING - 1;
		}
		strncpy(yylval.string, start, length);
		yylval.string[length] = '\0';
		return QUOTEDSTRING;
	}
                
ACCELERATORS/{NOCHAR}	return ACCELERATORS;
AUTO3STATE/{NOCHAR}		return AUTO3STATE;
AUTOCHECKBOX/{NOCHAR}	return AUTOCHECKBOX;
AUTORADIOBUTTON/{NOCHAR}	return AUTORADIOBUTTON;
BEGIN/{NOCHAR}			return BEG;
BITMAP/{NOCHAR}			return BITMAP;
BUTTON/{NOCHAR}			return BUTTON;
CAPTION/{NOCHAR}		return CAPTION;
CHARACTERISTICS/{NOCHAR}	return CHARACTERISTICS;
CHECKBOX/{NOCHAR}		return CHECKBOX;
CLASS/{NOCHAR}			return CLASS;
COMBOBOX/{NOCHAR}		return COMBOBOX;
CONTROL/{NOCHAR}		return CONTROL;
CTEXT/{NOCHAR}			return CTEXT;
CURSOR/{NOCHAR}			return CURSOR;
DEFPUSHBUTTON/{NOCHAR}	return DEFPUSHBUTTON;
DIALOG/{NOCHAR}			return DIALOG;
DIALOGEX/{NOCHAR}		return DIALOGEX;
DLGINCLUDE/{NOCHAR}		return DLGINCLUDE;
EDITTEXT/{NOCHAR}		return EDITTEXT;
END/{NOCHAR}			return END;
EXSTYLE/{NOCHAR}		return EXSTYLE;
FONT/{NOCHAR}			return FONT;
GROUPBOX/{NOCHAR}		return GROUPBOX;
ICON/{NOCHAR}			return ICON;
LANGUAGE/{NOCHAR}		return LANGUAGE;
LISTBOX/{NOCHAR}		return LISTBOX;
LTEXT/{NOCHAR}			return LTEXT;
MENUITEM/{NOCHAR}		return MENUITEM;
MENUEX/{NOCHAR}			return MENUEX;
MENU/{NOCHAR}			return MENU;
MESSAGETABLE/{NOCHAR}	return MESSAGETABLE;
NOT/{NOCHAR} 			return NOT;
POPUP/{NOCHAR}			return POPUP;
PUSHBOX/{NOCHAR}		return PUSHBOX;
PUSHBUTTON/{NOCHAR}		return PUSHBUTTON;
RADIOBUTTON/{NOCHAR}	return RADIOBUTTON;
RCDATA/{NOCHAR}			return RCDATA;
RTEXT/{NOCHAR}			return RTEXT;
SCROLLBAR/{NOCHAR}		return SCROLLBAR;
SEPARATOR/{NOCHAR}		return SEPARATOR;
STATE3/{NOCHAR}			return STATE3;
STRINGTABLE/{NOCHAR}	return STRINGTABLE;
STYLE/{NOCHAR}			return STYLE;
TOOLBAR/{NOCHAR}		return TOOLBAR;
VERSION/{NOCHAR}		return VERSION;
VERSIONINFO/{NOCHAR}	return VERSIONINFO;

FILEVERSION/{NOCHAR}	return FILEVERSION;
PRODUCTVERSION/{NOCHAR}	return PRODUCTVERSION;
FILEFLAGS/{NOCHAR}		return FILEFLAGS;
FILEFLAGSMASK/{NOCHAR}	return FILEFLAGSMASK;
FILEOS/{NOCHAR}			return FILEOS;
FILETYPE/{NOCHAR}		return FILETYPE;
FILESUBTYPE/{NOCHAR}	return FILESUBTYPE;
BLOCK/{NOCHAR}			return BLOCK;
VALUE/{NOCHAR}			return VALUE;

SHIFT/{NOCHAR}          return SHIFT;
ALT/{NOCHAR}            return ALT;
NOINVERT/{NOCHAR}       return NOINVERT;
ASCII/{NOCHAR}          return ASCII;
VIRTKEY/{NOCHAR}        return VIRTKEY;

PRELOAD/{NOCHAR}		yylval.value = MEMFLAG_PRELOAD; return MEMFLAG;
FIXED/{NOCHAR}			yylval.value = MEMFLAG_FIXED; return MEMFLAG;
PURE/{NOCHAR}			yylval.value = MEMFLAG_PURE; return MEMFLAG;
IMPURE/{NOCHAR}			yylval.value = MEMFLAG_IMPURE; return MEMFLAG;
MOVEABLE/{NOCHAR}		yylval.value = MEMFLAG_MOVEABLE; return MEMFLAG;
LOADONCALL/{NOCHAR}		yylval.value = MEMFLAG_LOADONCALL; return MEMFLAG;
DISCARDABLE/{NOCHAR}	yylval.value = MEMFLAG_DISCARDABLE; return MEMFLAG;

CHECKED/{NOCHAR}            yylval.value = MENUFLAG_CHECKED; return MENUFLAG;
GRAYED/{NOCHAR}             yylval.value = MENUFLAG_GRAYED; return MENUFLAG;
HELP/{NOCHAR}               yylval.value = MENUFLAG_MENUBREAK; return MENUFLAG;
INACTIVE/{NOCHAR}           yylval.value = MENUFLAG_INACTIVE; return MENUFLAG;
MENUBARBREAK/{NOCHAR}       yylval.value = MENUFLAG_MENUBARBREAK; return MENUFLAG;
MENUBREAK/{NOCHAR}          yylval.value = MENUFLAG_MENUBREAK; return MENUFLAG;
OWNERDRAW/{NOCHAR}          yylval.value = MENUFLAG_OWNERDRAW; return MENUFLAG;

{STRING}	{
		int length = yyleng;

		if (length > MAX_RES_STRING - 1)
		{
			fprintf(stderr, "%s: %d:WARN: buffer too small for string\n", currentFile, lines);
			fprintf(stderr, "\tsize is %d, but should be at max %d\n", length, MAX_RES_STRING - 1);
			length = MAX_RES_STRING - 1;
		}
		strncpy(yylval.string, yytext, length);
		yylval.string[length] = '\0';
		return STRING;
	}
                                
{WHITESPACE}	/* eat up */

"\n"		lines++; return '\n';

.           return *yytext;

%%
