/* wmscroll.c (emx+gcc) -- Copyright (c) 1987-1994 by Eberhard Mattes */

#include <string.h>
#include <sys/winmgr.h>
#include "winmgr2.h"

void wm_scroll (wm_handle wh, int count)
{
  int y;
  char *p1, *p2;

  if (wh->used != WM_USED)
    return;
  if (count > wh->height)
    count = wh->height;
  for (y = 0; y < wh->height - count; ++y)
    {
      p1 = &DATA (wh, wh->ax, y + wh->ay);
      p2 = p1 + 2 * count * wh->bwidth;
      memmove (p1, p2, (size_t)(2 * wh->width));
    }
  for (y = wh->height-count; y < wh->height; ++y)
    _wm_clrline1 (wh, y + wh->ay, wh->ax,
                  wh->width - 1 + wh->ax);
  if (wh->display)
    _wm_put1 (wh);
  else
    wh->update_req = TRUE;
  _wm_cursor1 ();
}
