/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.datatool;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TextualContentCommand;
import java.io.IOException;

public class DatagidxWordifyGreek
extends ControlSequence {
    public static final String[] NAMES = new String[]{"alpha", "beta", "gamma", "delta", "epsilon", "zeta", "eta", "theta", "iota", "kappa", "lambda", "mu", "nu", "xi", "pi", "rho", "sigma", "tau", "upsilon", "phi", "chi", "psi", "omaga"};

    public DatagidxWordifyGreek() {
        this("datagidxwordifygreek");
    }

    public DatagidxWordifyGreek(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new DatagidxWordifyGreek(this.getName());
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        for (String string : NAMES) {
            teXParser.putControlSequence(true, new TextualContentCommand(string, string));
            string = string.substring(0, 1).toUpperCase() + string.substring(1);
            teXParser.putControlSequence(true, new TextualContentCommand(string, string));
        }
        teXParser.putControlSequence(true, new TextualContentCommand("varepsilon", "epsilon"));
        teXParser.putControlSequence(true, new TextualContentCommand("vartheta", "theta"));
        teXParser.putControlSequence(true, new TextualContentCommand("varpi", "pi"));
        teXParser.putControlSequence(true, new TextualContentCommand("varrho", "rho"));
        teXParser.putControlSequence(true, new TextualContentCommand("varsigma", "sigma"));
        teXParser.putControlSequence(true, new TextualContentCommand("varphi", "phi"));
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

