--
-- Copyright (C) 2009-2016 John MacFarlane, Hans Hagen
--
-- Permission is hereby granted, free of charge, to any person obtaining
-- a copy of this software and associated documentation files (the
-- "Software"), to deal in the Software without restriction, including
-- without limitation the rights to use, copy, modify, merge, publish,
-- distribute, sublicense, and/or sell copies of the Software, and to
-- permit persons to whom the Software is furnished to do so, subject to
-- the following conditions:
--
-- The above copyright notice and this permission notice shall be
-- included in all copies or substantial portions of the Software.
--
-- THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
-- EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
-- MERCHANTABILITY, FITNESS FOR PARTICULAR PURPOSE AND NONINFRINGEMENT.
-- IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
-- CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
-- TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
-- SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
--
-- Copyright (C) 2016-2025 Vít Starý Novotný, Andrej Genčur
--
-- This work may be distributed and/or modified under the
-- conditions of the LaTeX Project Public License, either version 1.3
-- of this license or (at your option) any later version.
-- The latest version of this license is in
--
--     http://www.latex-project.org/lppl.txt
--
-- and version 1.3 or later is part of all distributions of LaTeX
-- version 2005/12/01 or later.
--
-- This work has the LPPL maintenance status `maintained'.
-- The Current Maintainer of this work is Vít Starý Novotný.
--
-- Send bug reports, requests for additions and questions
-- either to the GitHub issue tracker at
--
--     https://github.com/witiko/markdown/issues
--
-- or to the e-mail address <witiko@mail.muni.cz>.
--
-- MODIFICATION ADVICE:
--
-- If you want to customize this file, it is best to make a copy of
-- the source file(s) from which it was produced. Use a different
-- name for your copy(ies) and modify the copy(ies); this will ensure
-- that your modifications do not get overwritten when you install a
-- new release of the standard system. You should also ensure that
-- your modified source file does not generate any modified file with
-- the same name as a standard file.
--
-- You will also need to produce your own, suitably named, .ins file to
-- control the generation of files from your source file; this file
-- should contain your own preambles for the files it generates, not
-- those in the standard .ins files.
--
local metadata = {
    version   = "3.11.6-0-g340ac223",
    comment   = "A module for the conversion from markdown "
             .. "to plain TeX",
    author    = "John MacFarlane, Hans Hagen, Vít Starý Novotný, "
             .. "Andrej Genčur",
    copyright = {"2009-2016 John MacFarlane, Hans Hagen",
                 "2016-2024 Vít Starý Novotný, Andrej Genčur"},
    license   = "LPPL 1.3c"
}

local lpeg = require("lpeg")
local M = {metadata = metadata}
local P, R, Cc, C = lpeg.P, lpeg.R, lpeg.Cc, lpeg.C
local fail = P(false)
-- luacheck: push no max line length
M.decomposition_mapping = {}
M.decomposition_mapping.canonical = {}
M.decomposition_mapping.canonical[1] = fail
M.decomposition_mapping.canonical[2] = P("") * (P("") / "À" + P("") / "Á" + P("") / "Â" + P("") / "Ã" + P("") / "Ä" + P("") / "Å" + P("") / "Ç" + P("") / "È" + P("") / "É" + P("") / "Ê" + P("") / "Ë" + P("") / "Ì" + P("") / "Í" + P("") / "Î" + P("") / "Ï" + P("") / "Ñ" + P("") / "Ò" + P("") / "Ó" + P("") / "Ô" + P("") / "Õ" + P("") / "Ö" + P("") / "Ù" + P("") / "Ú" + P("") / "Û" + P("") / "Ü" + P("") / "Ý" + P("") / "à" + P("") / "á" + P("") / "â" + P("") / "ã" + P("") / "ä" + P("") / "å" + P("") / "ç" + P("") / "è" + P("") / "é" + P("") / "ê" + P("") / "ë" + P("") / "ì" + P("") / "í" + P("") / "î" + P("") / "ï" + P("") / "ñ" + P("") / "ò" + P("") / "ó" + P("") / "ô" + P("") / "õ" + P("") / "ö" + P("") / "ù" + P("") / "ú" + P("") / "û" + P("") / "ü" + P("") / "ý" + P("") / "ÿ") + P("") * (P("") / "ѐ" + P("") / "ё" + P("") / "ѓ" + P("") / "ї" + P("") / "ќ" + P("") / "ѝ" + P("") / "ў" + P("") / "Ѷ" + P("") / "ѷ") + P("") * (P("") / "Ѐ" + P("") / "Ё" + P("") / "Ѓ" + P("") / "Ї" + P("") / "Ќ" + P("") / "Ѝ" + P("") / "Ў" + P("") / "Й" + P("") / "й") + P("") * (P("") / "Ơ" + P("") / "ơ" + P("") / "Ư" + P("") / "ư") + P("") * (P("") / "Ń" + P("") / "ń" + P("") / "Ņ" + P("") / "ņ" + P("") / "Ň" + P("") / "ň" + P("") / "Ō" + P("") / "ō" + P("") / "Ŏ" + P("") / "ŏ" + P("") / "Ő" + P("") / "ő" + P("") / "Ŕ" + P("") / "ŕ" + P("") / "Ŗ" + P("") / "ŗ" + P("") / "Ř" + P("") / "ř" + P("") / "Ś" + P("") / "ś" + P("") / "Ŝ" + P("") / "ŝ" + P("") / "Ş" + P("") / "ş" + P("") / "Š" + P("") / "š" + P("") / "Ţ" + P("") / "ţ" + P("") / "Ť" + P("") / "ť" + P("") / "Ũ" + P("") / "ũ" + P("") / "Ū" + P("") / "ū" + P("") / "Ŭ" + P("") / "ŭ" + P("") / "Ů" + P("") / "ů" + P("") / "Ű" + P("") / "ű" + P("") / "Ų" + P("") / "ų" + P("") / "Ŵ" + P("") / "ŵ" + P("") / "Ŷ" + P("") / "ŷ" + P("") / "Ÿ" + P("") / "Ź" + P("") / "ź" + P("") / "Ż" + P("") / "ż" + P("") / "Ž" + P("") / "ž") + P("") * (P("") / "Ā" + P("") / "ā" + P("") / "Ă" + P("") / "ă" + P("") / "Ą" + P("") / "ą" + P("") / "Ć" + P("") / "ć" + P("") / "Ĉ" + P("") / "ĉ" + P("") / "Ċ" + P("") / "ċ" + P("") / "Č" + P("") / "č" + P("") / "Ď" + P("") / "ď" + P("") / "Ē" + P("") / "ē" + P("") / "Ĕ" + P("") / "ĕ" + P("") / "Ė" + P("") / "ė" + P("") / "Ę" + P("") / "ę" + P("") / "Ě" + P("") / "ě" + P("") / "Ĝ" + P("") / "ĝ" + P("") / "Ğ" + P("") / "ğ" + P("") / "Ġ" + P("") / "ġ" + P("") / "Ģ" + P("") / "ģ" + P("") / "Ĥ" + P("") / "ĥ" + P("") / "Ĩ" + P("") / "ĩ" + P("") / "Ī" + P("") / "ī" + P("") / "Ĭ" + P("") / "ĭ" + P("") / "Į" + P("") / "į" + P("") / "İ" + P("") / "Ĵ" + P("") / "ĵ" + P("") / "Ķ" + P("") / "ķ" + P("") / "Ĺ" + P("") / "ĺ" + P("") / "Ļ" + P("") / "ļ" + P("") / "Ľ" + P("") / "ľ") + P("") * (P("") / "ۀ" + P("") / "ۂ" + P("") / "ۓ") + P("") * (P("") / "آ" + P("") / "أ" + P("") / "ؤ" + P("") / "إ" + P("") / "ئ") + P("") * (P("") / "Ӂ" + P("") / "ӂ" + P("") / "Ӑ" + P("") / "ӑ" + P("") / "Ӓ" + P("") / "ӓ" + P("") / "Ӗ" + P("") / "ӗ" + P("") / "Ӛ" + P("") / "ӛ" + P("") / "Ӝ" + P("") / "ӝ" + P("") / "Ӟ" + P("") / "ӟ" + P("") / "Ӣ" + P("") / "ӣ" + P("") / "Ӥ" + P("") / "ӥ" + P("") / "Ӧ" + P("") / "ӧ" + P("") / "Ӫ" + P("") / "ӫ" + P("") / "Ӭ" + P("") / "ӭ" + P("") / "Ӯ" + P("") / "ӯ" + P("") / "Ӱ" + P("") / "ӱ" + P("") / "Ӳ" + P("") / "ӳ" + P("") / "Ӵ" + P("") / "ӵ" + P("") / "Ӹ" + P("") / "ӹ") + P("") * (P("") / "Ȁ" + P("") / "ȁ" + P("") / "Ȃ" + P("") / "ȃ" + P("") / "Ȅ" + P("") / "ȅ" + P("") / "Ȇ" + P("") / "ȇ" + P("") / "Ȉ" + P("") / "ȉ" + P("") / "Ȋ" + P("") / "ȋ" + P("") / "Ȍ" + P("") / "ȍ" + P("") / "Ȏ" + P("") / "ȏ" + P("") / "Ȑ" + P("") / "ȑ" + P("") / "Ȓ" + P("") / "ȓ" + P("") / "Ȕ" + P("") / "ȕ" + P("") / "Ȗ" + P("") / "ȗ" + P("") / "Ș" + P("") / "ș" + P("") / "Ț" + P("") / "ț" + P("") / "Ȟ" + P("") / "ȟ" + P("") / "Ȧ" + P("") / "ȧ" + P("") / "Ȩ" + P("") / "ȩ" + P("") / "Ȫ" + P("") / "ȫ" + P("") / "Ȭ" + P("") / "ȭ" + P("") / "Ȯ" + P("") / "ȯ" + P("") / "Ȱ" + P("") / "ȱ" + P("") / "Ȳ" + P("") / "ȳ") + P("") * (P("") / "ϊ" + P("") / "ϋ" + P("") / "ό" + P("") / "ύ" + P("") / "ώ" + P("") / "ϓ" + P("") / "ϔ") + P("") * (P("") / "΅" + P("") / "Ά" + P("") / "·" + P("") / "Έ" + P("") / "Ή" + P("") / "Ί" + P("") / "Ό" + P("") / "Ύ" + P("") / "Ώ" + P("") / "ΐ" + P("") / "Ϊ" + P("") / "Ϋ" + P("") / "ά" + P("") / "έ" + P("") / "ή" + P("") / "ί" + P("") / "ΰ") + P("") * (P("") / "̀" + P("") / "́" + P("") / "̓" + P("") / "̈́" + P("") / "ʹ" + P("") / ";") + P("") * (P("") / "Ǎ" + P("") / "ǎ" + P("") / "Ǐ" + P("") / "ǐ" + P("") / "Ǒ" + P("") / "ǒ" + P("") / "Ǔ" + P("") / "ǔ" + P("") / "Ǖ" + P("") / "ǖ" + P("") / "Ǘ" + P("") / "ǘ" + P("") / "Ǚ" + P("") / "ǚ" + P("") / "Ǜ" + P("") / "ǜ" + P("") / "Ǟ" + P("") / "ǟ" + P("") / "Ǡ" + P("") / "ǡ" + P("") / "Ǣ" + P("") / "ǣ" + P("") / "Ǧ" + P("") / "ǧ" + P("") / "Ǩ" + P("") / "ǩ" + P("") / "Ǫ" + P("") / "ǫ" + P("") / "Ǭ" + P("") / "ǭ" + P("") / "Ǯ" + P("") / "ǯ" + P("") / "ǰ" + P("") / "Ǵ" + P("") / "ǵ" + P("") / "Ǹ" + P("") / "ǹ" + P("") / "Ǻ" + P("") / "ǻ" + P("") / "Ǽ" + P("") / "ǽ" + P("") / "Ǿ" + P("") / "ǿ")
M.decomposition_mapping.canonical[3] = P("") * (P("") * (P("") / "ゔ" + P("") / "ゞ" + P("") / "ガ" + P("") / "ギ" + P("") / "グ" + P("") / "ゲ" + P("") / "ゴ" + P("") / "ザ" + P("") / "ジ" + P("") / "ズ" + P("") / "ゼ" + P("") / "ゾ") + P("") * (P("") / "が" + P("") / "ぎ" + P("") / "ぐ" + P("") / "げ" + P("") / "ご" + P("") / "ざ" + P("") / "じ" + P("") / "ず" + P("") / "ぜ" + P("") / "ぞ" + P("") / "だ" + P("") / "ぢ" + P("") / "づ" + P("") / "で" + P("") / "ど" + P("") / "ば" + P("") / "ぱ" + P("") / "び" + P("") / "ぴ" + P("") / "ぶ" + P("") / "ぷ" + P("") / "べ" + P("") / "ぺ" + P("") / "ぼ" + P("") / "ぽ") + P("") * (P("") / "ダ" + P("") / "ヂ" + P("") / "ヅ" + P("") / "デ" + P("") / "ド" + P("") / "バ" + P("") / "パ" + P("") / "ビ" + P("") / "ピ" + P("") / "ブ" + P("") / "プ" + P("") / "ベ" + P("") / "ペ" + P("") / "ボ" + P("") / "ポ" + P("") / "ヴ" + P("") / "ヷ" + P("") / "ヸ" + P("") / "ヹ" + P("") / "ヺ" + P("") / "ヾ")) + P("") * (P("") * (P("") / " " + P("") / " ") + P("") * (P("") / "⇍" + P("") / "⇎" + P("") / "⇏") + P("") * (P("") / "↚" + P("") / "↛" + P("") / "↮") + P("") * (P("") / "Ω" + P("") / "K" + P("") / "Å") + P("") * (P("") / "⋠" + P("") / "⋡" + P("") / "⋢" + P("") / "⋣" + P("") / "⋪" + P("") / "⋫" + P("") / "⋬" + P("") / "⋭") + P("") * (P("") / "⊀" + P("") / "⊁" + P("") / "⊄" + P("") / "⊅" + P("") / "⊈" + P("") / "⊉" + P("") / "⊬" + P("") / "⊭" + P("") / "⊮" + P("") / "⊯") + P("") * (P("") / "≁" + P("") / "≄" + P("") / "≇" + P("") / "≉" + P("") / "≠" + P("") / "≢" + P("") / "≭" + P("") / "≮" + P("") / "≯" + P("") / "≰" + P("") / "≱" + P("") / "≴" + P("") / "≵" + P("") / "≸" + P("") / "≹") + P("") * (P("") / "∄" + P("") / "∉" + P("") / "∌" + P("") / "∤" + P("") / "∦") + P("") * P("") / "⫝̸" + P("") * (P("") / "〈" + P("") / "〉")) + P("") * (P("") * P("") / "ဦ" + P("") * (P("") / "ὀ" + P("") / "ὁ" + P("") / "ὂ" + P("") / "ὃ" + P("") / "ὄ" + P("") / "ὅ" + P("") / "Ὀ" + P("") / "Ὁ" + P("") / "Ὂ" + P("") / "Ὃ" + P("") / "Ὄ" + P("") / "Ὅ" + P("") / "ὐ" + P("") / "ὑ" + P("") / "ὒ" + P("") / "ὓ" + P("") / "ὔ" + P("") / "ὕ" + P("") / "ὖ" + P("") / "ὗ" + P("") / "Ὑ" + P("") / "Ὓ" + P("") / "Ὕ" + P("") / "Ὗ" + P("") / "ὠ" + P("") / "ὡ" + P("") / "ὢ" + P("") / "ὣ" + P("") / "ὤ" + P("") / "ὥ" + P("") / "ὦ" + P("") / "ὧ" + P("") / "Ὠ" + P("") / "Ὡ" + P("") / "Ὢ" + P("") / "Ὣ" + P("") / "Ὤ" + P("") / "Ὥ" + P("") / "Ὦ" + P("") / "Ὧ" + P("") / "ὰ" + P("") / "ά" + P("") / "ὲ" + P("") / "έ" + P("") / "ὴ" + P("") / "ή" + P("") / "ὶ" + P("") / "ί" + P("") / "ὸ" + P("") / "ό" + P("") / "ὺ" + P("") / "ύ" + P("") / "ὼ" + P("") / "ώ") + P("") * (P("") / "ἀ" + P("") / "ἁ" + P("") / "ἂ" + P("") / "ἃ" + P("") / "ἄ" + P("") / "ἅ" + P("") / "ἆ" + P("") / "ἇ" + P("") / "Ἀ" + P("") / "Ἁ" + P("") / "Ἂ" + P("") / "Ἃ" + P("") / "Ἄ" + P("") / "Ἅ" + P("") / "Ἆ" + P("") / "Ἇ" + P("") / "ἐ" + P("") / "ἑ" + P("") / "ἒ" + P("") / "ἓ" + P("") / "ἔ" + P("") / "ἕ" + P("") / "Ἐ" + P("") / "Ἑ" + P("") / "Ἒ" + P("") / "Ἓ" + P("") / "Ἔ" + P("") / "Ἕ" + P("") / "ἠ" + P("") / "ἡ" + P("") / "ἢ" + P("") / "ἣ" + P("") / "ἤ" + P("") / "ἥ" + P("") / "ἦ" + P("") / "ἧ" + P("") / "Ἠ" + P("") / "Ἡ" + P("") / "Ἢ" + P("") / "Ἣ" + P("") / "Ἤ" + P("") / "Ἥ" + P("") / "Ἦ" + P("") / "Ἧ" + P("") / "ἰ" + P("") / "ἱ" + P("") / "ἲ" + P("") / "ἳ" + P("") / "ἴ" + P("") / "ἵ" + P("") / "ἶ" + P("") / "ἷ" + P("") / "Ἰ" + P("") / "Ἱ" + P("") / "Ἲ" + P("") / "Ἳ" + P("") / "Ἴ" + P("") / "Ἵ" + P("") / "Ἶ" + P("") / "Ἷ") + P("") * (P("") / "Ề" + P("") / "ề" + P("") / "Ể" + P("") / "ể" + P("") / "Ễ" + P("") / "ễ" + P("") / "Ệ" + P("") / "ệ" + P("") / "Ỉ" + P("") / "ỉ" + P("") / "Ị" + P("") / "ị" + P("") / "Ọ" + P("") / "ọ" + P("") / "Ỏ" + P("") / "ỏ" + P("") / "Ố" + P("") / "ố" + P("") / "Ồ" + P("") / "ồ" + P("") / "Ổ" + P("") / "ổ" + P("") / "Ỗ" + P("") / "ỗ" + P("") / "Ộ" + P("") / "ộ" + P("") / "Ớ" + P("") / "ớ" + P("") / "Ờ" + P("") / "ờ" + P("") / "Ở" + P("") / "ở" + P("") / "Ỡ" + P("") / "ỡ" + P("") / "Ợ" + P("") / "ợ" + P("") / "Ụ" + P("") / "ụ" + P("") / "Ủ" + P("") / "ủ" + P("") / "Ứ" + P("") / "ứ" + P("") / "Ừ" + P("") / "ừ" + P("") / "Ử" + P("") / "ử" + P("") / "Ữ" + P("") / "ữ" + P("") / "Ự" + P("") / "ự" + P("") / "Ỳ" + P("") / "ỳ" + P("") / "Ỵ" + P("") / "ỵ" + P("") / "Ỷ" + P("") / "ỷ" + P("") / "Ỹ" + P("") / "ỹ") + P("") * (P("") / "Ẁ" + P("") / "ẁ" + P("") / "Ẃ" + P("") / "ẃ" + P("") / "Ẅ" + P("") / "ẅ" + P("") / "Ẇ" + P("") / "ẇ" + P("") / "Ẉ" + P("") / "ẉ" + P("") / "Ẋ" + P("") / "ẋ" + P("") / "Ẍ" + P("") / "ẍ" + P("") / "Ẏ" + P("") / "ẏ" + P("") / "Ẑ" + P("") / "ẑ" + P("") / "Ẓ" + P("") / "ẓ" + P("") / "Ẕ" + P("") / "ẕ" + P("") / "ẖ" + P("") / "ẗ" + P("") / "ẘ" + P("") / "ẙ" + P("") / "ẛ" + P("") / "Ạ" + P("") / "ạ" + P("") / "Ả" + P("") / "ả" + P("") / "Ấ" + P("") / "ấ" + P("") / "Ầ" + P("") / "ầ" + P("") / "Ẩ" + P("") / "ẩ" + P("") / "Ẫ" + P("") / "ẫ" + P("") / "Ậ" + P("") / "ậ" + P("") / "Ắ" + P("") / "ắ" + P("") / "Ằ" + P("") / "ằ" + P("") / "Ẳ" + P("") / "ẳ" + P("") / "Ẵ" + P("") / "ẵ" + P("") / "Ặ" + P("") / "ặ" + P("") / "Ẹ" + P("") / "ẹ" + P("") / "Ẻ" + P("") / "ẻ" + P("") / "Ẽ" + P("") / "ẽ" + P("") / "Ế" + P("") / "ế") + P("") * (P("") / "Ṁ" + P("") / "ṁ" + P("") / "Ṃ" + P("") / "ṃ" + P("") / "Ṅ" + P("") / "ṅ" + P("") / "Ṇ" + P("") / "ṇ" + P("") / "Ṉ" + P("") / "ṉ" + P("") / "Ṋ" + P("") / "ṋ" + P("") / "Ṍ" + P("") / "ṍ" + P("") / "Ṏ" + P("") / "ṏ" + P("") / "Ṑ" + P("") / "ṑ" + P("") / "Ṓ" + P("") / "ṓ" + P("") / "Ṕ" + P("") / "ṕ" + P("") / "Ṗ" + P("") / "ṗ" + P("") / "Ṙ" + P("") / "ṙ" + P("") / "Ṛ" + P("") / "ṛ" + P("") / "Ṝ" + P("") / "ṝ" + P("") / "Ṟ" + P("") / "ṟ" + P("") / "Ṡ" + P("") / "ṡ" + P("") / "Ṣ" + P("") / "ṣ" + P("") / "Ṥ" + P("") / "ṥ" + P("") / "Ṧ" + P("") / "ṧ" + P("") / "Ṩ" + P("") / "ṩ" + P("") / "Ṫ" + P("") / "ṫ" + P("") / "Ṭ" + P("") / "ṭ" + P("") / "Ṯ" + P("") / "ṯ" + P("") / "Ṱ" + P("") / "ṱ" + P("") / "Ṳ" + P("") / "ṳ" + P("") / "Ṵ" + P("") / "ṵ" + P("") / "Ṷ" + P("") / "ṷ" + P("") / "Ṹ" + P("") / "ṹ" + P("") / "Ṻ" + P("") / "ṻ" + P("") / "Ṽ" + P("") / "ṽ" + P("") / "Ṿ" + P("") / "ṿ") + P("") * (P("") / "Ḁ" + P("") / "ḁ" + P("") / "Ḃ" + P("") / "ḃ" + P("") / "Ḅ" + P("") / "ḅ" + P("") / "Ḇ" + P("") / "ḇ" + P("") / "Ḉ" + P("") / "ḉ" + P("") / "Ḋ" + P("") / "ḋ" + P("") / "Ḍ" + P("") / "ḍ" + P("") / "Ḏ" + P("") / "ḏ" + P("") / "Ḑ" + P("") / "ḑ" + P("") / "Ḓ" + P("") / "ḓ" + P("") / "Ḕ" + P("") / "ḕ" + P("") / "Ḗ" + P("") / "ḗ" + P("") / "Ḙ" + P("") / "ḙ" + P("") / "Ḛ" + P("") / "ḛ" + P("") / "Ḝ" + P("") / "ḝ" + P("") / "Ḟ" + P("") / "ḟ" + P("") / "Ḡ" + P("") / "ḡ" + P("") / "Ḣ" + P("") / "ḣ" + P("") / "Ḥ" + P("") / "ḥ" + P("") / "Ḧ" + P("") / "ḧ" + P("") / "Ḩ" + P("") / "ḩ" + P("") / "Ḫ" + P("") / "ḫ" + P("") / "Ḭ" + P("") / "ḭ" + P("") / "Ḯ" + P("") / "ḯ" + P("") / "Ḱ" + P("") / "ḱ" + P("") / "Ḳ" + P("") / "ḳ" + P("") / "Ḵ" + P("") / "ḵ" + P("") / "Ḷ" + P("") / "ḷ" + P("") / "Ḹ" + P("") / "ḹ" + P("") / "Ḻ" + P("") / "ḻ" + P("") / "Ḽ" + P("") / "ḽ" + P("") / "Ḿ" + P("") / "ḿ") + P("") * (P("") / "῁" + P("") / "ῂ" + P("") / "ῃ" + P("") / "ῄ" + P("") / "ῆ" + P("") / "ῇ" + P("") / "Ὲ" + P("") / "Έ" + P("") / "Ὴ" + P("") / "Ή" + P("") / "ῌ" + P("") / "῍" + P("") / "῎" + P("") / "῏" + P("") / "ῐ" + P("") / "ῑ" + P("") / "ῒ" + P("") / "ΐ" + P("") / "ῖ" + P("") / "ῗ" + P("") / "Ῐ" + P("") / "Ῑ" + P("") / "Ὶ" + P("") / "Ί" + P("") / "῝" + P("") / "῞" + P("") / "῟" + P("") / "ῠ" + P("") / "ῡ" + P("") / "ῢ" + P("") / "ΰ" + P("") / "ῤ" + P("") / "ῥ" + P("") / "ῦ" + P("") / "ῧ" + P("") / "Ῠ" + P("") / "Ῡ" + P("") / "Ὺ" + P("") / "Ύ" + P("") / "Ῥ" + P("") / "῭" + P("") / "΅" + P("") / "`" + P("") / "ῲ" + P("") / "ῳ" + P("") / "ῴ" + P("") / "ῶ" + P("") / "ῷ" + P("") / "Ὸ" + P("") / "Ό" + P("") / "Ὼ" + P("") / "Ώ" + P("") / "ῼ" + P("") / "´") + P("") * (P("") / "ᾀ" + P("") / "ᾁ" + P("") / "ᾂ" + P("") / "ᾃ" + P("") / "ᾄ" + P("") / "ᾅ" + P("") / "ᾆ" + P("") / "ᾇ" + P("") / "ᾈ" + P("") / "ᾉ" + P("") / "ᾊ" + P("") / "ᾋ" + P("") / "ᾌ" + P("") / "ᾍ" + P("") / "ᾎ" + P("") / "ᾏ" + P("") / "ᾐ" + P("") / "ᾑ" + P("") / "ᾒ" + P("") / "ᾓ" + P("") / "ᾔ" + P("") / "ᾕ" + P("") / "ᾖ" + P("") / "ᾗ" + P("") / "ᾘ" + P("") / "ᾙ" + P("") / "ᾚ" + P("") / "ᾛ" + P("") / "ᾜ" + P("") / "ᾝ" + P("") / "ᾞ" + P("") / "ᾟ" + P("") / "ᾠ" + P("") / "ᾡ" + P("") / "ᾢ" + P("") / "ᾣ" + P("") / "ᾤ" + P("") / "ᾥ" + P("") / "ᾦ" + P("") / "ᾧ" + P("") / "ᾨ" + P("") / "ᾩ" + P("") / "ᾪ" + P("") / "ᾫ" + P("") / "ᾬ" + P("") / "ᾭ" + P("") / "ᾮ" + P("") / "ᾯ" + P("") / "ᾰ" + P("") / "ᾱ" + P("") / "ᾲ" + P("") / "ᾳ" + P("") / "ᾴ" + P("") / "ᾶ" + P("") / "ᾷ" + P("") / "Ᾰ" + P("") / "Ᾱ" + P("") / "Ὰ" + P("") / "Ά" + P("") / "ᾼ" + P("") / "ι") + P("") * (P("") / "ᭀ" + P("") / "ᭁ" + P("") / "ᭃ") + P("") * (P("") / "ᬆ" + P("") / "ᬈ" + P("") / "ᬊ" + P("") / "ᬌ" + P("") / "ᬎ" + P("") / "ᬒ" + P("") / "ᬻ" + P("") / "ᬽ")) + P("") * (P("") * (P("") / "ೀ" + P("") / "ೇ" + P("") / "ೈ" + P("") / "ೊ" + P("") / "ೋ") + P("") * P("") / "ై" + P("") * (P("") / "ཱྀ" + P("") / "ྒྷ" + P("") / "ྜྷ" + P("") / "ྡྷ" + P("") / "ྦྷ" + P("") / "ྫྷ" + P("") / "ྐྵ") + P("") * (P("") / "ো" + P("") / "ৌ" + P("") / "ড়" + P("") / "ঢ়" + P("") / "য়") + P("") * (P("") / "གྷ" + P("") / "ཌྷ" + P("") / "དྷ" + P("") / "བྷ" + P("") / "ཛྷ" + P("") / "ཀྵ" + P("") / "ཱི" + P("") / "ཱུ" + P("") / "ྲྀ" + P("") / "ླྀ") + P("") * (P("") / "क़" + P("") / "ख़" + P("") / "ग़" + P("") / "ज़" + P("") / "ड़" + P("") / "ढ़" + P("") / "फ़" + P("") / "य़") + P("") * (P("") / "ऩ" + P("") / "ऱ" + P("") / "ऴ") + P("") * (P("") / "ේ" + P("") / "ො" + P("") / "ෝ" + P("") / "ෞ") + P("") * (P("") / "ൊ" + P("") / "ോ" + P("") / "ൌ") + P("") * (P("") / "ਖ਼" + P("") / "ਗ਼" + P("") / "ਜ਼" + P("") / "ਫ਼") + P("") * (P("") / "ਲ਼" + P("") / "ਸ਼") + P("") * (P("") / "ொ" + P("") / "ோ" + P("") / "ௌ") + P("") * P("") / "ஔ" + P("") * (P("") / "ୈ" + P("") / "ୋ" + P("") / "ୌ" + P("") / "ଡ଼" + P("") / "ଢ଼")) + P("") * (P("") * (P("") / "呂" + P("") / "女" + P("") / "廬" + P("") / "旅" + P("") / "濾" + P("") / "礪" + P("") / "閭" + P("") / "驪" + P("") / "麗" + P("") / "黎" + P("") / "力" + P("") / "曆" + P("") / "歷" + P("") / "轢" + P("") / "年" + P("") / "憐" + P("") / "戀" + P("") / "撚" + P("") / "漣" + P("") / "煉" + P("") / "璉" + P("") / "秊" + P("") / "練" + P("") / "聯" + P("") / "輦" + P("") / "蓮" + P("") / "連" + P("") / "鍊" + P("") / "列" + P("") / "劣" + P("") / "咽" + P("") / "烈" + P("") / "裂" + P("") / "說" + P("") / "廉" + P("") / "念" + P("") / "捻" + P("") / "殮" + P("") / "簾" + P("") / "獵" + P("") / "令" + P("") / "囹" + P("") / "寧" + P("") / "嶺" + P("") / "怜" + P("") / "玲" + P("") / "瑩" + P("") / "羚" + P("") / "聆" + P("") / "鈴" + P("") / "零" + P("") / "靈" + P("") / "領" + P("") / "例" + P("") / "禮" + P("") / "醴" + P("") / "隸" + P("") / "惡" + P("") / "了" + P("") / "僚" + P("") / "寮" + P("") / "尿" + P("") / "料" + P("") / "樂") + P("") * (P("") / "鹿" + P("") / "論" + P("") / "壟" + P("") / "弄" + P("") / "籠" + P("") / "聾" + P("") / "牢" + P("") / "磊" + P("") / "賂" + P("") / "雷" + P("") / "壘" + P("") / "屢" + P("") / "樓" + P("") / "淚" + P("") / "漏" + P("") / "累" + P("") / "縷" + P("") / "陋" + P("") / "勒" + P("") / "肋" + P("") / "凜" + P("") / "凌" + P("") / "稜" + P("") / "綾" + P("") / "菱" + P("") / "陵" + P("") / "讀" + P("") / "拏" + P("") / "樂" + P("") / "諾" + P("") / "丹" + P("") / "寧" + P("") / "怒" + P("") / "率" + P("") / "異" + P("") / "北" + P("") / "磻" + P("") / "便" + P("") / "復" + P("") / "不" + P("") / "泌" + P("") / "數" + P("") / "索" + P("") / "參" + P("") / "塞" + P("") / "省" + P("") / "葉" + P("") / "說" + P("") / "殺" + P("") / "辰" + P("") / "沈" + P("") / "拾" + P("") / "若" + P("") / "掠" + P("") / "略" + P("") / "亮" + P("") / "兩" + P("") / "凉" + P("") / "梁" + P("") / "糧" + P("") / "良" + P("") / "諒" + P("") / "量" + P("") / "勵") + P("") * (P("") / "豈" + P("") / "更" + P("") / "車" + P("") / "賈" + P("") / "滑" + P("") / "串" + P("") / "句" + P("") / "龜" + P("") / "龜" + P("") / "契" + P("") / "金" + P("") / "喇" + P("") / "奈" + P("") / "懶" + P("") / "癩" + P("") / "羅" + P("") / "蘿" + P("") / "螺" + P("") / "裸" + P("") / "邏" + P("") / "樂" + P("") / "洛" + P("") / "烙" + P("") / "珞" + P("") / "落" + P("") / "酪" + P("") / "駱" + P("") / "亂" + P("") / "卵" + P("") / "欄" + P("") / "爛" + P("") / "蘭" + P("") / "鸞" + P("") / "嵐" + P("") / "濫" + P("") / "藍" + P("") / "襤" + P("") / "拉" + P("") / "臘" + P("") / "蠟" + P("") / "廊" + P("") / "朗" + P("") / "浪" + P("") / "狼" + P("") / "郎" + P("") / "來" + P("") / "冷" + P("") / "勞" + P("") / "擄" + P("") / "櫓" + P("") / "爐" + P("") / "盧" + P("") / "老" + P("") / "蘆" + P("") / "虜" + P("") / "路" + P("") / "露" + P("") / "魯" + P("") / "鷺" + P("") / "碌" + P("") / "祿" + P("") / "綠" + P("") / "菉" + P("") / "錄") + P("") * (P("") / "變" + P("") / "贈" + P("") / "輸" + P("") / "遲" + P("") / "醙" + P("") / "鉶" + P("") / "陼" + P("") / "難" + P("") / "靖" + P("") / "韛" + P("") / "響" + P("") / "頋" + P("") / "頻" + P("") / "鬒" + P("") / "龜" + P("") / "𢡊" + P("") / "𢡄" + P("") / "𣏕" + P("") / "㮝" + P("") / "䀘" + P("") / "䀹" + P("") / "𥉉" + P("") / "𥳐" + P("") / "𧻓" + P("") / "齃" + P("") / "龎") + P("") * (P("") / "婢" + P("") / "嬨" + P("") / "廒" + P("") / "廙" + P("") / "彩" + P("") / "徭" + P("") / "惘" + P("") / "慎" + P("") / "愈" + P("") / "憎" + P("") / "慠" + P("") / "懲" + P("") / "戴" + P("") / "揄" + P("") / "搜" + P("") / "摒" + P("") / "敖" + P("") / "晴" + P("") / "朗" + P("") / "望" + P("") / "杖" + P("") / "歹" + P("") / "殺" + P("") / "流" + P("") / "滛" + P("") / "滋" + P("") / "漢" + P("") / "瀞" + P("") / "煮" + P("") / "瞧" + P("") / "爵" + P("") / "犯" + P("") / "猪" + P("") / "瑱" + P("") / "甆" + P("") / "画" + P("") / "瘝" + P("") / "瘟" + P("") / "益" + P("") / "盛" + P("") / "直" + P("") / "睊" + P("") / "着" + P("") / "磌" + P("") / "窱" + P("") / "節" + P("") / "类" + P("") / "絛" + P("") / "練" + P("") / "缾" + P("") / "者" + P("") / "荒" + P("") / "華" + P("") / "蝹" + P("") / "襁" + P("") / "覆" + P("") / "視" + P("") / "調" + P("") / "諸" + P("") / "請" + P("") / "謁" + P("") / "諾" + P("") / "諭" + P("") / "謹") + P("") * (P("") / "懲" + P("") / "敏" + P("") / "既" + P("") / "暑" + P("") / "梅" + P("") / "海" + P("") / "渚" + P("") / "漢" + P("") / "煮" + P("") / "爫" + P("") / "琢" + P("") / "碑" + P("") / "社" + P("") / "祉" + P("") / "祈" + P("") / "祐" + P("") / "祖" + P("") / "祝" + P("") / "禍" + P("") / "禎" + P("") / "穀" + P("") / "突" + P("") / "節" + P("") / "練" + P("") / "縉" + P("") / "繁" + P("") / "署" + P("") / "者" + P("") / "臭" + P("") / "艹" + P("") / "艹" + P("") / "著" + P("") / "褐" + P("") / "視" + P("") / "謁" + P("") / "謹" + P("") / "賓" + P("") / "贈" + P("") / "辶" + P("") / "逸" + P("") / "難" + P("") / "響" + P("") / "頻" + P("") / "恵" + P("") / "𤋮" + P("") / "舘" + P("") / "並" + P("") / "况" + P("") / "全" + P("") / "侀" + P("") / "充" + P("") / "冀" + P("") / "勇" + P("") / "勺" + P("") / "喝" + P("") / "啕" + P("") / "喙" + P("") / "嗢" + P("") / "塚" + P("") / "墳" + P("") / "奄" + P("") / "奔") + P("") * (P("") / "切" + P("") / "度" + P("") / "拓" + P("") / "糖" + P("") / "宅" + P("") / "洞" + P("") / "暴" + P("") / "輻" + P("") / "行" + P("") / "降" + P("") / "見" + P("") / "廓" + P("") / "兀" + P("") / "嗀" + P("") / "塚" + P("") / "晴" + P("") / "凞" + P("") / "猪" + P("") / "益" + P("") / "礼" + P("") / "神" + P("") / "祥" + P("") / "福" + P("") / "靖" + P("") / "精" + P("") / "羽" + P("") / "蘒" + P("") / "諸" + P("") / "逸" + P("") / "都" + P("") / "飯" + P("") / "飼" + P("") / "館" + P("") / "鶴" + P("") / "郞" + P("") / "隷" + P("") / "侮" + P("") / "僧" + P("") / "免" + P("") / "勉" + P("") / "勤" + P("") / "卑" + P("") / "喝" + P("") / "嘆" + P("") / "器" + P("") / "塀" + P("") / "墨" + P("") / "層" + P("") / "屮" + P("") / "悔" + P("") / "慨" + P("") / "憎") + P("") * (P("") / "燎" + P("") / "療" + P("") / "蓼" + P("") / "遼" + P("") / "龍" + P("") / "暈" + P("") / "阮" + P("") / "劉" + P("") / "杻" + P("") / "柳" + P("") / "流" + P("") / "溜" + P("") / "琉" + P("") / "留" + P("") / "硫" + P("") / "紐" + P("") / "類" + P("") / "六" + P("") / "戮" + P("") / "陸" + P("") / "倫" + P("") / "崙" + P("") / "淪" + P("") / "輪" + P("") / "律" + P("") / "慄" + P("") / "栗" + P("") / "率" + P("") / "隆" + P("") / "利" + P("") / "吏" + P("") / "履" + P("") / "易" + P("") / "李" + P("") / "梨" + P("") / "泥" + P("") / "理" + P("") / "痢" + P("") / "罹" + P("") / "裏" + P("") / "裡" + P("") / "里" + P("") / "離" + P("") / "匿" + P("") / "溺" + P("") / "吝" + P("") / "燐" + P("") / "璘" + P("") / "藺" + P("") / "隣" + P("") / "鱗" + P("") / "麟" + P("") / "林" + P("") / "淋" + P("") / "臨" + P("") / "立" + P("") / "笠" + P("") / "粒" + P("") / "狀" + P("") / "炙" + P("") / "識" + P("") / "什" + P("") / "茶" + P("") / "刺") + P("") * (P("") / "נּ" + P("") / "סּ" + P("") / "ףּ" + P("") / "פּ" + P("") / "צּ" + P("") / "קּ" + P("") / "רּ" + P("") / "שּ" + P("") / "תּ" + P("") / "וֹ" + P("") / "בֿ" + P("") / "כֿ" + P("") / "פֿ") + P("") * (P("") / "יִ" + P("") / "ײַ" + P("") / "שׁ" + P("") / "שׂ" + P("") / "שּׁ" + P("") / "שּׂ" + P("") / "אַ" + P("") / "אָ" + P("") / "אּ" + P("") / "בּ" + P("") / "גּ" + P("") / "דּ" + P("") / "הּ" + P("") / "וּ" + P("") / "זּ" + P("") / "טּ" + P("") / "יּ" + P("") / "ךּ" + P("") / "כּ" + P("") / "לּ" + P("") / "מּ"))
M.decomposition_mapping.canonical[4] = P("") * (P("") * (P("") * (P("") / "𑒻" + P("") / "𑒼" + P("") / "𑒾") + P("") * (P("") / "𑖺" + P("") / "𑖻") + P("") * (P("") / "𑄮" + P("") / "𑄯") + P("") * P("") / "𑤸" + P("") * (P("") / "𑏅" + P("") / "𑏇" + P("") / "𑏈") + P("") * (P("") / "𑎃" + P("") / "𑎅" + P("") / "𑎎" + P("") / "𑎑") + P("") * (P("") / "𑍋" + P("") / "𑍌") + P("") * (P("") / "𑂚" + P("") / "𑂜" + P("") / "𑂫")) + P("") * (P("") * (P("") / "𐗉" + P("") / "𐗤")) + P("") * (P("") * (P("") / "𖵨" + P("") / "𖵩" + P("") / "𖵪") + P("") * (P("") / "𖄡" + P("") / "𖄢" + P("") / "𖄣" + P("") / "𖄤" + P("") / "𖄥" + P("") / "𖄦" + P("") / "𖄧" + P("") / "𖄨")) + P("") * (P("") * (P("") / "𝆹𝅥" + P("") / "𝆺𝅥" + P("") / "𝆹𝅥𝅮" + P("") / "𝆺𝅥𝅮" + P("") / "𝆹𝅥𝅯") + P("") * (P("") / "𝅗𝅥" + P("") / "𝅘𝅥" + P("") / "𝅘𝅥𝅮" + P("") / "𝅘𝅥𝅯" + P("") / "𝅘𝅥𝅰" + P("") / "𝅘𝅥𝅱" + P("") / "𝅘𝅥𝅲") + P("") * P("") / "𝆺𝅥𝅯") + P("") * (P("") * (P("") / "揅" + P("") / "掩" + P("") / "㨮" + P("") / "摩" + P("") / "摾" + P("") / "撝" + P("") / "摷" + P("") / "㩬" + P("") / "敏" + P("") / "敬" + P("") / "𣀊" + P("") / "旣" + P("") / "書" + P("") / "晉" + P("") / "㬙" + P("") / "暑" + P("") / "㬈" + P("") / "㫤" + P("") / "冒" + P("") / "冕" + P("") / "最" + P("") / "暜" + P("") / "肭" + P("") / "䏙" + P("") / "朗" + P("") / "望" + P("") / "朡" + P("") / "杞" + P("") / "杓" + P("") / "𣏃" + P("") / "㭉" + P("") / "柺" + P("") / "枅" + P("") / "桒" + P("") / "梅" + P("") / "𣑭" + P("") / "梎" + P("") / "栟" + P("") / "椔" + P("") / "㮝" + P("") / "楂" + P("") / "榣" + P("") / "槪" + P("") / "檨" + P("") / "𣚣" + P("") / "櫛" + P("") / "㰘" + P("") / "次" + P("") / "𣢧" + P("") / "歔" + P("") / "㱎" + P("") / "歲" + P("") / "殟" + P("") / "殺" + P("") / "殻" + P("") / "𣪍" + P("") / "𡴋" + P("") / "𣫺" + P("") / "汎" + P("") / "𣲼" + P("") / "沿" + P("") / "泍" + P("") / "汧" + P("") / "洖") + P("") * (P("") / "嵼" + P("") / "巡" + P("") / "巢" + P("") / "㠯" + P("") / "巽" + P("") / "帨" + P("") / "帽" + P("") / "幩" + P("") / "㡢" + P("") / "𢆃" + P("") / "㡼" + P("") / "庰" + P("") / "庳" + P("") / "庶" + P("") / "廊" + P("") / "𪎒" + P("") / "廾" + P("") / "𢌱" + P("") / "𢌱" + P("") / "舁" + P("") / "弢" + P("") / "弢" + P("") / "㣇" + P("") / "𣊸" + P("") / "𦇚" + P("") / "形" + P("") / "彫" + P("") / "㣣" + P("") / "徚" + P("") / "忍" + P("") / "志" + P("") / "忹" + P("") / "悁" + P("") / "㤺" + P("") / "㤜" + P("") / "悔" + P("") / "𢛔" + P("") / "惇" + P("") / "慈" + P("") / "慌" + P("") / "慎" + P("") / "慌" + P("") / "慺" + P("") / "憎" + P("") / "憲" + P("") / "憤" + P("") / "憯" + P("") / "懞" + P("") / "懲" + P("") / "懶" + P("") / "成" + P("") / "戛" + P("") / "扝" + P("") / "抱" + P("") / "拔" + P("") / "捐" + P("") / "𢬌" + P("") / "挽" + P("") / "拼" + P("") / "捨" + P("") / "掃" + P("") / "揤" + P("") / "𢯱" + P("") / "搢") + P("") * (P("") / "咢" + P("") / "哶" + P("") / "唐" + P("") / "啓" + P("") / "啣" + P("") / "善" + P("") / "善" + P("") / "喙" + P("") / "喫" + P("") / "喳" + P("") / "嗂" + P("") / "圖" + P("") / "嘆" + P("") / "圗" + P("") / "噑" + P("") / "噴" + P("") / "切" + P("") / "壮" + P("") / "城" + P("") / "埴" + P("") / "堍" + P("") / "型" + P("") / "堲" + P("") / "報" + P("") / "墬" + P("") / "𡓤" + P("") / "売" + P("") / "壷" + P("") / "夆" + P("") / "多" + P("") / "夢" + P("") / "奢" + P("") / "𡚨" + P("") / "𡛪" + P("") / "姬" + P("") / "娛" + P("") / "娧" + P("") / "姘" + P("") / "婦" + P("") / "㛮" + P("") / "㛼" + P("") / "嬈" + P("") / "嬾" + P("") / "嬾" + P("") / "𡧈" + P("") / "寃" + P("") / "寘" + P("") / "寧" + P("") / "寳" + P("") / "𡬘" + P("") / "寿" + P("") / "将" + P("") / "当" + P("") / "尢" + P("") / "㞁" + P("") / "屠" + P("") / "屮" + P("") / "峀" + P("") / "岍" + P("") / "𡷤" + P("") / "嵃" + P("") / "𡷦" + P("") / "嵮" + P("") / "嵫") + P("") * (P("") / "丽" + P("") / "丸" + P("") / "乁" + P("") / "𠄢" + P("") / "你" + P("") / "侮" + P("") / "侻" + P("") / "倂" + P("") / "偺" + P("") / "備" + P("") / "僧" + P("") / "像" + P("") / "㒞" + P("") / "𠘺" + P("") / "免" + P("") / "兔" + P("") / "兤" + P("") / "具" + P("") / "𠔜" + P("") / "㒹" + P("") / "內" + P("") / "再" + P("") / "𠕋" + P("") / "冗" + P("") / "冤" + P("") / "仌" + P("") / "冬" + P("") / "况" + P("") / "𩇟" + P("") / "凵" + P("") / "刃" + P("") / "㓟" + P("") / "刻" + P("") / "剆" + P("") / "割" + P("") / "剷" + P("") / "㔕" + P("") / "勇" + P("") / "勉" + P("") / "勤" + P("") / "勺" + P("") / "包" + P("") / "匆" + P("") / "北" + P("") / "卉" + P("") / "卑" + P("") / "博" + P("") / "即" + P("") / "卽" + P("") / "卿" + P("") / "卿" + P("") / "卿" + P("") / "𠨬" + P("") / "灰" + P("") / "及" + P("") / "叟" + P("") / "𠭣" + P("") / "叫" + P("") / "叱" + P("") / "吆" + P("") / "咞" + P("") / "吸" + P("") / "呈" + P("") / "周") + P("") * (P("") / "𣍟" + P("") / "䏕" + P("") / "育" + P("") / "脃" + P("") / "䐋" + P("") / "脾" + P("") / "媵" + P("") / "𦞧" + P("") / "𦞵" + P("") / "𣎓" + P("") / "𣎜" + P("") / "舁" + P("") / "舄" + P("") / "辞" + P("") / "䑫" + P("") / "芑" + P("") / "芋" + P("") / "芝" + P("") / "劳" + P("") / "花" + P("") / "芳" + P("") / "芽" + P("") / "苦" + P("") / "𦬼" + P("") / "若" + P("") / "茝" + P("") / "荣" + P("") / "莭" + P("") / "茣" + P("") / "莽" + P("") / "菧" + P("") / "著" + P("") / "荓" + P("") / "菊" + P("") / "菌" + P("") / "菜" + P("") / "𦰶" + P("") / "𦵫" + P("") / "𦳕" + P("") / "䔫" + P("") / "蓱" + P("") / "蓳" + P("") / "蔖" + P("") / "𧏊" + P("") / "蕤" + P("") / "𦼬" + P("") / "䕝" + P("") / "䕡" + P("") / "𦾱" + P("") / "𧃒" + P("") / "䕫" + P("") / "虐" + P("") / "虜" + P("") / "虧" + P("") / "虩" + P("") / "蚩" + P("") / "蚈" + P("") / "蜎" + P("") / "蛢" + P("") / "蝹" + P("") / "蜨" + P("") / "蝫" + P("") / "螆" + P("") / "䗗") + P("") * (P("") / "直" + P("") / "𥃳" + P("") / "𥃲" + P("") / "𥄙" + P("") / "𥄳" + P("") / "眞" + P("") / "真" + P("") / "真" + P("") / "睊" + P("") / "䀹" + P("") / "瞋" + P("") / "䁆" + P("") / "䂖" + P("") / "𥐝" + P("") / "硎" + P("") / "碌" + P("") / "磌" + P("") / "䃣" + P("") / "𥘦" + P("") / "祖" + P("") / "𥚚" + P("") / "𥛅" + P("") / "福" + P("") / "秫" + P("") / "䄯" + P("") / "穀" + P("") / "穊" + P("") / "穏" + P("") / "𥥼" + P("") / "𥪧" + P("") / "𥪧" + P("") / "竮" + P("") / "䈂" + P("") / "𥮫" + P("") / "篆" + P("") / "築" + P("") / "䈧" + P("") / "𥲀" + P("") / "糒" + P("") / "䊠" + P("") / "糨" + P("") / "糣" + P("") / "紀" + P("") / "𥾆" + P("") / "絣" + P("") / "䌁" + P("") / "緇" + P("") / "縂" + P("") / "繅" + P("") / "䌴" + P("") / "𦈨" + P("") / "𦉇" + P("") / "䍙" + P("") / "𦋙" + P("") / "罺" + P("") / "𦌾" + P("") / "羕" + P("") / "翺" + P("") / "者" + P("") / "𦓚" + P("") / "𦔣" + P("") / "聠" + P("") / "𦖨" + P("") / "聰") + P("") * (P("") / "派" + P("") / "海" + P("") / "流" + P("") / "浩" + P("") / "浸" + P("") / "涅" + P("") / "𣴞" + P("") / "洴" + P("") / "港" + P("") / "湮" + P("") / "㴳" + P("") / "滋" + P("") / "滇" + P("") / "𣻑" + P("") / "淹" + P("") / "潮" + P("") / "𣽞" + P("") / "𣾎" + P("") / "濆" + P("") / "瀹" + P("") / "瀞" + P("") / "瀛" + P("") / "㶖" + P("") / "灊" + P("") / "災" + P("") / "灷" + P("") / "炭" + P("") / "𠔥" + P("") / "煅" + P("") / "𤉣" + P("") / "熜" + P("") / "𤎫" + P("") / "爨" + P("") / "爵" + P("") / "牐" + P("") / "𤘈" + P("") / "犀" + P("") / "犕" + P("") / "𤜵" + P("") / "𤠔" + P("") / "獺" + P("") / "王" + P("") / "㺬" + P("") / "玥" + P("") / "㺸" + P("") / "㺸" + P("") / "瑇" + P("") / "瑜" + P("") / "瑱" + P("") / "璅" + P("") / "瓊" + P("") / "㼛" + P("") / "甤" + P("") / "𤰶" + P("") / "甾" + P("") / "𤲒" + P("") / "異" + P("") / "𢆟" + P("") / "瘐" + P("") / "𤾡" + P("") / "𤾸" + P("") / "𥁄" + P("") / "㿼" + P("") / "䀈") + P("") * (P("") / "頩" + P("") / "𩖶" + P("") / "飢" + P("") / "䬳" + P("") / "餩" + P("") / "馧" + P("") / "駂" + P("") / "駾" + P("") / "䯎" + P("") / "𩬰" + P("") / "鬒" + P("") / "鱀" + P("") / "鳽" + P("") / "䳎" + P("") / "䳭" + P("") / "鵧" + P("") / "𪃎" + P("") / "䳸" + P("") / "𪄅" + P("") / "𪈎" + P("") / "𪊑" + P("") / "麻" + P("") / "䵖" + P("") / "黹" + P("") / "黾" + P("") / "鼅" + P("") / "鼏" + P("") / "鼖" + P("") / "鼻" + P("") / "𪘀") + P("") * (P("") / "蟡" + P("") / "蠁" + P("") / "䗹" + P("") / "衠" + P("") / "衣" + P("") / "𧙧" + P("") / "裗" + P("") / "裞" + P("") / "䘵" + P("") / "裺" + P("") / "㒻" + P("") / "𧢮" + P("") / "𧥦" + P("") / "䚾" + P("") / "䛇" + P("") / "誠" + P("") / "諭" + P("") / "變" + P("") / "豕" + P("") / "𧲨" + P("") / "貫" + P("") / "賁" + P("") / "贛" + P("") / "起" + P("") / "𧼯" + P("") / "𠠄" + P("") / "跋" + P("") / "趼" + P("") / "跰" + P("") / "𠣞" + P("") / "軔" + P("") / "輸" + P("") / "𨗒" + P("") / "𨗭" + P("") / "邔" + P("") / "郱" + P("") / "鄑" + P("") / "𨜮" + P("") / "鄛" + P("") / "鈸" + P("") / "鋗" + P("") / "鋘" + P("") / "鉼" + P("") / "鏹" + P("") / "鐕" + P("") / "𨯺" + P("") / "開" + P("") / "䦕" + P("") / "閷" + P("") / "𨵷" + P("") / "䧦" + P("") / "雃" + P("") / "嶲" + P("") / "霣" + P("") / "𩅅" + P("") / "𩈚" + P("") / "䩮" + P("") / "䩶" + P("") / "韠" + P("") / "𩐊" + P("") / "䪲" + P("") / "𩒖" + P("") / "頋" + P("") / "頋")))
M.decomposition_mapping.compatibility = {}
M.decomposition_mapping.compatibility[1] = fail
M.decomposition_mapping.compatibility[2] = P("") * (P("") / " " + P("") / " ̈" + P("") / "a" + P("") / " ̄" + P("") / "2" + P("") / "3" + P("") / " ́" + P("") / "μ" + P("") / " ̧" + P("") / "1" + P("") / "o" + P("") / "1⁄4" + P("") / "1⁄2" + P("") / "3⁄4") + P("") * (P("") / "DŽ" + P("") / "Dž" + P("") / "dž" + P("") / "LJ" + P("") / "Lj" + P("") / "lj" + P("") / "NJ" + P("") / "Nj" + P("") / "nj" + P("") / "DZ" + P("") / "Dz" + P("") / "dz") + P("") * P("") / "եւ" + P("") * (P("") / "l·" + P("") / "ʼn" + P("") / "s") + P("") * (P("") / "IJ" + P("") / "ij" + P("") / "L·") + P("") * (P("") / " ̆" + P("") / " ̇" + P("") / " ̊" + P("") / " ̨" + P("") / " ̃" + P("") / " ̋" + P("") / "ɣ" + P("") / "l" + P("") / "s" + P("") / "x" + P("") / "ʕ") + P("") * (P("") / "h" + P("") / "ɦ" + P("") / "j" + P("") / "r" + P("") / "ɹ" + P("") / "ɻ" + P("") / "ʁ" + P("") / "w" + P("") / "y") + P("") * (P("") / "اٴ" + P("") / "وٴ" + P("") / "ۇٴ" + P("") / "يٴ") + P("") * (P("") / "β" + P("") / "θ" + P("") / "Υ" + P("") / "φ" + P("") / "π" + P("") / "κ" + P("") / "ρ" + P("") / "ς" + P("") / "Θ" + P("") / "ε" + P("") / "Σ") + P("") * P("") / " ́" + P("") * P("") / " ͅ"
M.decomposition_mapping.compatibility[3] = P("") * (P("") * P("") / "コト" + P("") * (P("") / " ゙" + P("") / " ゚" + P("") / "より") + P("") * (P("") / " " + P("") / "〒" + P("") / "十" + P("") / "卄" + P("") / "卅") + P("") * (P("") / "ᅇ" + P("") / "ᅌ" + P("") / "ᇱ" + P("") / "ᇲ" + P("") / "ᅗ" + P("") / "ᅘ" + P("") / "ᅙ" + P("") / "ᆄ" + P("") / "ᆅ" + P("") / "ᆈ" + P("") / "ᆑ" + P("") / "ᆒ" + P("") / "ᆔ" + P("") / "ᆞ" + P("") / "ᆡ" + P("") / "一" + P("") / "二" + P("") / "三" + P("") / "四" + P("") / "上" + P("") / "中" + P("") / "下" + P("") / "甲" + P("") / "乙" + P("") / "丙" + P("") / "丁" + P("") / "天" + P("") / "地" + P("") / "人") + P("") * (P("") / "ᄚ" + P("") / "ᄆ" + P("") / "ᄇ" + P("") / "ᄈ" + P("") / "ᄡ" + P("") / "ᄉ" + P("") / "ᄊ" + P("") / "ᄋ" + P("") / "ᄌ" + P("") / "ᄍ" + P("") / "ᄎ" + P("") / "ᄏ" + P("") / "ᄐ" + P("") / "ᄑ" + P("") / "ᄒ" + P("") / "ᅡ" + P("") / "ᅢ" + P("") / "ᅣ" + P("") / "ᅤ" + P("") / "ᅥ" + P("") / "ᅦ" + P("") / "ᅧ" + P("") / "ᅨ" + P("") / "ᅩ" + P("") / "ᅪ" + P("") / "ᅫ" + P("") / "ᅬ" + P("") / "ᅭ" + P("") / "ᅮ" + P("") / "ᅯ" + P("") / "ᅰ" + P("") / "ᅱ" + P("") / "ᅲ" + P("") / "ᅳ" + P("") / "ᅴ" + P("") / "ᅵ" + P("") / "ᅠ" + P("") / "ᄔ" + P("") / "ᄕ" + P("") / "ᇇ" + P("") / "ᇈ" + P("") / "ᇌ" + P("") / "ᇎ" + P("") / "ᇓ" + P("") / "ᇗ" + P("") / "ᇙ" + P("") / "ᄜ" + P("") / "ᇝ" + P("") / "ᇟ" + P("") / "ᄝ" + P("") / "ᄞ" + P("") / "ᄠ" + P("") / "ᄢ" + P("") / "ᄣ" + P("") / "ᄧ" + P("") / "ᄩ" + P("") / "ᄫ" + P("") / "ᄬ" + P("") / "ᄭ" + P("") / "ᄮ" + P("") / "ᄯ" + P("") / "ᄲ" + P("") / "ᄶ" + P("") / "ᅀ") + P("") * (P("") / "ᄀ" + P("") / "ᄁ" + P("") / "ᆪ" + P("") / "ᄂ" + P("") / "ᆬ" + P("") / "ᆭ" + P("") / "ᄃ" + P("") / "ᄄ" + P("") / "ᄅ" + P("") / "ᆰ" + P("") / "ᆱ" + P("") / "ᆲ" + P("") / "ᆳ" + P("") / "ᆴ" + P("") / "ᆵ") + P("") * (P("") / "1月" + P("") / "2月" + P("") / "3月" + P("") / "4月" + P("") / "5月" + P("") / "6月" + P("") / "7月" + P("") / "8月" + P("") / "9月" + P("") / "10月" + P("") / "11月" + P("") / "12月" + P("") / "Hg" + P("") / "erg" + P("") / "eV" + P("") / "LTD" + P("") / "ア" + P("") / "イ" + P("") / "ウ" + P("") / "エ" + P("") / "オ" + P("") / "カ" + P("") / "キ" + P("") / "ク" + P("") / "ケ" + P("") / "コ" + P("") / "サ" + P("") / "シ" + P("") / "ス" + P("") / "セ" + P("") / "ソ" + P("") / "タ" + P("") / "チ" + P("") / "ツ" + P("") / "テ" + P("") / "ト" + P("") / "ナ" + P("") / "ニ" + P("") / "ヌ" + P("") / "ネ" + P("") / "ノ" + P("") / "ハ" + P("") / "ヒ" + P("") / "フ" + P("") / "ヘ" + P("") / "ホ" + P("") / "マ" + P("") / "ミ" + P("") / "ム" + P("") / "メ" + P("") / "モ" + P("") / "ヤ" + P("") / "ユ" + P("") / "ヨ" + P("") / "ラ" + P("") / "リ" + P("") / "ル" + P("") / "レ" + P("") / "ロ" + P("") / "ワ" + P("") / "ヰ" + P("") / "ヱ" + P("") / "ヲ" + P("") / "令和") + P("") * (P("") / "一" + P("") / "二" + P("") / "三" + P("") / "四" + P("") / "五" + P("") / "六" + P("") / "七" + P("") / "八" + P("") / "九" + P("") / "十" + P("") / "月" + P("") / "火" + P("") / "水" + P("") / "木" + P("") / "金" + P("") / "土" + P("") / "日" + P("") / "株" + P("") / "有" + P("") / "社" + P("") / "名" + P("") / "特" + P("") / "財" + P("") / "祝" + P("") / "労" + P("") / "秘" + P("") / "男" + P("") / "女" + P("") / "適" + P("") / "優" + P("") / "印" + P("") / "注" + P("") / "項" + P("") / "休" + P("") / "写" + P("") / "正" + P("") / "上" + P("") / "中" + P("") / "下" + P("") / "左" + P("") / "右" + P("") / "医" + P("") / "宗" + P("") / "学" + P("") / "監" + P("") / "企" + P("") / "資" + P("") / "協" + P("") / "夜" + P("") / "36" + P("") / "37" + P("") / "38" + P("") / "39" + P("") / "40" + P("") / "41" + P("") / "42" + P("") / "43" + P("") / "44" + P("") / "45" + P("") / "46" + P("") / "47" + P("") / "48" + P("") / "49" + P("") / "50") + P("") * (P("") / "(祭)" + P("") / "(休)" + P("") / "(自)" + P("") / "(至)" + P("") / "問" + P("") / "幼" + P("") / "文" + P("") / "箏" + P("") / "PTE" + P("") / "21" + P("") / "22" + P("") / "23" + P("") / "24" + P("") / "25" + P("") / "26" + P("") / "27" + P("") / "28" + P("") / "29" + P("") / "30" + P("") / "31" + P("") / "32" + P("") / "33" + P("") / "34" + P("") / "35" + P("") / "ᄀ" + P("") / "ᄂ" + P("") / "ᄃ" + P("") / "ᄅ" + P("") / "ᄆ" + P("") / "ᄇ" + P("") / "ᄉ" + P("") / "ᄋ" + P("") / "ᄌ" + P("") / "ᄎ" + P("") / "ᄏ" + P("") / "ᄐ" + P("") / "ᄑ" + P("") / "ᄒ" + P("") / "가" + P("") / "나" + P("") / "다" + P("") / "라" + P("") / "마" + P("") / "바" + P("") / "사" + P("") / "아" + P("") / "자" + P("") / "차" + P("") / "카" + P("") / "타" + P("") / "파" + P("") / "하" + P("") / "참고" + P("") / "주의" + P("") / "우") + P("") * (P("") / "(ᄀ)" + P("") / "(ᄂ)" + P("") / "(ᄃ)" + P("") / "(ᄅ)" + P("") / "(ᄆ)" + P("") / "(ᄇ)" + P("") / "(ᄉ)" + P("") / "(ᄋ)" + P("") / "(ᄌ)" + P("") / "(ᄎ)" + P("") / "(ᄏ)" + P("") / "(ᄐ)" + P("") / "(ᄑ)" + P("") / "(ᄒ)" + P("") / "(가)" + P("") / "(나)" + P("") / "(다)" + P("") / "(라)" + P("") / "(마)" + P("") / "(바)" + P("") / "(사)" + P("") / "(아)" + P("") / "(자)" + P("") / "(차)" + P("") / "(카)" + P("") / "(타)" + P("") / "(파)" + P("") / "(하)" + P("") / "(주)" + P("") / "(오전)" + P("") / "(오후)" + P("") / "(一)" + P("") / "(二)" + P("") / "(三)" + P("") / "(四)" + P("") / "(五)" + P("") / "(六)" + P("") / "(七)" + P("") / "(八)" + P("") / "(九)" + P("") / "(十)" + P("") / "(月)" + P("") / "(火)" + P("") / "(水)" + P("") / "(木)" + P("") / "(金)" + P("") / "(土)" + P("") / "(日)" + P("") / "(株)" + P("") / "(有)" + P("") / "(社)" + P("") / "(名)" + P("") / "(特)" + P("") / "(財)" + P("") / "(祝)" + P("") / "(労)" + P("") / "(代)" + P("") / "(呼)" + P("") / "(学)" + P("") / "(監)" + P("") / "(企)" + P("") / "(資)" + P("") / "(協)") + P("") * (P("") / "kΩ" + P("") / "MΩ" + P("") / "a.m." + P("") / "Bq" + P("") / "cc" + P("") / "cd" + P("") / "C∕kg" + P("") / "Co." + P("") / "dB" + P("") / "Gy" + P("") / "ha" + P("") / "HP" + P("") / "in" + P("") / "KK" + P("") / "KM" + P("") / "kt" + P("") / "lm" + P("") / "ln" + P("") / "log" + P("") / "lx" + P("") / "mb" + P("") / "mil" + P("") / "mol" + P("") / "PH" + P("") / "p.m." + P("") / "PPM" + P("") / "PR" + P("") / "sr" + P("") / "Sv" + P("") / "Wb" + P("") / "V∕m" + P("") / "A∕m" + P("") / "1日" + P("") / "2日" + P("") / "3日" + P("") / "4日" + P("") / "5日" + P("") / "6日" + P("") / "7日" + P("") / "8日" + P("") / "9日" + P("") / "10日" + P("") / "11日" + P("") / "12日" + P("") / "13日" + P("") / "14日" + P("") / "15日" + P("") / "16日" + P("") / "17日" + P("") / "18日" + P("") / "19日" + P("") / "20日" + P("") / "21日" + P("") / "22日" + P("") / "23日" + P("") / "24日" + P("") / "25日" + P("") / "26日" + P("") / "27日" + P("") / "28日" + P("") / "29日" + P("") / "30日" + P("") / "31日" + P("") / "gal") + P("") * (P("") / "pA" + P("") / "nA" + P("") / "μA" + P("") / "mA" + P("") / "kA" + P("") / "KB" + P("") / "MB" + P("") / "GB" + P("") / "cal" + P("") / "kcal" + P("") / "pF" + P("") / "nF" + P("") / "μF" + P("") / "μg" + P("") / "mg" + P("") / "kg" + P("") / "Hz" + P("") / "kHz" + P("") / "MHz" + P("") / "GHz" + P("") / "THz" + P("") / "μℓ" + P("") / "mℓ" + P("") / "dℓ" + P("") / "kℓ" + P("") / "fm" + P("") / "nm" + P("") / "μm" + P("") / "mm" + P("") / "cm" + P("") / "km" + P("") / "mm²" + P("") / "cm²" + P("") / "m²" + P("") / "km²" + P("") / "mm³" + P("") / "cm³" + P("") / "m³" + P("") / "km³" + P("") / "m∕s" + P("") / "m∕s²" + P("") / "Pa" + P("") / "kPa" + P("") / "MPa" + P("") / "GPa" + P("") / "rad" + P("") / "rad∕s" + P("") / "rad∕s²" + P("") / "ps" + P("") / "ns" + P("") / "μs" + P("") / "ms" + P("") / "pV" + P("") / "nV" + P("") / "μV" + P("") / "mV" + P("") / "kV" + P("") / "MV" + P("") / "pW" + P("") / "nW" + P("") / "μW" + P("") / "mW" + P("") / "kW" + P("") / "MW") + P("") * (P("") / "ポンド" + P("") / "ホール" + P("") / "ホーン" + P("") / "マイクロ" + P("") / "マイル" + P("") / "マッハ" + P("") / "マルク" + P("") / "マンション" + P("") / "ミクロン" + P("") / "ミリ" + P("") / "ミリバール" + P("") / "メガ" + P("") / "メガトン" + P("") / "メートル" + P("") / "ヤード" + P("") / "ヤール" + P("") / "ユアン" + P("") / "リットル" + P("") / "リラ" + P("") / "ルピー" + P("") / "ルーブル" + P("") / "レム" + P("") / "レントゲン" + P("") / "ワット" + P("") / "0点" + P("") / "1点" + P("") / "2点" + P("") / "3点" + P("") / "4点" + P("") / "5点" + P("") / "6点" + P("") / "7点" + P("") / "8点" + P("") / "9点" + P("") / "10点" + P("") / "11点" + P("") / "12点" + P("") / "13点" + P("") / "14点" + P("") / "15点" + P("") / "16点" + P("") / "17点" + P("") / "18点" + P("") / "19点" + P("") / "20点" + P("") / "21点" + P("") / "22点" + P("") / "23点" + P("") / "24点" + P("") / "hPa" + P("") / "da" + P("") / "AU" + P("") / "bar" + P("") / "oV" + P("") / "pc" + P("") / "dm" + P("") / "dm²" + P("") / "dm³" + P("") / "IU" + P("") / "平成" + P("") / "昭和" + P("") / "大正" + P("") / "明治" + P("") / "株式会社") + P("") * (P("") / "アパート" + P("") / "アルファ" + P("") / "アンペア" + P("") / "アール" + P("") / "イニング" + P("") / "インチ" + P("") / "ウォン" + P("") / "エスクード" + P("") / "エーカー" + P("") / "オンス" + P("") / "オーム" + P("") / "カイリ" + P("") / "カラット" + P("") / "カロリー" + P("") / "ガロン" + P("") / "ガンマ" + P("") / "ギガ" + P("") / "ギニー" + P("") / "キュリー" + P("") / "ギルダー" + P("") / "キロ" + P("") / "キログラム" + P("") / "キロメートル" + P("") / "キロワット" + P("") / "グラム" + P("") / "グラムトン" + P("") / "クルゼイロ" + P("") / "クローネ" + P("") / "ケース" + P("") / "コルナ" + P("") / "コーポ" + P("") / "サイクル" + P("") / "サンチーム" + P("") / "シリング" + P("") / "センチ" + P("") / "セント" + P("") / "ダース" + P("") / "デシ" + P("") / "ドル" + P("") / "トン" + P("") / "ナノ" + P("") / "ノット" + P("") / "ハイツ" + P("") / "パーセント" + P("") / "パーツ" + P("") / "バーレル" + P("") / "ピアストル" + P("") / "ピクル" + P("") / "ピコ" + P("") / "ビル" + P("") / "ファラッド" + P("") / "フィート" + P("") / "ブッシェル" + P("") / "フラン" + P("") / "ヘクタール" + P("") / "ペソ" + P("") / "ペニヒ" + P("") / "ヘルツ" + P("") / "ペンス" + P("") / "ページ" + P("") / "ベータ" + P("") / "ポイント" + P("") / "ボルト" + P("") / "ホン")) + P("") * (P("") * (P("") / "0" + P("") / "1" + P("") / "2" + P("") / "3" + P("") / "4" + P("") / "5" + P("") / "6" + P("") / "7" + P("") / "8" + P("") / "9" + P("") / "+" + P("") / "−" + P("") / "=" + P("") / "(" + P("") / ")" + P("") / "a" + P("") / "e" + P("") / "o" + P("") / "x" + P("") / "ə" + P("") / "h" + P("") / "k" + P("") / "l" + P("") / "m" + P("") / "n" + P("") / "p" + P("") / "s" + P("") / "t" + P("") / "Rs") + P("") * (P("") / "??" + P("") / "?!" + P("") / "!?" + P("") / "′′′′" + P("") / " " + P("") / "0" + P("") / "i" + P("") / "4" + P("") / "5" + P("") / "6" + P("") / "7" + P("") / "8" + P("") / "9" + P("") / "+" + P("") / "−" + P("") / "=" + P("") / "(" + P("") / ")" + P("") / "n") + P("") * (P("") / " " + P("") / " " + P("") / " " + P("") / " " + P("") / " " + P("") / " " + P("") / " " + P("") / " " + P("") / " " + P("") / "‐" + P("") / " ̳" + P("") / "." + P("") / ".." + P("") / "..." + P("") / " " + P("") / "′′" + P("") / "′′′" + P("") / "‵‵" + P("") / "‵‵‵" + P("") / "!!" + P("") / " ̅") + P("") * P("") / "0⁄3" + P("") * (P("") / "∑" + P("") / "D" + P("") / "d" + P("") / "e" + P("") / "i" + P("") / "j" + P("") / "1⁄7" + P("") / "1⁄9" + P("") / "1⁄10" + P("") / "1⁄3" + P("") / "2⁄3" + P("") / "1⁄5" + P("") / "2⁄5" + P("") / "3⁄5" + P("") / "4⁄5" + P("") / "1⁄6" + P("") / "5⁄6" + P("") / "1⁄8" + P("") / "3⁄8" + P("") / "5⁄8" + P("") / "7⁄8" + P("") / "1⁄" + P("") / "I" + P("") / "II" + P("") / "III" + P("") / "IV" + P("") / "V" + P("") / "VI" + P("") / "VII" + P("") / "VIII" + P("") / "IX" + P("") / "X" + P("") / "XI" + P("") / "XII" + P("") / "L" + P("") / "C" + P("") / "D" + P("") / "M" + P("") / "i" + P("") / "ii" + P("") / "iii" + P("") / "iv" + P("") / "v" + P("") / "vi" + P("") / "vii" + P("") / "viii" + P("") / "ix" + P("") / "x" + P("") / "xi" + P("") / "xii" + P("") / "l" + P("") / "c" + P("") / "d" + P("") / "m") + P("") * (P("") / "a/c" + P("") / "a/s" + P("") / "C" + P("") / "°C" + P("") / "c/o" + P("") / "c/u" + P("") / "Ɛ" + P("") / "°F" + P("") / "g" + P("") / "H" + P("") / "H" + P("") / "H" + P("") / "h" + P("") / "ħ" + P("") / "I" + P("") / "I" + P("") / "L" + P("") / "l" + P("") / "N" + P("") / "No" + P("") / "P" + P("") / "Q" + P("") / "R" + P("") / "R" + P("") / "R" + P("") / "SM" + P("") / "TEL" + P("") / "TM" + P("") / "Z" + P("") / "Z" + P("") / "B" + P("") / "C" + P("") / "e" + P("") / "E" + P("") / "F" + P("") / "M" + P("") / "o" + P("") / "א" + P("") / "ב" + P("") / "ג" + P("") / "ד" + P("") / "i" + P("") / "FAX" + P("") / "π" + P("") / "γ" + P("") / "Γ" + P("") / "Π") + P("") * (P("") / "::=" + P("") / "==" + P("") / "===") + P("") * P("") / "∫∫∫∫" + P("") * (P("") / "K" + P("") / "L" + P("") / "M" + P("") / "N" + P("") / "O" + P("") / "P" + P("") / "Q" + P("") / "R" + P("") / "S" + P("") / "T" + P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X" + P("") / "Y" + P("") / "Z" + P("") / "a" + P("") / "b" + P("") / "c" + P("") / "d" + P("") / "e" + P("") / "f" + P("") / "g" + P("") / "h" + P("") / "i" + P("") / "j" + P("") / "k" + P("") / "l" + P("") / "m" + P("") / "n" + P("") / "o" + P("") / "p" + P("") / "q" + P("") / "r" + P("") / "s" + P("") / "t" + P("") / "u" + P("") / "v" + P("") / "w" + P("") / "x" + P("") / "y" + P("") / "z" + P("") / "0") + P("") * (P("") / "(13)" + P("") / "(14)" + P("") / "(15)" + P("") / "(16)" + P("") / "(17)" + P("") / "(18)" + P("") / "(19)" + P("") / "(20)" + P("") / "1." + P("") / "2." + P("") / "3." + P("") / "4." + P("") / "5." + P("") / "6." + P("") / "7." + P("") / "8." + P("") / "9." + P("") / "10." + P("") / "11." + P("") / "12." + P("") / "13." + P("") / "14." + P("") / "15." + P("") / "16." + P("") / "17." + P("") / "18." + P("") / "19." + P("") / "20." + P("") / "(a)" + P("") / "(b)" + P("") / "(c)" + P("") / "(d)" + P("") / "(e)" + P("") / "(f)" + P("") / "(g)" + P("") / "(h)" + P("") / "(i)" + P("") / "(j)" + P("") / "(k)" + P("") / "(l)" + P("") / "(m)" + P("") / "(n)" + P("") / "(o)" + P("") / "(p)" + P("") / "(q)" + P("") / "(r)" + P("") / "(s)" + P("") / "(t)" + P("") / "(u)" + P("") / "(v)" + P("") / "(w)" + P("") / "(x)" + P("") / "(y)" + P("") / "(z)" + P("") / "A" + P("") / "B" + P("") / "C" + P("") / "D" + P("") / "E" + P("") / "F" + P("") / "G" + P("") / "H" + P("") / "I" + P("") / "J") + P("") * (P("") / "1" + P("") / "2" + P("") / "3" + P("") / "4" + P("") / "5" + P("") / "6" + P("") / "7" + P("") / "8" + P("") / "9" + P("") / "10" + P("") / "11" + P("") / "12" + P("") / "13" + P("") / "14" + P("") / "15" + P("") / "16" + P("") / "17" + P("") / "18" + P("") / "19" + P("") / "20" + P("") / "(1)" + P("") / "(2)" + P("") / "(3)" + P("") / "(4)" + P("") / "(5)" + P("") / "(6)" + P("") / "(7)" + P("") / "(8)" + P("") / "(9)" + P("") / "(10)" + P("") / "(11)" + P("") / "(12)") + P("") * P("") / "ⵡ" + P("") * P("") / "龟" + P("") * P("") / "母" + P("") * (P("") / "∫∫" + P("") / "∫∫∫" + P("") / "∮∮" + P("") / "∮∮∮") + P("") * (P("") / "j" + P("") / "V") + P("") * (P("") / "鬲" + P("") / "鬼" + P("") / "魚" + P("") / "鳥" + P("") / "鹵" + P("") / "鹿" + P("") / "麥" + P("") / "麻" + P("") / "黃" + P("") / "黍" + P("") / "黑" + P("") / "黹" + P("") / "黽" + P("") / "鼎" + P("") / "鼓" + P("") / "鼠" + P("") / "鼻" + P("") / "齊" + P("") / "齒" + P("") / "龍" + P("") / "龜" + P("") / "龠") + P("") * (P("") / "聿" + P("") / "肉" + P("") / "臣" + P("") / "自" + P("") / "至" + P("") / "臼" + P("") / "舌" + P("") / "舛" + P("") / "舟" + P("") / "艮" + P("") / "色" + P("") / "艸" + P("") / "虍" + P("") / "虫" + P("") / "血" + P("") / "行" + P("") / "衣" + P("") / "襾" + P("") / "見" + P("") / "角" + P("") / "言" + P("") / "谷" + P("") / "豆" + P("") / "豕" + P("") / "豸" + P("") / "貝" + P("") / "赤" + P("") / "走" + P("") / "足" + P("") / "身" + P("") / "車" + P("") / "辛" + P("") / "辰" + P("") / "辵" + P("") / "邑" + P("") / "酉" + P("") / "釆" + P("") / "里" + P("") / "金" + P("") / "長" + P("") / "門" + P("") / "阜" + P("") / "隶" + P("") / "隹" + P("") / "雨" + P("") / "靑" + P("") / "非" + P("") / "面" + P("") / "革" + P("") / "韋" + P("") / "韭" + P("") / "音" + P("") / "頁" + P("") / "風" + P("") / "飛" + P("") / "食" + P("") / "首" + P("") / "香" + P("") / "馬" + P("") / "骨" + P("") / "高" + P("") / "髟" + P("") / "鬥" + P("") / "鬯") + P("") * (P("") / "支" + P("") / "攴" + P("") / "文" + P("") / "斗" + P("") / "斤" + P("") / "方" + P("") / "无" + P("") / "日" + P("") / "曰" + P("") / "月" + P("") / "木" + P("") / "欠" + P("") / "止" + P("") / "歹" + P("") / "殳" + P("") / "毋" + P("") / "比" + P("") / "毛" + P("") / "氏" + P("") / "气" + P("") / "水" + P("") / "火" + P("") / "爪" + P("") / "父" + P("") / "爻" + P("") / "爿" + P("") / "片" + P("") / "牙" + P("") / "牛" + P("") / "犬" + P("") / "玄" + P("") / "玉" + P("") / "瓜" + P("") / "瓦" + P("") / "甘" + P("") / "生" + P("") / "用" + P("") / "田" + P("") / "疋" + P("") / "疒" + P("") / "癶" + P("") / "白" + P("") / "皮" + P("") / "皿" + P("") / "目" + P("") / "矛" + P("") / "矢" + P("") / "石" + P("") / "示" + P("") / "禸" + P("") / "禾" + P("") / "穴" + P("") / "立" + P("") / "竹" + P("") / "米" + P("") / "糸" + P("") / "缶" + P("") / "网" + P("") / "羊" + P("") / "羽" + P("") / "老" + P("") / "而" + P("") / "耒" + P("") / "耳") + P("") * (P("") / "一" + P("") / "丨" + P("") / "丶" + P("") / "丿" + P("") / "乙" + P("") / "亅" + P("") / "二" + P("") / "亠" + P("") / "人" + P("") / "儿" + P("") / "入" + P("") / "八" + P("") / "冂" + P("") / "冖" + P("") / "冫" + P("") / "几" + P("") / "凵" + P("") / "刀" + P("") / "力" + P("") / "勹" + P("") / "匕" + P("") / "匚" + P("") / "匸" + P("") / "十" + P("") / "卜" + P("") / "卩" + P("") / "厂" + P("") / "厶" + P("") / "又" + P("") / "口" + P("") / "囗" + P("") / "土" + P("") / "士" + P("") / "夂" + P("") / "夊" + P("") / "夕" + P("") / "大" + P("") / "女" + P("") / "子" + P("") / "宀" + P("") / "寸" + P("") / "小" + P("") / "尢" + P("") / "尸" + P("") / "屮" + P("") / "山" + P("") / "巛" + P("") / "工" + P("") / "己" + P("") / "巾" + P("") / "干" + P("") / "幺" + P("") / "广" + P("") / "廴" + P("") / "廾" + P("") / "弋" + P("") / "弓" + P("") / "彐" + P("") / "彡" + P("") / "彳" + P("") / "心" + P("") / "戈" + P("") / "戶" + P("") / "手")) + P("") * (P("") * P("") / "ნ" + P("") * P("") / "aʾ" + P("") * (P("") / " ͂" + P("") / " ̔") + P("") * (P("") / " ̓" + P("") / " ̓") + P("") * (P("") / "ɒ" + P("") / "c" + P("") / "ɕ" + P("") / "ð" + P("") / "ɜ" + P("") / "f" + P("") / "ɟ" + P("") / "ɡ" + P("") / "ɥ" + P("") / "ɨ" + P("") / "ɩ" + P("") / "ɪ" + P("") / "ᵻ" + P("") / "ʝ" + P("") / "ɭ" + P("") / "ᶅ" + P("") / "ʟ" + P("") / "ɱ" + P("") / "ɰ" + P("") / "ɲ" + P("") / "ɳ" + P("") / "ɴ" + P("") / "ɵ" + P("") / "ɸ" + P("") / "ʂ" + P("") / "ʃ" + P("") / "ƫ" + P("") / "ʉ" + P("") / "ʊ" + P("") / "ᴜ" + P("") / "ʋ" + P("") / "ʌ" + P("") / "z" + P("") / "ʐ" + P("") / "ʑ" + P("") / "ʒ" + P("") / "θ") + P("") * (P("") / "T" + P("") / "U" + P("") / "W" + P("") / "a" + P("") / "ɐ" + P("") / "ɑ" + P("") / "ᴂ" + P("") / "b" + P("") / "d" + P("") / "e" + P("") / "ə" + P("") / "ɛ" + P("") / "ɜ" + P("") / "g" + P("") / "k" + P("") / "m" + P("") / "ŋ" + P("") / "o" + P("") / "ɔ" + P("") / "ᴖ" + P("") / "ᴗ" + P("") / "p" + P("") / "t" + P("") / "u" + P("") / "ᴝ" + P("") / "ɯ" + P("") / "v" + P("") / "ᴥ" + P("") / "β" + P("") / "γ" + P("") / "δ" + P("") / "φ" + P("") / "χ" + P("") / "i" + P("") / "r" + P("") / "u" + P("") / "v" + P("") / "β" + P("") / "γ" + P("") / "ρ" + P("") / "φ" + P("") / "χ" + P("") / "н") + P("") * (P("") / "A" + P("") / "Æ" + P("") / "B" + P("") / "D" + P("") / "E" + P("") / "Ǝ" + P("") / "G" + P("") / "H" + P("") / "I" + P("") / "J" + P("") / "K" + P("") / "L" + P("") / "M" + P("") / "N" + P("") / "O" + P("") / "Ȣ" + P("") / "P" + P("") / "R")) + P("") * (P("") * (P("") / "ຫນ" + P("") / "ຫມ") + P("") * P("") / "ໍາ" + P("") * P("") / "ํา" + P("") * (P("") / "ྲཱྀ" + P("") / "ླཱྀ") + P("") * P("") / "་") + P("") * (P("") * (P("") / "ڭ" + P("") / "ڭ" + P("") / "ڭ" + P("") / "ڭ" + P("") / "ۇ" + P("") / "ۇ" + P("") / "ۆ" + P("") / "ۆ" + P("") / "ۈ" + P("") / "ۈ" + P("") / "ٷ" + P("") / "ۋ" + P("") / "ۋ" + P("") / "ۅ" + P("") / "ۅ" + P("") / "ۉ" + P("") / "ۉ" + P("") / "ې" + P("") / "ې" + P("") / "ې" + P("") / "ې" + P("") / "ى" + P("") / "ى" + P("") / "ئا" + P("") / "ئا" + P("") / "ئە" + P("") / "ئە" + P("") / "ئو" + P("") / "ئو" + P("") / "ئۇ" + P("") / "ئۇ" + P("") / "ئۆ" + P("") / "ئۆ" + P("") / "ئۈ" + P("") / "ئۈ" + P("") / "ئې" + P("") / "ئې" + P("") / "ئې" + P("") / "ئى" + P("") / "ئى" + P("") / "ئى" + P("") / "ی" + P("") / "ی" + P("") / "ی" + P("") / "ی") + P("") * (P("") / "ڇ" + P("") / "ڇ" + P("") / "ڍ" + P("") / "ڍ" + P("") / "ڌ" + P("") / "ڌ" + P("") / "ڎ" + P("") / "ڎ" + P("") / "ڈ" + P("") / "ڈ" + P("") / "ژ" + P("") / "ژ" + P("") / "ڑ" + P("") / "ڑ" + P("") / "ک" + P("") / "ک" + P("") / "ک" + P("") / "ک" + P("") / "گ" + P("") / "گ" + P("") / "گ" + P("") / "گ" + P("") / "ڳ" + P("") / "ڳ" + P("") / "ڳ" + P("") / "ڳ" + P("") / "ڱ" + P("") / "ڱ" + P("") / "ڱ" + P("") / "ڱ" + P("") / "ں" + P("") / "ں" + P("") / "ڻ" + P("") / "ڻ" + P("") / "ڻ" + P("") / "ڻ" + P("") / "ۀ" + P("") / "ۀ" + P("") / "ہ" + P("") / "ہ" + P("") / "ہ" + P("") / "ہ" + P("") / "ھ" + P("") / "ھ" + P("") / "ھ" + P("") / "ھ" + P("") / "ے" + P("") / "ے" + P("") / "ۓ" + P("") / "ۓ") + P("") * (P("") / "אל" + P("") / "ٱ" + P("") / "ٱ" + P("") / "ٻ" + P("") / "ٻ" + P("") / "ٻ" + P("") / "ٻ" + P("") / "پ" + P("") / "پ" + P("") / "پ" + P("") / "پ" + P("") / "ڀ" + P("") / "ڀ" + P("") / "ڀ" + P("") / "ڀ" + P("") / "ٺ" + P("") / "ٺ" + P("") / "ٺ" + P("") / "ٺ" + P("") / "ٿ" + P("") / "ٿ" + P("") / "ٿ" + P("") / "ٿ" + P("") / "ٹ" + P("") / "ٹ" + P("") / "ٹ" + P("") / "ٹ" + P("") / "ڤ" + P("") / "ڤ" + P("") / "ڤ" + P("") / "ڤ" + P("") / "ڦ" + P("") / "ڦ" + P("") / "ڦ" + P("") / "ڦ" + P("") / "ڄ" + P("") / "ڄ" + P("") / "ڄ" + P("") / "ڄ" + P("") / "ڃ" + P("") / "ڃ" + P("") / "ڃ" + P("") / "ڃ" + P("") / "چ" + P("") / "چ" + P("") / "چ" + P("") / "چ" + P("") / "ڇ" + P("") / "ڇ") + P("") * (P("") / "ff" + P("") / "fi" + P("") / "fl" + P("") / "ffi" + P("") / "ffl" + P("") / "ſt" + P("") / "st" + P("") / "մն" + P("") / "մե" + P("") / "մի" + P("") / "վն" + P("") / "մխ" + P("") / "ע" + P("") / "א" + P("") / "ד" + P("") / "ה" + P("") / "כ" + P("") / "ל" + P("") / "ם" + P("") / "ר" + P("") / "ת" + P("") / "+") + P("") * (P("") / "فخ" + P("") / "فم" + P("") / "قح" + P("") / "قم" + P("") / "كج" + P("") / "كح" + P("") / "كخ" + P("") / "كل" + P("") / "كم" + P("") / "لج" + P("") / "لح" + P("") / "لخ" + P("") / "لم" + P("") / "له" + P("") / "مج" + P("") / "مح" + P("") / "مخ" + P("") / "مم" + P("") / "نج" + P("") / "نح" + P("") / "نخ" + P("") / "نم" + P("") / "نه" + P("") / "هج" + P("") / "هم" + P("") / "هٰ" + P("") / "يج" + P("") / "يح" + P("") / "يخ" + P("") / "يم" + P("") / "يه" + P("") / "ئم" + P("") / "ئه" + P("") / "بم" + P("") / "به" + P("") / "تم" + P("") / "ته" + P("") / "ثم" + P("") / "ثه" + P("") / "سم" + P("") / "سه" + P("") / "شم" + P("") / "شه" + P("") / "كل" + P("") / "كم" + P("") / "لم" + P("") / "نم" + P("") / "نه" + P("") / "يم" + P("") / "يه" + P("") / "ـَّ" + P("") / "ـُّ" + P("") / "ـِّ" + P("") / "طى" + P("") / "طي" + P("") / "عى" + P("") / "عي" + P("") / "غى" + P("") / "غي" + P("") / "سى" + P("") / "سي" + P("") / "شى" + P("") / "شي" + P("") / "حى") + P("") * (P("") / "كا" + P("") / "كل" + P("") / "كم" + P("") / "كى" + P("") / "كي" + P("") / "لم" + P("") / "لى" + P("") / "لي" + P("") / "ما" + P("") / "مم" + P("") / "نر" + P("") / "نز" + P("") / "نم" + P("") / "نن" + P("") / "نى" + P("") / "ني" + P("") / "ىٰ" + P("") / "ير" + P("") / "يز" + P("") / "يم" + P("") / "ين" + P("") / "يى" + P("") / "يي" + P("") / "ئج" + P("") / "ئح" + P("") / "ئخ" + P("") / "ئم" + P("") / "ئه" + P("") / "بج" + P("") / "بح" + P("") / "بخ" + P("") / "بم" + P("") / "به" + P("") / "تج" + P("") / "تح" + P("") / "تخ" + P("") / "تم" + P("") / "ته" + P("") / "ثم" + P("") / "جح" + P("") / "جم" + P("") / "حج" + P("") / "حم" + P("") / "خج" + P("") / "خم" + P("") / "سج" + P("") / "سح" + P("") / "سخ" + P("") / "سم" + P("") / "صح" + P("") / "صخ" + P("") / "صم" + P("") / "ضج" + P("") / "ضح" + P("") / "ضخ" + P("") / "ضم" + P("") / "طح" + P("") / "ظم" + P("") / "عج" + P("") / "عم" + P("") / "غج" + P("") / "غم" + P("") / "فج" + P("") / "فح") + P("") * (P("") / "لح" + P("") / "لخ" + P("") / "لم" + P("") / "لى" + P("") / "لي" + P("") / "مج" + P("") / "مح" + P("") / "مخ" + P("") / "مم" + P("") / "مى" + P("") / "مي" + P("") / "نج" + P("") / "نح" + P("") / "نخ" + P("") / "نم" + P("") / "نى" + P("") / "ني" + P("") / "هج" + P("") / "هم" + P("") / "هى" + P("") / "هي" + P("") / "يج" + P("") / "يح" + P("") / "يخ" + P("") / "يم" + P("") / "يى" + P("") / "يي" + P("") / "ذٰ" + P("") / "رٰ" + P("") / "ىٰ" + P("") / " ٌّ" + P("") / " ٍّ" + P("") / " َّ" + P("") / " ُّ" + P("") / " ِّ" + P("") / " ّٰ" + P("") / "ئر" + P("") / "ئز" + P("") / "ئم" + P("") / "ئن" + P("") / "ئى" + P("") / "ئي" + P("") / "بر" + P("") / "بز" + P("") / "بم" + P("") / "بن" + P("") / "بى" + P("") / "بي" + P("") / "تر" + P("") / "تز" + P("") / "تم" + P("") / "تن" + P("") / "تى" + P("") / "تي" + P("") / "ثر" + P("") / "ثز" + P("") / "ثم" + P("") / "ثن" + P("") / "ثى" + P("") / "ثي" + P("") / "فى" + P("") / "في" + P("") / "قى" + P("") / "قي") + P("") * (P("") / "ئج" + P("") / "ئح" + P("") / "ئم" + P("") / "ئى" + P("") / "ئي" + P("") / "بج" + P("") / "بح" + P("") / "بخ" + P("") / "بم" + P("") / "بى" + P("") / "بي" + P("") / "تج" + P("") / "تح" + P("") / "تخ" + P("") / "تم" + P("") / "تى" + P("") / "تي" + P("") / "ثج" + P("") / "ثم" + P("") / "ثى" + P("") / "ثي" + P("") / "جح" + P("") / "جم" + P("") / "حج" + P("") / "حم" + P("") / "خج" + P("") / "خح" + P("") / "خم" + P("") / "سج" + P("") / "سح" + P("") / "سخ" + P("") / "سم" + P("") / "صح" + P("") / "صم" + P("") / "ضج" + P("") / "ضح" + P("") / "ضخ" + P("") / "ضم" + P("") / "طح" + P("") / "طم" + P("") / "ظم" + P("") / "عج" + P("") / "عم" + P("") / "غج" + P("") / "غم" + P("") / "فج" + P("") / "فح" + P("") / "فخ" + P("") / "فم" + P("") / "فى" + P("") / "في" + P("") / "قح" + P("") / "قم" + P("") / "قى" + P("") / "قي" + P("") / "كا" + P("") / "كج" + P("") / "كح" + P("") / "كخ" + P("") / "كل" + P("") / "كم" + P("") / "كى" + P("") / "كي" + P("") / "لج") + P("") * (P("") / "مجي" + P("") / "فمي" + P("") / "بحي" + P("") / "كمم" + P("") / "عجم" + P("") / "صمم" + P("") / "سخي" + P("") / "نجي" + P("") / "صلے" + P("") / "قلے" + P("") / "الله" + P("") / "اكبر" + P("") / "محمد" + P("") / "صلعم" + P("") / "رسول" + P("") / "عليه" + P("") / "وسلم" + P("") / "صلى" + P("") / "صلى الله عليه وسلم" + P("") / "جل جلاله" + P("") / "ریال") + P("") * (P("") / "لحم" + P("") / "لحي" + P("") / "لحى" + P("") / "لجج" + P("") / "لجج" + P("") / "لخم" + P("") / "لخم" + P("") / "لمح" + P("") / "لمح" + P("") / "محج" + P("") / "محم" + P("") / "محي" + P("") / "مجح" + P("") / "مجم" + P("") / "مخج" + P("") / "مخم" + P("") / "مجخ" + P("") / "همج" + P("") / "همم" + P("") / "نحم" + P("") / "نحى" + P("") / "نجم" + P("") / "نجم" + P("") / "نجى" + P("") / "نمي" + P("") / "نمى" + P("") / "يمم" + P("") / "يمم" + P("") / "بخي" + P("") / "تجي" + P("") / "تجى" + P("") / "تخي" + P("") / "تخى" + P("") / "تمي" + P("") / "تمى" + P("") / "جمي" + P("") / "جحى" + P("") / "جمى" + P("") / "سخى" + P("") / "صحي" + P("") / "شحي" + P("") / "ضحي" + P("") / "لجي" + P("") / "لمي" + P("") / "يحي" + P("") / "يجي" + P("") / "يمي" + P("") / "ممي" + P("") / "قمي" + P("") / "نحي" + P("") / "قمح" + P("") / "لحم" + P("") / "عمي" + P("") / "كمي" + P("") / "نجح" + P("") / "مخي" + P("") / "لجم" + P("") / "كمم" + P("") / "لجم" + P("") / "نجح" + P("") / "جحي" + P("") / "حجي") + P("") * (P("") / "تجم" + P("") / "تحج" + P("") / "تحج" + P("") / "تحم" + P("") / "تخم" + P("") / "تمج" + P("") / "تمح" + P("") / "تمخ" + P("") / "جمح" + P("") / "جمح" + P("") / "حمي" + P("") / "حمى" + P("") / "سحج" + P("") / "سجح" + P("") / "سجى" + P("") / "سمح" + P("") / "سمح" + P("") / "سمج" + P("") / "سمم" + P("") / "سمم" + P("") / "صحح" + P("") / "صحح" + P("") / "صمم" + P("") / "شحم" + P("") / "شحم" + P("") / "شجي" + P("") / "شمخ" + P("") / "شمخ" + P("") / "شمم" + P("") / "شمم" + P("") / "ضحى" + P("") / "ضخم" + P("") / "ضخم" + P("") / "طمح" + P("") / "طمح" + P("") / "طمم" + P("") / "طمي" + P("") / "عجم" + P("") / "عمم" + P("") / "عمم" + P("") / "عمى" + P("") / "غمم" + P("") / "غمي" + P("") / "غمى" + P("") / "فخم" + P("") / "فخم" + P("") / "قمح" + P("") / "قمم") + P("") * (P("") / "حي" + P("") / "جى" + P("") / "جي" + P("") / "خى" + P("") / "خي" + P("") / "صى" + P("") / "صي" + P("") / "ضى" + P("") / "ضي" + P("") / "شج" + P("") / "شح" + P("") / "شخ" + P("") / "شم" + P("") / "شر" + P("") / "سر" + P("") / "صر" + P("") / "ضر" + P("") / "طى" + P("") / "طي" + P("") / "عى" + P("") / "عي" + P("") / "غى" + P("") / "غي" + P("") / "سى" + P("") / "سي" + P("") / "شى" + P("") / "شي" + P("") / "حى" + P("") / "حي" + P("") / "جى" + P("") / "جي" + P("") / "خى" + P("") / "خي" + P("") / "صى" + P("") / "صي" + P("") / "ضى" + P("") / "ضي" + P("") / "شج" + P("") / "شح" + P("") / "شخ" + P("") / "شم" + P("") / "شر" + P("") / "سر" + P("") / "صر" + P("") / "ضر" + P("") / "شج" + P("") / "شح" + P("") / "شخ" + P("") / "شم" + P("") / "سه" + P("") / "شه" + P("") / "طم" + P("") / "سج" + P("") / "سح" + P("") / "سخ" + P("") / "شج" + P("") / "شح" + P("") / "شخ" + P("") / "طم" + P("") / "ظم" + P("") / "اً" + P("") / "اً") + P("") * (P("") / "ض" + P("") / "ط" + P("") / "ط" + P("") / "ط" + P("") / "ط" + P("") / "ظ" + P("") / "ظ" + P("") / "ظ" + P("") / "ظ" + P("") / "ع" + P("") / "ع" + P("") / "ع" + P("") / "ع" + P("") / "غ" + P("") / "غ" + P("") / "غ" + P("") / "غ" + P("") / "ف" + P("") / "ف" + P("") / "ف" + P("") / "ف" + P("") / "ق" + P("") / "ق" + P("") / "ق" + P("") / "ق" + P("") / "ك" + P("") / "ك" + P("") / "ك" + P("") / "ك" + P("") / "ل" + P("") / "ل" + P("") / "ل" + P("") / "ل" + P("") / "م" + P("") / "م" + P("") / "م" + P("") / "م" + P("") / "ن" + P("") / "ن" + P("") / "ن" + P("") / "ن" + P("") / "ه" + P("") / "ه" + P("") / "ه" + P("") / "ه" + P("") / "و" + P("") / "و" + P("") / "ى" + P("") / "ى" + P("") / "ي" + P("") / "ي" + P("") / "ي" + P("") / "ي" + P("") / "لآ" + P("") / "لآ" + P("") / "لأ" + P("") / "لأ" + P("") / "لإ" + P("") / "لإ" + P("") / "لا" + P("") / "لا") + P("") * (P("") / "ء" + P("") / "آ" + P("") / "آ" + P("") / "أ" + P("") / "أ" + P("") / "ؤ" + P("") / "ؤ" + P("") / "إ" + P("") / "إ" + P("") / "ئ" + P("") / "ئ" + P("") / "ئ" + P("") / "ئ" + P("") / "ا" + P("") / "ا" + P("") / "ب" + P("") / "ب" + P("") / "ب" + P("") / "ب" + P("") / "ة" + P("") / "ة" + P("") / "ت" + P("") / "ت" + P("") / "ت" + P("") / "ت" + P("") / "ث" + P("") / "ث" + P("") / "ث" + P("") / "ث" + P("") / "ج" + P("") / "ج" + P("") / "ج" + P("") / "ج" + P("") / "ح" + P("") / "ح" + P("") / "ح" + P("") / "ح" + P("") / "خ" + P("") / "خ" + P("") / "خ" + P("") / "خ" + P("") / "د" + P("") / "د" + P("") / "ذ" + P("") / "ذ" + P("") / "ر" + P("") / "ر" + P("") / "ز" + P("") / "ز" + P("") / "س" + P("") / "س" + P("") / "س" + P("") / "س" + P("") / "ش" + P("") / "ش" + P("") / "ش" + P("") / "ش" + P("") / "ص" + P("") / "ص" + P("") / "ص" + P("") / "ص" + P("") / "ض" + P("") / "ض" + P("") / "ض") + P("") * (P("") / "〉" + P("") / "「" + P("") / "」" + P("") / "『" + P("") / "』" + P("") / "[" + P("") / "]" + P("") / "‾" + P("") / "‾" + P("") / "‾" + P("") / "‾" + P("") / "_" + P("") / "_" + P("") / "_" + P("") / "," + P("") / "、" + P("") / "." + P("") / ";" + P("") / ":" + P("") / "?" + P("") / "!" + P("") / "—" + P("") / "(" + P("") / ")" + P("") / "{" + P("") / "}" + P("") / "〔" + P("") / "〕" + P("") / "#" + P("") / "&" + P("") / "*" + P("") / "+" + P("") / "-" + P("") / "<" + P("") / ">" + P("") / "=" + P("") / "\\" + P("") / "$" + P("") / "%" + P("") / "@" + P("") / " ً" + P("") / "ـً" + P("") / " ٌ" + P("") / " ٍ" + P("") / " َ" + P("") / "ـَ" + P("") / " ُ" + P("") / "ـُ" + P("") / " ِ" + P("") / "ـِ" + P("") / " ّ" + P("") / "ـّ" + P("") / " ْ" + P("") / "ـْ") + P("") * (P("") / "," + P("") / "、" + P("") / "。" + P("") / ":" + P("") / ";" + P("") / "!" + P("") / "?" + P("") / "〖" + P("") / "〗" + P("") / "…" + P("") / "‥" + P("") / "—" + P("") / "–" + P("") / "_" + P("") / "_" + P("") / "(" + P("") / ")" + P("") / "{" + P("") / "}" + P("") / "〔" + P("") / "〕" + P("") / "【" + P("") / "】" + P("") / "《" + P("") / "》" + P("") / "〈") + P("") * (P("") / "ㅏ" + P("") / "ㅐ" + P("") / "ㅑ" + P("") / "ㅒ" + P("") / "ㅓ" + P("") / "ㅔ" + P("") / "ㅕ" + P("") / "ㅖ" + P("") / "ㅗ" + P("") / "ㅘ" + P("") / "ㅙ" + P("") / "ㅚ" + P("") / "ㅛ" + P("") / "ㅜ" + P("") / "ㅝ" + P("") / "ㅞ" + P("") / "ㅟ" + P("") / "ㅠ" + P("") / "ㅡ" + P("") / "ㅢ" + P("") / "ㅣ" + P("") / "¢" + P("") / "£" + P("") / "¬" + P("") / "¯" + P("") / "¦" + P("") / "¥" + P("") / "₩" + P("") / "│" + P("") / "←" + P("") / "↑" + P("") / "→" + P("") / "↓" + P("") / "■" + P("") / "○") + P("") * (P("") / "タ" + P("") / "チ" + P("") / "ツ" + P("") / "テ" + P("") / "ト" + P("") / "ナ" + P("") / "ニ" + P("") / "ヌ" + P("") / "ネ" + P("") / "ノ" + P("") / "ハ" + P("") / "ヒ" + P("") / "フ" + P("") / "ヘ" + P("") / "ホ" + P("") / "マ" + P("") / "ミ" + P("") / "ム" + P("") / "メ" + P("") / "モ" + P("") / "ヤ" + P("") / "ユ" + P("") / "ヨ" + P("") / "ラ" + P("") / "リ" + P("") / "ル" + P("") / "レ" + P("") / "ロ" + P("") / "ワ" + P("") / "ン" + P("") / "゙" + P("") / "゚" + P("") / "ㅤ" + P("") / "ㄱ" + P("") / "ㄲ" + P("") / "ㄳ" + P("") / "ㄴ" + P("") / "ㄵ" + P("") / "ㄶ" + P("") / "ㄷ" + P("") / "ㄸ" + P("") / "ㄹ" + P("") / "ㄺ" + P("") / "ㄻ" + P("") / "ㄼ" + P("") / "ㄽ" + P("") / "ㄾ" + P("") / "ㄿ" + P("") / "ㅀ" + P("") / "ㅁ" + P("") / "ㅂ" + P("") / "ㅃ" + P("") / "ㅄ" + P("") / "ㅅ" + P("") / "ㅆ" + P("") / "ㅇ" + P("") / "ㅈ" + P("") / "ㅉ" + P("") / "ㅊ" + P("") / "ㅋ" + P("") / "ㅌ" + P("") / "ㅍ" + P("") / "ㅎ") + P("") * (P("") / "`" + P("") / "a" + P("") / "b" + P("") / "c" + P("") / "d" + P("") / "e" + P("") / "f" + P("") / "g" + P("") / "h" + P("") / "i" + P("") / "j" + P("") / "k" + P("") / "l" + P("") / "m" + P("") / "n" + P("") / "o" + P("") / "p" + P("") / "q" + P("") / "r" + P("") / "s" + P("") / "t" + P("") / "u" + P("") / "v" + P("") / "w" + P("") / "x" + P("") / "y" + P("") / "z" + P("") / "{" + P("") / "|" + P("") / "}" + P("") / "~" + P("") / "⦅" + P("") / "⦆" + P("") / "。" + P("") / "「" + P("") / "」" + P("") / "、" + P("") / "・" + P("") / "ヲ" + P("") / "ァ" + P("") / "ィ" + P("") / "ゥ" + P("") / "ェ" + P("") / "ォ" + P("") / "ャ" + P("") / "ュ" + P("") / "ョ" + P("") / "ッ" + P("") / "ー" + P("") / "ア" + P("") / "イ" + P("") / "ウ" + P("") / "エ" + P("") / "オ" + P("") / "カ" + P("") / "キ" + P("") / "ク" + P("") / "ケ" + P("") / "コ" + P("") / "サ" + P("") / "シ" + P("") / "ス" + P("") / "セ" + P("") / "ソ") + P("") * (P("") / "!" + P("") / "\"" + P("") / "#" + P("") / "$" + P("") / "%" + P("") / "&" + P("") / "'" + P("") / "(" + P("") / ")" + P("") / "*" + P("") / "+" + P("") / "," + P("") / "-" + P("") / "." + P("") / "/" + P("") / "0" + P("") / "1" + P("") / "2" + P("") / "3" + P("") / "4" + P("") / "5" + P("") / "6" + P("") / "7" + P("") / "8" + P("") / "9" + P("") / ":" + P("") / ";" + P("") / "<" + P("") / "=" + P("") / ">" + P("") / "?" + P("") / "@" + P("") / "A" + P("") / "B" + P("") / "C" + P("") / "D" + P("") / "E" + P("") / "F" + P("") / "G" + P("") / "H" + P("") / "I" + P("") / "J" + P("") / "K" + P("") / "L" + P("") / "M" + P("") / "N" + P("") / "O" + P("") / "P" + P("") / "Q" + P("") / "R" + P("") / "S" + P("") / "T" + P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X" + P("") / "Y" + P("") / "Z" + P("") / "[" + P("") / "\\" + P("") / "]" + P("") / "^" + P("") / "_")) + P("") * (P("") * (P("") / "ъ" + P("") / "ь") + P("") * (P("") / "C" + P("") / "F" + P("") / "Q" + P("") / "Ħ" + P("") / "œ") + P("") * (P("") / "ꜧ" + P("") / "ꬷ" + P("") / "ɫ" + P("") / "ꭒ" + P("") / "ʍ") + P("") * P("") / "ꝯ")
M.decomposition_mapping.compatibility[4] = P("") * (P("") * (P("") * (P("") / "0" + P("") / "1" + P("") / "2" + P("") / "3" + P("") / "4" + P("") / "5" + P("") / "6" + P("") / "7" + P("") / "8" + P("") / "9") + P("") * (P("") / "〔本〕" + P("") / "〔三〕" + P("") / "〔二〕" + P("") / "〔安〕" + P("") / "〔点〕" + P("") / "〔打〕" + P("") / "〔盗〕" + P("") / "〔勝〕" + P("") / "〔敗〕" + P("") / "得" + P("") / "可") + P("") * (P("") / "ほか" + P("") / "ココ" + P("") / "サ" + P("") / "手" + P("") / "字" + P("") / "双" + P("") / "デ" + P("") / "二" + P("") / "多" + P("") / "解" + P("") / "天" + P("") / "交" + P("") / "映" + P("") / "無" + P("") / "料" + P("") / "前" + P("") / "後" + P("") / "再" + P("") / "新" + P("") / "初" + P("") / "終" + P("") / "生" + P("") / "販" + P("") / "声" + P("") / "吹" + P("") / "演" + P("") / "投" + P("") / "捕" + P("") / "一" + P("") / "三" + P("") / "遊" + P("") / "左" + P("") / "中" + P("") / "右" + P("") / "指" + P("") / "走" + P("") / "打" + P("") / "禁" + P("") / "空" + P("") / "合" + P("") / "満" + P("") / "有" + P("") / "月" + P("") / "申" + P("") / "割" + P("") / "営" + P("") / "配") + P("") * P("") / "DJ" + P("") * (P("") / "Q" + P("") / "R" + P("") / "S" + P("") / "T" + P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X" + P("") / "Y" + P("") / "Z" + P("") / "HV" + P("") / "MV" + P("") / "SD" + P("") / "SS" + P("") / "PPV" + P("") / "WC" + P("") / "MC" + P("") / "MD" + P("") / "MR") + P("") * (P("") / "0." + P("") / "0," + P("") / "1," + P("") / "2," + P("") / "3," + P("") / "4," + P("") / "5," + P("") / "6," + P("") / "7," + P("") / "8," + P("") / "9," + P("") / "(A)" + P("") / "(B)" + P("") / "(C)" + P("") / "(D)" + P("") / "(E)" + P("") / "(F)" + P("") / "(G)" + P("") / "(H)" + P("") / "(I)" + P("") / "(J)" + P("") / "(K)" + P("") / "(L)" + P("") / "(M)" + P("") / "(N)" + P("") / "(O)" + P("") / "(P)" + P("") / "(Q)" + P("") / "(R)" + P("") / "(S)" + P("") / "(T)" + P("") / "(U)" + P("") / "(V)" + P("") / "(W)" + P("") / "(X)" + P("") / "(Y)" + P("") / "(Z)" + P("") / "〔S〕" + P("") / "C" + P("") / "R" + P("") / "CD" + P("") / "WZ" + P("") / "A" + P("") / "B" + P("") / "C" + P("") / "D" + P("") / "E" + P("") / "F" + P("") / "G" + P("") / "H" + P("") / "I" + P("") / "J" + P("") / "K" + P("") / "L" + P("") / "M" + P("") / "N" + P("") / "O" + P("") / "P")) + P("") * (P("") * (P("") / "ː" + P("") / "ˑ" + P("") / "æ" + P("") / "ʙ" + P("") / "ɓ" + P("") / "ʣ" + P("") / "ꭦ" + P("") / "ʥ" + P("") / "ʤ" + P("") / "ɖ" + P("") / "ɗ" + P("") / "ᶑ" + P("") / "ɘ" + P("") / "ɞ" + P("") / "ʩ" + P("") / "ɤ" + P("") / "ɢ" + P("") / "ɠ" + P("") / "ʛ" + P("") / "ħ" + P("") / "ʜ" + P("") / "ɧ" + P("") / "ʄ" + P("") / "ʪ" + P("") / "ʫ" + P("") / "ɬ" + P("") / "𝼄" + P("") / "ꞎ" + P("") / "ɮ" + P("") / "𝼅" + P("") / "ʎ" + P("") / "𝼆" + P("") / "ø" + P("") / "ɶ" + P("") / "ɷ" + P("") / "q" + P("") / "ɺ" + P("") / "𝼈" + P("") / "ɽ" + P("") / "ɾ" + P("") / "ʀ" + P("") / "ʨ" + P("") / "ʦ" + P("") / "ꭧ" + P("") / "ʧ" + P("") / "ʈ" + P("") / "ⱱ" + P("") / "ʏ" + P("") / "ʡ" + P("") / "ʢ" + P("") / "ʘ" + P("") / "ǀ" + P("") / "ǁ" + P("") / "ǂ" + P("") / "𝼊" + P("") / "𝼞")) + P("") * (P("") * (P("") / "ا" + P("") / "ب" + P("") / "ج" + P("") / "د" + P("") / "ه" + P("") / "و" + P("") / "ز" + P("") / "ح" + P("") / "ط" + P("") / "ي" + P("") / "ل" + P("") / "م" + P("") / "ن" + P("") / "س" + P("") / "ع" + P("") / "ف" + P("") / "ص" + P("") / "ق" + P("") / "ر" + P("") / "ش" + P("") / "ت" + P("") / "ث" + P("") / "خ" + P("") / "ذ" + P("") / "ض" + P("") / "ظ" + P("") / "غ" + P("") / "ب" + P("") / "ج" + P("") / "د" + P("") / "و" + P("") / "ز" + P("") / "ح" + P("") / "ط" + P("") / "ي" + P("") / "ل" + P("") / "م" + P("") / "ن" + P("") / "س" + P("") / "ع" + P("") / "ف" + P("") / "ص" + P("") / "ق" + P("") / "ر" + P("") / "ش" + P("") / "ت" + P("") / "ث" + P("") / "خ" + P("") / "ذ" + P("") / "ض" + P("") / "ظ" + P("") / "غ") + P("") * (P("") / "т" + P("") / "у" + P("") / "ф" + P("") / "х" + P("") / "ц" + P("") / "ч" + P("") / "ш" + P("") / "ы" + P("") / "э" + P("") / "ю" + P("") / "ꚉ" + P("") / "ә" + P("") / "і" + P("") / "ј" + P("") / "ө" + P("") / "ү" + P("") / "ӏ" + P("") / "а" + P("") / "б" + P("") / "в" + P("") / "г" + P("") / "д" + P("") / "е" + P("") / "ж" + P("") / "з" + P("") / "и" + P("") / "к" + P("") / "л" + P("") / "о" + P("") / "п" + P("") / "с" + P("") / "у" + P("") / "ф" + P("") / "х" + P("") / "ц" + P("") / "ч" + P("") / "ш" + P("") / "ъ" + P("") / "ы" + P("") / "ґ" + P("") / "і" + P("") / "ѕ" + P("") / "џ" + P("") / "ҫ" + P("") / "ꙑ" + P("") / "ұ") + P("") * (P("") / "а" + P("") / "б" + P("") / "в" + P("") / "г" + P("") / "д" + P("") / "е" + P("") / "ж" + P("") / "з" + P("") / "и" + P("") / "к" + P("") / "л" + P("") / "м" + P("") / "о" + P("") / "п" + P("") / "р" + P("") / "с") + P("") * (P("") / "ج" + P("") / "ح" + P("") / "ي" + P("") / "ل" + P("") / "ن" + P("") / "س" + P("") / "ع" + P("") / "ص" + P("") / "ق" + P("") / "ش" + P("") / "خ" + P("") / "ض" + P("") / "غ" + P("") / "ں" + P("") / "ٯ" + P("") / "ب" + P("") / "ج" + P("") / "ه" + P("") / "ح" + P("") / "ط" + P("") / "ي" + P("") / "ك" + P("") / "م" + P("") / "ن" + P("") / "س" + P("") / "ع" + P("") / "ف" + P("") / "ص" + P("") / "ق" + P("") / "ش" + P("") / "ت" + P("") / "ث" + P("") / "خ" + P("") / "ض" + P("") / "ظ" + P("") / "غ" + P("") / "ٮ" + P("") / "ڡ") + P("") * (P("") / "ا" + P("") / "ب" + P("") / "ج" + P("") / "د" + P("") / "و" + P("") / "ز" + P("") / "ح" + P("") / "ط" + P("") / "ي" + P("") / "ك" + P("") / "ل" + P("") / "م" + P("") / "ن" + P("") / "س" + P("") / "ع" + P("") / "ف" + P("") / "ص" + P("") / "ق" + P("") / "ر" + P("") / "ش" + P("") / "ت" + P("") / "ث" + P("") / "خ" + P("") / "ذ" + P("") / "ض" + P("") / "ظ" + P("") / "غ" + P("") / "ٮ" + P("") / "ں" + P("") / "ڡ" + P("") / "ٯ" + P("") / "ب" + P("") / "ج" + P("") / "ه" + P("") / "ح" + P("") / "ي" + P("") / "ك" + P("") / "ل" + P("") / "م" + P("") / "ن" + P("") / "س" + P("") / "ع" + P("") / "ف" + P("") / "ص" + P("") / "ق" + P("") / "ش" + P("") / "ت" + P("") / "ث" + P("") / "خ" + P("") / "ض" + P("") / "غ")) + P("") * (P("") * (P("") / "k" + P("") / "l" + P("") / "m" + P("") / "n" + P("") / "p" + P("") / "q" + P("") / "r" + P("") / "s" + P("") / "t" + P("") / "u" + P("") / "v" + P("") / "w" + P("") / "x" + P("") / "y" + P("") / "z" + P("") / "A" + P("") / "B" + P("") / "C" + P("") / "D" + P("") / "E" + P("") / "F" + P("") / "G" + P("") / "H" + P("") / "I" + P("") / "J" + P("") / "K" + P("") / "L" + P("") / "M" + P("") / "N" + P("") / "O" + P("") / "P" + P("") / "Q" + P("") / "R" + P("") / "S" + P("") / "T" + P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X" + P("") / "Y" + P("") / "Z" + P("") / "a" + P("") / "b" + P("") / "c" + P("") / "d" + P("") / "e" + P("") / "f" + P("") / "g" + P("") / "h" + P("") / "i" + P("") / "j" + P("") / "k" + P("") / "l" + P("") / "m" + P("") / "n" + P("") / "o" + P("") / "p" + P("") / "q" + P("") / "r" + P("") / "s" + P("") / "t" + P("") / "u" + P("") / "v") + P("") * (P("") / "Y" + P("") / "Z" + P("") / "a" + P("") / "b" + P("") / "c" + P("") / "d" + P("") / "e" + P("") / "f" + P("") / "g" + P("") / "h" + P("") / "i" + P("") / "j" + P("") / "k" + P("") / "l" + P("") / "m" + P("") / "n" + P("") / "o" + P("") / "p" + P("") / "q" + P("") / "r" + P("") / "s" + P("") / "t" + P("") / "u" + P("") / "v" + P("") / "w" + P("") / "x" + P("") / "y" + P("") / "z" + P("") / "A" + P("") / "C" + P("") / "D" + P("") / "G" + P("") / "J" + P("") / "K" + P("") / "N" + P("") / "O" + P("") / "P" + P("") / "Q" + P("") / "S" + P("") / "T" + P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X" + P("") / "Y" + P("") / "Z" + P("") / "a" + P("") / "b" + P("") / "c" + P("") / "d" + P("") / "f" + P("") / "h" + P("") / "i" + P("") / "j") + P("") * (P("") / "M" + P("") / "N" + P("") / "O" + P("") / "P" + P("") / "Q" + P("") / "R" + P("") / "S" + P("") / "T" + P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X" + P("") / "Y" + P("") / "Z" + P("") / "a" + P("") / "b" + P("") / "c" + P("") / "d" + P("") / "e" + P("") / "f" + P("") / "g" + P("") / "i" + P("") / "j" + P("") / "k" + P("") / "l" + P("") / "m" + P("") / "n" + P("") / "o" + P("") / "p" + P("") / "q" + P("") / "r" + P("") / "s" + P("") / "t" + P("") / "u" + P("") / "v" + P("") / "w" + P("") / "x" + P("") / "y" + P("") / "z" + P("") / "A" + P("") / "B" + P("") / "C" + P("") / "D" + P("") / "E" + P("") / "F" + P("") / "G" + P("") / "H" + P("") / "I" + P("") / "J" + P("") / "K" + P("") / "L" + P("") / "M" + P("") / "N" + P("") / "O" + P("") / "P" + P("") / "Q" + P("") / "R" + P("") / "S" + P("") / "T" + P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X") + P("") * (P("") / "A" + P("") / "B" + P("") / "C" + P("") / "D" + P("") / "E" + P("") / "F" + P("") / "G" + P("") / "H" + P("") / "I" + P("") / "J" + P("") / "K" + P("") / "L" + P("") / "M" + P("") / "N" + P("") / "O" + P("") / "P" + P("") / "Q" + P("") / "R" + P("") / "S" + P("") / "T" + P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X" + P("") / "Y" + P("") / "Z" + P("") / "a" + P("") / "b" + P("") / "c" + P("") / "d" + P("") / "e" + P("") / "f" + P("") / "g" + P("") / "h" + P("") / "i" + P("") / "j" + P("") / "k" + P("") / "l" + P("") / "m" + P("") / "n" + P("") / "o" + P("") / "p" + P("") / "q" + P("") / "r" + P("") / "s" + P("") / "t" + P("") / "u" + P("") / "v" + P("") / "w" + P("") / "x" + P("") / "y" + P("") / "z" + P("") / "A" + P("") / "B" + P("") / "C" + P("") / "D" + P("") / "E" + P("") / "F" + P("") / "G" + P("") / "H" + P("") / "I" + P("") / "J" + P("") / "K" + P("") / "L") + P("") * (P("") / "g" + P("") / "h" + P("") / "i" + P("") / "j" + P("") / "k" + P("") / "l" + P("") / "m" + P("") / "n" + P("") / "o" + P("") / "p" + P("") / "q" + P("") / "r" + P("") / "s" + P("") / "t" + P("") / "u" + P("") / "v" + P("") / "w" + P("") / "x" + P("") / "y" + P("") / "z" + P("") / "A" + P("") / "B" + P("") / "C" + P("") / "D" + P("") / "E" + P("") / "F" + P("") / "G" + P("") / "H" + P("") / "I" + P("") / "J" + P("") / "K" + P("") / "L" + P("") / "M" + P("") / "N" + P("") / "O" + P("") / "P" + P("") / "Q" + P("") / "R" + P("") / "S" + P("") / "T" + P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X" + P("") / "Y" + P("") / "Z" + P("") / "a" + P("") / "b" + P("") / "c" + P("") / "d" + P("") / "e" + P("") / "f" + P("") / "g" + P("") / "h" + P("") / "i" + P("") / "j" + P("") / "k" + P("") / "l" + P("") / "m" + P("") / "n" + P("") / "o" + P("") / "p" + P("") / "q" + P("") / "r") + P("") * (P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X" + P("") / "Y" + P("") / "Z" + P("") / "a" + P("") / "b" + P("") / "c" + P("") / "d" + P("") / "e" + P("") / "f" + P("") / "g" + P("") / "h" + P("") / "i" + P("") / "j" + P("") / "k" + P("") / "l" + P("") / "m" + P("") / "n" + P("") / "o" + P("") / "p" + P("") / "q" + P("") / "r" + P("") / "s" + P("") / "t" + P("") / "u" + P("") / "v" + P("") / "w" + P("") / "x" + P("") / "y" + P("") / "z" + P("") / "A" + P("") / "B" + P("") / "C" + P("") / "D" + P("") / "E" + P("") / "F" + P("") / "G" + P("") / "H" + P("") / "I" + P("") / "J" + P("") / "K" + P("") / "L" + P("") / "M" + P("") / "N" + P("") / "O" + P("") / "P" + P("") / "Q" + P("") / "R" + P("") / "S" + P("") / "T" + P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X" + P("") / "Y" + P("") / "Z" + P("") / "a" + P("") / "b" + P("") / "c" + P("") / "d" + P("") / "e" + P("") / "f") + P("") * (P("") / "I" + P("") / "J" + P("") / "K" + P("") / "L" + P("") / "M" + P("") / "O" + P("") / "S" + P("") / "T" + P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X" + P("") / "Y" + P("") / "a" + P("") / "b" + P("") / "c" + P("") / "d" + P("") / "e" + P("") / "f" + P("") / "g" + P("") / "h" + P("") / "i" + P("") / "j" + P("") / "k" + P("") / "l" + P("") / "m" + P("") / "n" + P("") / "o" + P("") / "p" + P("") / "q" + P("") / "r" + P("") / "s" + P("") / "t" + P("") / "u" + P("") / "v" + P("") / "w" + P("") / "x" + P("") / "y" + P("") / "z" + P("") / "A" + P("") / "B" + P("") / "C" + P("") / "D" + P("") / "E" + P("") / "F" + P("") / "G" + P("") / "H" + P("") / "I" + P("") / "J" + P("") / "K" + P("") / "L" + P("") / "M" + P("") / "N" + P("") / "O" + P("") / "P" + P("") / "Q" + P("") / "R" + P("") / "S" + P("") / "T") + P("") * (P("") / "w" + P("") / "x" + P("") / "y" + P("") / "z" + P("") / "A" + P("") / "B" + P("") / "D" + P("") / "E" + P("") / "F" + P("") / "G" + P("") / "J" + P("") / "K" + P("") / "L" + P("") / "M" + P("") / "N" + P("") / "O" + P("") / "P" + P("") / "Q" + P("") / "S" + P("") / "T" + P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X" + P("") / "Y" + P("") / "a" + P("") / "b" + P("") / "c" + P("") / "d" + P("") / "e" + P("") / "f" + P("") / "g" + P("") / "h" + P("") / "i" + P("") / "j" + P("") / "k" + P("") / "l" + P("") / "m" + P("") / "n" + P("") / "o" + P("") / "p" + P("") / "q" + P("") / "r" + P("") / "s" + P("") / "t" + P("") / "u" + P("") / "v" + P("") / "w" + P("") / "x" + P("") / "y" + P("") / "z" + P("") / "A" + P("") / "B" + P("") / "D" + P("") / "E" + P("") / "F" + P("") / "G") + P("") * (P("") / "Ω" + P("") / "∇" + P("") / "α" + P("") / "β" + P("") / "γ" + P("") / "δ" + P("") / "ε" + P("") / "ζ" + P("") / "η" + P("") / "θ" + P("") / "ι" + P("") / "κ" + P("") / "λ" + P("") / "μ" + P("") / "ν" + P("") / "ξ" + P("") / "ο" + P("") / "π" + P("") / "ρ" + P("") / "ς" + P("") / "σ" + P("") / "τ" + P("") / "υ" + P("") / "φ" + P("") / "χ" + P("") / "ψ" + P("") / "ω" + P("") / "∂" + P("") / "ϵ" + P("") / "ϑ" + P("") / "ϰ" + P("") / "ϕ" + P("") / "ϱ" + P("") / "ϖ" + P("") / "Α" + P("") / "Β" + P("") / "Γ" + P("") / "Δ" + P("") / "Ε" + P("") / "Ζ" + P("") / "Η" + P("") / "Θ" + P("") / "Ι" + P("") / "Κ" + P("") / "Λ" + P("") / "Μ" + P("") / "Ν" + P("") / "Ξ" + P("") / "Ο" + P("") / "Π" + P("") / "Ρ" + P("") / "ϴ" + P("") / "Σ" + P("") / "Τ" + P("") / "Υ" + P("") / "Φ" + P("") / "Χ" + P("") / "Ψ" + P("") / "Ω" + P("") / "∇" + P("") / "α" + P("") / "β" + P("") / "γ" + P("") / "δ") + P("") * (P("") / "Q" + P("") / "R" + P("") / "S" + P("") / "T" + P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X" + P("") / "Y" + P("") / "Z" + P("") / "a" + P("") / "b" + P("") / "c" + P("") / "d" + P("") / "e" + P("") / "f" + P("") / "g" + P("") / "h" + P("") / "i" + P("") / "j" + P("") / "k" + P("") / "l" + P("") / "m" + P("") / "n" + P("") / "o" + P("") / "p" + P("") / "q" + P("") / "r" + P("") / "s" + P("") / "t" + P("") / "u" + P("") / "v" + P("") / "w" + P("") / "x" + P("") / "y" + P("") / "z" + P("") / "ı" + P("") / "ȷ" + P("") / "Α" + P("") / "Β" + P("") / "Γ" + P("") / "Δ" + P("") / "Ε" + P("") / "Ζ" + P("") / "Η" + P("") / "Θ" + P("") / "Ι" + P("") / "Κ" + P("") / "Λ" + P("") / "Μ" + P("") / "Ν" + P("") / "Ξ" + P("") / "Ο" + P("") / "Π" + P("") / "Ρ" + P("") / "ϴ" + P("") / "Σ" + P("") / "Τ" + P("") / "Υ" + P("") / "Φ" + P("") / "Χ" + P("") / "Ψ") + P("") * (P("") / "E" + P("") / "F" + P("") / "G" + P("") / "H" + P("") / "I" + P("") / "J" + P("") / "K" + P("") / "L" + P("") / "M" + P("") / "N" + P("") / "O" + P("") / "P" + P("") / "Q" + P("") / "R" + P("") / "S" + P("") / "T" + P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X" + P("") / "Y" + P("") / "Z" + P("") / "a" + P("") / "b" + P("") / "c" + P("") / "d" + P("") / "e" + P("") / "f" + P("") / "g" + P("") / "h" + P("") / "i" + P("") / "j" + P("") / "k" + P("") / "l" + P("") / "m" + P("") / "n" + P("") / "o" + P("") / "p" + P("") / "q" + P("") / "r" + P("") / "s" + P("") / "t" + P("") / "u" + P("") / "v" + P("") / "w" + P("") / "x" + P("") / "y" + P("") / "z" + P("") / "A" + P("") / "B" + P("") / "C" + P("") / "D" + P("") / "E" + P("") / "F" + P("") / "G" + P("") / "H" + P("") / "I" + P("") / "J" + P("") / "K" + P("") / "L" + P("") / "M" + P("") / "N" + P("") / "O" + P("") / "P") + P("") * (P("") / "s" + P("") / "t" + P("") / "u" + P("") / "v" + P("") / "w" + P("") / "x" + P("") / "y" + P("") / "z" + P("") / "A" + P("") / "B" + P("") / "C" + P("") / "D" + P("") / "E" + P("") / "F" + P("") / "G" + P("") / "H" + P("") / "I" + P("") / "J" + P("") / "K" + P("") / "L" + P("") / "M" + P("") / "N" + P("") / "O" + P("") / "P" + P("") / "Q" + P("") / "R" + P("") / "S" + P("") / "T" + P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X" + P("") / "Y" + P("") / "Z" + P("") / "a" + P("") / "b" + P("") / "c" + P("") / "d" + P("") / "e" + P("") / "f" + P("") / "g" + P("") / "h" + P("") / "i" + P("") / "j" + P("") / "k" + P("") / "l" + P("") / "m" + P("") / "n" + P("") / "o" + P("") / "p" + P("") / "q" + P("") / "r" + P("") / "s" + P("") / "t" + P("") / "u" + P("") / "v" + P("") / "w" + P("") / "x" + P("") / "y" + P("") / "z" + P("") / "A" + P("") / "B" + P("") / "C" + P("") / "D") + P("") * (P("") / "χ" + P("") / "ψ" + P("") / "ω" + P("") / "∂" + P("") / "ϵ" + P("") / "ϑ" + P("") / "ϰ" + P("") / "ϕ" + P("") / "ϱ" + P("") / "ϖ" + P("") / "Ϝ" + P("") / "ϝ" + P("") / "0" + P("") / "1" + P("") / "2" + P("") / "3" + P("") / "4" + P("") / "5" + P("") / "6" + P("") / "7" + P("") / "8" + P("") / "9" + P("") / "0" + P("") / "1" + P("") / "2" + P("") / "3" + P("") / "4" + P("") / "5" + P("") / "6" + P("") / "7" + P("") / "8" + P("") / "9" + P("") / "0" + P("") / "1" + P("") / "2" + P("") / "3" + P("") / "4" + P("") / "5" + P("") / "6" + P("") / "7" + P("") / "8" + P("") / "9" + P("") / "0" + P("") / "1" + P("") / "2" + P("") / "3" + P("") / "4" + P("") / "5" + P("") / "6" + P("") / "7" + P("") / "8" + P("") / "9" + P("") / "0" + P("") / "1" + P("") / "2" + P("") / "3" + P("") / "4" + P("") / "5" + P("") / "6" + P("") / "7" + P("") / "8" + P("") / "9") + P("") * (P("") / "ρ" + P("") / "ς" + P("") / "σ" + P("") / "τ" + P("") / "υ" + P("") / "φ" + P("") / "χ" + P("") / "ψ" + P("") / "ω" + P("") / "∂" + P("") / "ϵ" + P("") / "ϑ" + P("") / "ϰ" + P("") / "ϕ" + P("") / "ϱ" + P("") / "ϖ" + P("") / "Α" + P("") / "Β" + P("") / "Γ" + P("") / "Δ" + P("") / "Ε" + P("") / "Ζ" + P("") / "Η" + P("") / "Θ" + P("") / "Ι" + P("") / "Κ" + P("") / "Λ" + P("") / "Μ" + P("") / "Ν" + P("") / "Ξ" + P("") / "Ο" + P("") / "Π" + P("") / "Ρ" + P("") / "ϴ" + P("") / "Σ" + P("") / "Τ" + P("") / "Υ" + P("") / "Φ" + P("") / "Χ" + P("") / "Ψ" + P("") / "Ω" + P("") / "∇" + P("") / "α" + P("") / "β" + P("") / "γ" + P("") / "δ" + P("") / "ε" + P("") / "ζ" + P("") / "η" + P("") / "θ" + P("") / "ι" + P("") / "κ" + P("") / "λ" + P("") / "μ" + P("") / "ν" + P("") / "ξ" + P("") / "ο" + P("") / "π" + P("") / "ρ" + P("") / "ς" + P("") / "σ" + P("") / "τ" + P("") / "υ" + P("") / "φ") + P("") * (P("") / "λ" + P("") / "μ" + P("") / "ν" + P("") / "ξ" + P("") / "ο" + P("") / "π" + P("") / "ρ" + P("") / "ς" + P("") / "σ" + P("") / "τ" + P("") / "υ" + P("") / "φ" + P("") / "χ" + P("") / "ψ" + P("") / "ω" + P("") / "∂" + P("") / "ϵ" + P("") / "ϑ" + P("") / "ϰ" + P("") / "ϕ" + P("") / "ϱ" + P("") / "ϖ" + P("") / "Α" + P("") / "Β" + P("") / "Γ" + P("") / "Δ" + P("") / "Ε" + P("") / "Ζ" + P("") / "Η" + P("") / "Θ" + P("") / "Ι" + P("") / "Κ" + P("") / "Λ" + P("") / "Μ" + P("") / "Ν" + P("") / "Ξ" + P("") / "Ο" + P("") / "Π" + P("") / "Ρ" + P("") / "ϴ" + P("") / "Σ" + P("") / "Τ" + P("") / "Υ" + P("") / "Φ" + P("") / "Χ" + P("") / "Ψ" + P("") / "Ω" + P("") / "∇" + P("") / "α" + P("") / "β" + P("") / "γ" + P("") / "δ" + P("") / "ε" + P("") / "ζ" + P("") / "η" + P("") / "θ" + P("") / "ι" + P("") / "κ" + P("") / "λ" + P("") / "μ" + P("") / "ν" + P("") / "ξ" + P("") / "ο" + P("") / "π") + P("") * (P("") / "ε" + P("") / "ζ" + P("") / "η" + P("") / "θ" + P("") / "ι" + P("") / "κ" + P("") / "λ" + P("") / "μ" + P("") / "ν" + P("") / "ξ" + P("") / "ο" + P("") / "π" + P("") / "ρ" + P("") / "ς" + P("") / "σ" + P("") / "τ" + P("") / "υ" + P("") / "φ" + P("") / "χ" + P("") / "ψ" + P("") / "ω" + P("") / "∂" + P("") / "ϵ" + P("") / "ϑ" + P("") / "ϰ" + P("") / "ϕ" + P("") / "ϱ" + P("") / "ϖ" + P("") / "Α" + P("") / "Β" + P("") / "Γ" + P("") / "Δ" + P("") / "Ε" + P("") / "Ζ" + P("") / "Η" + P("") / "Θ" + P("") / "Ι" + P("") / "Κ" + P("") / "Λ" + P("") / "Μ" + P("") / "Ν" + P("") / "Ξ" + P("") / "Ο" + P("") / "Π" + P("") / "Ρ" + P("") / "ϴ" + P("") / "Σ" + P("") / "Τ" + P("") / "Υ" + P("") / "Φ" + P("") / "Χ" + P("") / "Ψ" + P("") / "Ω" + P("") / "∇" + P("") / "α" + P("") / "β" + P("") / "γ" + P("") / "δ" + P("") / "ε" + P("") / "ζ" + P("") / "η" + P("") / "θ" + P("") / "ι" + P("") / "κ")) + P("") * (P("") * (P("") / "A" + P("") / "B" + P("") / "C" + P("") / "D" + P("") / "E" + P("") / "F" + P("") / "G" + P("") / "H" + P("") / "I" + P("") / "J" + P("") / "K" + P("") / "L" + P("") / "M" + P("") / "N" + P("") / "O" + P("") / "P" + P("") / "Q" + P("") / "R" + P("") / "S" + P("") / "T" + P("") / "U" + P("") / "V" + P("") / "W" + P("") / "X" + P("") / "Y" + P("") / "Z" + P("") / "0" + P("") / "1" + P("") / "2" + P("") / "3" + P("") / "4" + P("") / "5" + P("") / "6" + P("") / "7" + P("") / "8" + P("") / "9")))
local s_base = 44032
local l_base = 4352
local v_base = 4449
local t_base = 4519
local l_count = 19
local v_count = 21
local t_count = 28
local n_count = v_count * t_count
local s_count = l_count * n_count
local function hangul_decompose_LV(byte)
  local s = utf8.codepoint(byte)
  local s_index = s - s_base
  local l_index = s_index // n_count
  local v_index = (s_index % n_count) // t_count
  local l_part = l_base + l_index
  local v_part = v_base + v_index
  return utf8.char(l_part) .. utf8.char(v_part)
end
local function hangul_decompose_LVT(byte)
  local s = utf8.codepoint(byte)
  local s_index = s - s_base
  local lv_index = (s_index // t_count) * t_count
  local t_index = s_index % t_count
  local lv_part = s_base + lv_index
  local t_part = t_base + t_index
  return utf8.char(lv_part) .. utf8.char(t_part)
end
function M.hangul_compose(first_byte, second_byte)
  local last = utf8.codepoint(first_byte)
  local ch = utf8.codepoint(second_byte)
  local l_index = last - l_base
  if 0 <= l_index and l_index < l_count then
    local v_index = ch - v_base
    if 0 <= v_index and v_index < v_count then
      return utf8.char(
        s_base + (l_index * v_count + v_index) * t_count
      )
    end
  end
  local s_index = last - s_base
  if 0 <= s_index and s_index < s_count
      and s_index % t_count == 0 then
    local t_index = ch - t_base
    if 0 < t_index and t_index < t_count then
      return utf8.char(last + t_index)
    end
  end
  return nil
end
M.decomposition_mapping.hangul = {}
M.decomposition_mapping.hangul.LV = {}
M.decomposition_mapping.hangul.LV[1] = fail
M.decomposition_mapping.hangul.LV[2] = fail
M.decomposition_mapping.hangul.LV[3] = C(P("") * (P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * P("") + P("") * (P("") + P("")) + P("") * (P("") + P(""))) + P("") * (P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")))) / hangul_decompose_LV
M.decomposition_mapping.hangul.LV[4] = fail
M.decomposition_mapping.hangul.LVT = {}
M.decomposition_mapping.hangul.LVT[1] = fail
M.decomposition_mapping.hangul.LVT[2] = fail
M.decomposition_mapping.hangul.LVT[3] = C(P("") * (P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R(""))) + P("") * (P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R(""))) + P("") * (P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R(""))) + P("") * (P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")) + P("") * (R("") + R("") + R("")))) / hangul_decompose_LVT
M.decomposition_mapping.hangul.LVT[4] = fail
M.composition_mapping = {starters = {}, both = {}}
M.composition_mapping.starters[1] = P("A") + P("C") + P("E") + P("I") + P("N") + P("O") + P("U") + P("Y") + P("a") + P("c") + P("e") + P("i") + P("n") + P("o") + P("u") + P("y") + P("D") + P("d") + P("G") + P("g") + P("H") + P("h") + P("J") + P("j") + P("K") + P("k") + P("L") + P("l") + P("R") + P("r") + P("S") + P("s") + P("T") + P("t") + P("W") + P("w") + P("Z") + P("z") + P("B") + P("b") + P("F") + P("f") + P("M") + P("m") + P("P") + P("p") + P("V") + P("v") + P("X") + P("x") + P("=") + P("<") + P(">")
M.composition_mapping.both[1] = {}
M.composition_mapping.both[1][1] = fail
M.composition_mapping.both[1][2] = P("c") * (P("") * (P("") / "ç" + P("") / "ć" + P("") / "ĉ" + P("") / "ċ" + P("") / "č")) + P("b") * (P("") * (P("") / "ḃ" + P("") / "ḅ" + P("") / "ḇ")) + P("a") * (P("") * (P("") / "à" + P("") / "á" + P("") / "â" + P("") / "ã" + P("") / "ä" + P("") / "å" + P("") / "ā" + P("") / "ă" + P("") / "ą" + P("") / "ǎ" + P("") / "ȁ" + P("") / "ȃ" + P("") / "ȧ" + P("") / "ḁ" + P("") / "ạ" + P("") / "ả")) + P("g") * (P("") * (P("") / "ĝ" + P("") / "ğ" + P("") / "ġ" + P("") / "ģ" + P("") / "ǧ" + P("") / "ǵ" + P("") / "ḡ")) + P("f") * P("") * P("") / "ḟ" + P("e") * (P("") * (P("") / "è" + P("") / "é" + P("") / "ê" + P("") / "ë" + P("") / "ē" + P("") / "ĕ" + P("") / "ė" + P("") / "ę" + P("") / "ě" + P("") / "ȅ" + P("") / "ȇ" + P("") / "ȩ" + P("") / "ḙ" + P("") / "ḛ" + P("") / "ẹ" + P("") / "ẻ" + P("") / "ẽ")) + P("d") * (P("") * (P("") / "ď" + P("") / "ḋ" + P("") / "ḍ" + P("") / "ḏ" + P("") / "ḑ" + P("") / "ḓ")) + P("k") * (P("") * (P("") / "ķ" + P("") / "ǩ" + P("") / "ḱ" + P("") / "ḳ" + P("") / "ḵ")) + P("j") * (P("") * (P("") / "ĵ" + P("") / "ǰ")) + P("i") * (P("") * (P("") / "ì" + P("") / "í" + P("") / "î" + P("") / "ï" + P("") / "ĩ" + P("") / "ī" + P("") / "ĭ" + P("") / "į" + P("") / "ǐ" + P("") / "ȉ" + P("") / "ȋ" + P("") / "ḭ" + P("") / "ỉ" + P("") / "ị")) + P("h") * (P("") * (P("") / "ĥ" + P("") / "ȟ" + P("") / "ḣ" + P("") / "ḥ" + P("") / "ḧ" + P("") / "ḩ" + P("") / "ḫ" + P("") / "ẖ")) + P("o") * (P("") * (P("") / "ò" + P("") / "ó" + P("") / "ô" + P("") / "õ" + P("") / "ö" + P("") / "ō" + P("") / "ŏ" + P("") / "ő" + P("") / "ơ" + P("") / "ǒ" + P("") / "ǫ" + P("") / "ȍ" + P("") / "ȏ" + P("") / "ȯ" + P("") / "ọ" + P("") / "ỏ")) + P("n") * (P("") * (P("") / "ñ" + P("") / "ń" + P("") / "ņ" + P("") / "ň" + P("") / "ǹ" + P("") / "ṅ" + P("") / "ṇ" + P("") / "ṉ" + P("") / "ṋ")) + P("m") * (P("") * (P("") / "ḿ" + P("") / "ṁ" + P("") / "ṃ")) + P("l") * (P("") * (P("") / "ĺ" + P("") / "ļ" + P("") / "ľ" + P("") / "ḷ" + P("") / "ḻ" + P("") / "ḽ")) + P("s") * (P("") * (P("") / "ś" + P("") / "ŝ" + P("") / "ş" + P("") / "š" + P("") / "ș" + P("") / "ṡ" + P("") / "ṣ")) + P("r") * (P("") * (P("") / "ŕ" + P("") / "ŗ" + P("") / "ř" + P("") / "ȑ" + P("") / "ȓ" + P("") / "ṙ" + P("") / "ṛ" + P("") / "ṟ")) + P("p") * (P("") * (P("") / "ṕ" + P("") / "ṗ")) + P("v") * (P("") * (P("") / "ṽ" + P("") / "ṿ")) + P("u") * (P("") * (P("") / "ù" + P("") / "ú" + P("") / "û" + P("") / "ü" + P("") / "ũ" + P("") / "ū" + P("") / "ŭ" + P("") / "ů" + P("") / "ű" + P("") / "ų" + P("") / "ư" + P("") / "ǔ" + P("") / "ȕ" + P("") / "ȗ" + P("") / "ṳ" + P("") / "ṵ" + P("") / "ṷ" + P("") / "ụ" + P("") / "ủ")) + P("t") * (P("") * (P("") / "ţ" + P("") / "ť" + P("") / "ț" + P("") / "ṫ" + P("") / "ṭ" + P("") / "ṯ" + P("") / "ṱ" + P("") / "ẗ")) + P("z") * (P("") * (P("") / "ź" + P("") / "ż" + P("") / "ž" + P("") / "ẑ" + P("") / "ẓ" + P("") / "ẕ")) + P("y") * (P("") * (P("") / "ý" + P("") / "ÿ" + P("") / "ŷ" + P("") / "ȳ" + P("") / "ẏ" + P("") / "ẙ" + P("") / "ỳ" + P("") / "ỵ" + P("") / "ỷ" + P("") / "ỹ")) + P("x") * (P("") * (P("") / "ẋ" + P("") / "ẍ")) + P(">") * P("") * P("") / "≯" + P("=") * P("") * P("") / "≠" + P("<") * P("") * P("") / "≮" + P("C") * (P("") * (P("") / "Ç" + P("") / "Ć" + P("") / "Ĉ" + P("") / "Ċ" + P("") / "Č")) + P("B") * (P("") * (P("") / "Ḃ" + P("") / "Ḅ" + P("") / "Ḇ")) + P("A") * (P("") * (P("") / "À" + P("") / "Á" + P("") / "Â" + P("") / "Ã" + P("") / "Ä" + P("") / "Å" + P("") / "Ā" + P("") / "Ă" + P("") / "Ą" + P("") / "Ǎ" + P("") / "Ȁ" + P("") / "Ȃ" + P("") / "Ȧ" + P("") / "Ḁ" + P("") / "Ạ" + P("") / "Ả")) + P("G") * (P("") * (P("") / "Ĝ" + P("") / "Ğ" + P("") / "Ġ" + P("") / "Ģ" + P("") / "Ǧ" + P("") / "Ǵ" + P("") / "Ḡ")) + P("F") * P("") * P("") / "Ḟ" + P("E") * (P("") * (P("") / "È" + P("") / "É" + P("") / "Ê" + P("") / "Ë" + P("") / "Ē" + P("") / "Ĕ" + P("") / "Ė" + P("") / "Ę" + P("") / "Ě" + P("") / "Ȅ" + P("") / "Ȇ" + P("") / "Ȩ" + P("") / "Ḙ" + P("") / "Ḛ" + P("") / "Ẹ" + P("") / "Ẻ" + P("") / "Ẽ")) + P("D") * (P("") * (P("") / "Ď" + P("") / "Ḋ" + P("") / "Ḍ" + P("") / "Ḏ" + P("") / "Ḑ" + P("") / "Ḓ")) + P("K") * (P("") * (P("") / "Ķ" + P("") / "Ǩ" + P("") / "Ḱ" + P("") / "Ḳ" + P("") / "Ḵ")) + P("J") * P("") * P("") / "Ĵ" + P("I") * (P("") * (P("") / "Ì" + P("") / "Í" + P("") / "Î" + P("") / "Ï" + P("") / "Ĩ" + P("") / "Ī" + P("") / "Ĭ" + P("") / "Į" + P("") / "İ" + P("") / "Ǐ" + P("") / "Ȉ" + P("") / "Ȋ" + P("") / "Ḭ" + P("") / "Ỉ" + P("") / "Ị")) + P("H") * (P("") * (P("") / "Ĥ" + P("") / "Ȟ" + P("") / "Ḣ" + P("") / "Ḥ" + P("") / "Ḧ" + P("") / "Ḩ" + P("") / "Ḫ")) + P("O") * (P("") * (P("") / "Ò" + P("") / "Ó" + P("") / "Ô" + P("") / "Õ" + P("") / "Ö" + P("") / "Ō" + P("") / "Ŏ" + P("") / "Ő" + P("") / "Ơ" + P("") / "Ǒ" + P("") / "Ǫ" + P("") / "Ȍ" + P("") / "Ȏ" + P("") / "Ȯ" + P("") / "Ọ" + P("") / "Ỏ")) + P("N") * (P("") * (P("") / "Ñ" + P("") / "Ń" + P("") / "Ņ" + P("") / "Ň" + P("") / "Ǹ" + P("") / "Ṅ" + P("") / "Ṇ" + P("") / "Ṉ" + P("") / "Ṋ")) + P("M") * (P("") * (P("") / "Ḿ" + P("") / "Ṁ" + P("") / "Ṃ")) + P("L") * (P("") * (P("") / "Ĺ" + P("") / "Ļ" + P("") / "Ľ" + P("") / "Ḷ" + P("") / "Ḻ" + P("") / "Ḽ")) + P("S") * (P("") * (P("") / "Ś" + P("") / "Ŝ" + P("") / "Ş" + P("") / "Š" + P("") / "Ș" + P("") / "Ṡ" + P("") / "Ṣ")) + P("R") * (P("") * (P("") / "Ŕ" + P("") / "Ŗ" + P("") / "Ř" + P("") / "Ȑ" + P("") / "Ȓ" + P("") / "Ṙ" + P("") / "Ṛ" + P("") / "Ṟ")) + P("P") * (P("") * (P("") / "Ṕ" + P("") / "Ṗ")) + P("W") * (P("") * (P("") / "Ŵ" + P("") / "Ẁ" + P("") / "Ẃ" + P("") / "Ẅ" + P("") / "Ẇ" + P("") / "Ẉ")) + P("V") * (P("") * (P("") / "Ṽ" + P("") / "Ṿ")) + P("U") * (P("") * (P("") / "Ù" + P("") / "Ú" + P("") / "Û" + P("") / "Ü" + P("") / "Ũ" + P("") / "Ū" + P("") / "Ŭ" + P("") / "Ů" + P("") / "Ű" + P("") / "Ų" + P("") / "Ư" + P("") / "Ǔ" + P("") / "Ȕ" + P("") / "Ȗ" + P("") / "Ṳ" + P("") / "Ṵ" + P("") / "Ṷ" + P("") / "Ụ" + P("") / "Ủ")) + P("T") * (P("") * (P("") / "Ţ" + P("") / "Ť" + P("") / "Ț" + P("") / "Ṫ" + P("") / "Ṭ" + P("") / "Ṯ" + P("") / "Ṱ")) + P("Z") * (P("") * (P("") / "Ź" + P("") / "Ż" + P("") / "Ž" + P("") / "Ẑ" + P("") / "Ẓ" + P("") / "Ẕ")) + P("Y") * (P("") * (P("") / "Ý" + P("") / "Ŷ" + P("") / "Ÿ" + P("") / "Ȳ" + P("") / "Ẏ" + P("") / "Ỳ" + P("") / "Ỵ" + P("") / "Ỷ" + P("") / "Ỹ")) + P("X") * (P("") * (P("") / "Ẋ" + P("") / "Ẍ")) + P("w") * (P("") * (P("") / "ŵ" + P("") / "ẁ" + P("") / "ẃ" + P("") / "ẅ" + P("") / "ẇ" + P("") / "ẉ" + P("") / "ẘ"))
M.composition_mapping.both[1][3] = fail
M.composition_mapping.both[1][4] = fail
M.composition_mapping.starters[2] = P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * P("")
M.composition_mapping.both[2] = {}
M.composition_mapping.both[2][1] = fail
M.composition_mapping.both[2][2] = P("") * (P("") * (P("") * (P("") / "Ấ" + P("") / "Ầ" + P("") / "Ẩ" + P("") / "Ẫ")) + P("") * P("") * P("") / "Ḉ" + P("") * (P("") * (P("") / "ǣ" + P("") / "ǽ")) + P("") * P("") * P("") / "ǻ" + P("") * P("") * P("") / "Ǟ" + P("") * (P("") * (P("") / "Ế" + P("") / "Ề" + P("") / "Ể" + P("") / "Ễ")) + P("") * P("") * P("") / "Ḯ" + P("") * (P("") * (P("") / "ố" + P("") / "ồ" + P("") / "ổ" + P("") / "ỗ")) + P("") * (P("") * (P("") / "ȭ" + P("") / "ṍ" + P("") / "ṏ")) + P("") * (P("") * (P("") / "ế" + P("") / "ề" + P("") / "ể" + P("") / "ễ")) + P("") * (P("") * (P("") / "ấ" + P("") / "ầ" + P("") / "ẩ" + P("") / "ẫ")) + P("") * P("") * P("") / "ḯ" + P("") * P("") * P("") / "ḉ" + P("") * P("") * P("") / "Ȫ" + P("") * (P("") * (P("") / "Ȭ" + P("") / "Ṍ" + P("") / "Ṏ")) + P("") * (P("") * (P("") / "Ố" + P("") / "Ồ" + P("") / "Ổ" + P("") / "Ỗ")) + P("") * P("") * P("") / "ȫ" + P("") * (P("") * (P("") / "Ǣ" + P("") / "Ǽ")) + P("") * P("") * P("") / "Ǻ" + P("") * P("") * P("") / "Ǿ" + P("") * P("") * P("") / "ǟ" + P("") * P("") * P("") / "ǿ" + P("") * (P("") * (P("") / "ǖ" + P("") / "ǘ" + P("") / "ǚ" + P("") / "ǜ")) + P("") * (P("") * (P("") / "Ǖ" + P("") / "Ǘ" + P("") / "Ǚ" + P("") / "Ǜ"))) + P("") * (P("") * (P("") * P("") / "῁" + P("") * (P("") / "΅" + P("") / "῭"))) + P("") * (P("") * P("") * P("") / "Ǭ" + P("") * P("") * P("") / "ǭ") + P("") * (P("") * (P("") * (P("") / "ớ" + P("") / "ờ" + P("") / "ở" + P("") / "ỡ" + P("") / "ợ")) + P("") * (P("") * (P("") / "Ớ" + P("") / "Ờ" + P("") / "Ở" + P("") / "Ỡ" + P("") / "Ợ")) + P("") * (P("") * (P("") / "ứ" + P("") / "ừ" + P("") / "ử" + P("") / "ữ" + P("") / "ự")) + P("") * (P("") * (P("") / "Ứ" + P("") / "Ừ" + P("") / "Ử" + P("") / "Ữ" + P("") / "Ự")) + P("") * P("") * P("") / "Ǯ") + P("") * (P("") * P("") * P("") / "ṧ" + P("") * P("") * P("") / "Ṧ" + P("") * P("") * P("") / "ṻ" + P("") * P("") * P("") / "ṥ" + P("") * P("") * P("") / "Ṥ" + P("") * P("") * P("") / "ṹ" + P("") * P("") * P("") / "Ṹ" + P("") * P("") * P("") / "ẛ" + P("") * P("") * P("") / "Ṻ" + P("") * (P("") * (P("") / "ṑ" + P("") / "ṓ")) + P("") * (P("") * (P("") / "Ṑ" + P("") / "Ṓ"))) + P("") * (P("") * (P("") * (P("") / "ḕ" + P("") / "ḗ")) + P("") * (P("") * (P("") / "Ắ" + P("") / "Ằ" + P("") / "Ẳ" + P("") / "Ẵ")) + P("") * (P("") * (P("") / "ắ" + P("") / "ằ" + P("") / "ẳ" + P("") / "ẵ")) + P("") * (P("") * (P("") / "Ḕ" + P("") / "Ḗ"))) + P("") * P("") * P("") * P("") / "ǯ" + P("") * (P("") * P("") * P("") / "ȱ" + P("") * P("") * P("") / "ḝ" + P("") * P("") * P("") / "Ḝ" + P("") * P("") * P("") / "ǡ" + P("") * P("") * P("") / "Ȱ" + P("") * P("") * P("") / "Ǡ") + P("") * (P("") * (P("") * P("") / "ῧ" + P("") * (P("") / "ΰ" + P("") / "ῢ")) + P("") * (P("") * P("") / "ῗ" + P("") * (P("") / "ΐ" + P("") / "ῒ")) + P("") * (P("") * (P("") / "ῳ" + P("") / "ῶ") + P("") * (P("") / "ώ" + P("") / "ὠ" + P("") / "ὡ" + P("") / "ὼ")) + P("") * (P("") * (P("") / "ῤ" + P("") / "ῥ")) + P("") * P("") * P("") / "ῴ" + P("") * (P("") * P("") / "ῦ" + P("") * (P("") / "ϋ" + P("") / "ύ" + P("") / "ὐ" + P("") / "ὑ" + P("") / "ὺ" + P("") / "ῠ" + P("") / "ῡ")) + P("") * (P("") * (P("") / "ϓ" + P("") / "ϔ"))) + P("") * (P("") * P("") * P("") / "Ῥ" + P("") * (P("") * P("") / "ῼ" + P("") * (P("") / "Ώ" + P("") / "Ὠ" + P("") / "Ὡ" + P("") / "Ὼ")) + P("") * (P("") * P("") / "ᾼ" + P("") * (P("") / "Ά" + P("") / "Ἀ" + P("") / "Ἁ" + P("") / "Ᾰ" + P("") / "Ᾱ" + P("") / "Ὰ")) + P("") * (P("") * P("") / "ῌ" + P("") * (P("") / "Ή" + P("") / "Ἠ" + P("") / "Ἡ" + P("") / "Ὴ")) + P("") * (P("") * (P("") / "ό" + P("") / "ὀ" + P("") / "ὁ" + P("") / "ὸ")) + P("") * (P("") * (P("") / "Έ" + P("") / "Ἐ" + P("") / "Ἑ" + P("") / "Ὲ")) + P("") * (P("") * P("") / "ῖ" + P("") * (P("") / "ί" + P("") / "ϊ" + P("") / "ἰ" + P("") / "ἱ" + P("") / "ὶ" + P("") / "ῐ" + P("") / "ῑ")) + P("") * (P("") * (P("") / "ῃ" + P("") / "ῆ") + P("") * (P("") / "ή" + P("") / "ἠ" + P("") / "ἡ" + P("") / "ὴ")) + P("") * (P("") * (P("") / "έ" + P("") / "ἐ" + P("") / "ἑ" + P("") / "ὲ")) + P("") * (P("") * (P("") / "Ί" + P("") / "Ϊ" + P("") / "Ἰ" + P("") / "Ἱ" + P("") / "Ῐ" + P("") / "Ῑ" + P("") / "Ὶ")) + P("") * (P("") * (P("") / "ᾳ" + P("") / "ᾶ") + P("") * (P("") / "ά" + P("") / "ἀ" + P("") / "ἁ" + P("") / "ὰ" + P("") / "ᾰ" + P("") / "ᾱ")) + P("") * (P("") * (P("") / "Ό" + P("") / "Ὀ" + P("") / "Ὁ" + P("") / "Ὸ")) + P("") * P("") * P("") / "ῄ" + P("") * (P("") * (P("") / "Ύ" + P("") / "Ϋ" + P("") / "Ὑ" + P("") / "Ῠ" + P("") / "Ῡ" + P("") / "Ὺ")) + P("") * P("") * P("") / "ᾴ") + P("") * (P("") * P("") * P("") / "ӛ" + P("") * P("") * P("") / "Ӛ" + P("") * P("") * P("") / "ӫ" + P("") * P("") * P("") / "Ӫ") + P("") * (P("") * (P("") * (P("") / "ў" + P("") / "ӯ" + P("") / "ӱ" + P("") / "ӳ")) + P("") * P("") * P("") / "ӹ" + P("") * P("") * P("") / "ӵ" + P("") * P("") * P("") / "ӭ" + P("") * P("") * P("") / "ї" + P("") * P("") * P("") / "ѷ" + P("") * P("") * P("") / "Ѷ") + P("") * (P("") * (P("") * (P("") / "Ў" + P("") / "Ӯ" + P("") / "Ӱ" + P("") / "Ӳ")) + P("") * P("") * P("") / "Ӵ" + P("") * P("") * P("") / "Ї" + P("") * P("") * P("") / "Ӹ" + P("") * P("") * P("") / "Ӭ" + P("") * P("") * P("") / "ӧ" + P("") * P("") * P("") / "Ѓ" + P("") * P("") * P("") / "Ќ" + P("") * P("") * P("") / "ӟ" + P("") * (P("") * (P("") / "Ӑ" + P("") / "Ӓ")) + P("") * (P("") * (P("") / "Ӂ" + P("") / "Ӝ")) + P("") * (P("") * (P("") / "ѐ" + P("") / "ё" + P("") / "ӗ")) + P("") * P("") * P("") / "Ӟ" + P("") * (P("") * (P("") / "ӑ" + P("") / "ӓ")) + P("") * P("") * P("") / "ќ" + P("") * (P("") * (P("") / "Ѐ" + P("") / "Ё" + P("") / "Ӗ")) + P("") * (P("") * (P("") / "й" + P("") / "ѝ" + P("") / "ӣ" + P("") / "ӥ")) + P("") * (P("") * (P("") / "ӂ" + P("") / "ӝ")) + P("") * P("") * P("") / "Ӧ" + P("") * (P("") * (P("") / "Ѝ" + P("") / "Й" + P("") / "Ӣ" + P("") / "Ӥ")) + P("") * P("") * P("") / "ѓ") + P("") * (P("") * P("") * P("") / "ۓ" + P("") * P("") * P("") / "ۀ" + P("") * P("") * P("") / "ۂ") + P("") * (P("") * P("") * P("") / "ئ" + P("") * P("") * P("") / "ؤ") + P("") * (P("") * (P("") * (P("") / "آ" + P("") / "أ" + P("") / "إ")))
M.composition_mapping.both[2][3] = fail
M.composition_mapping.both[2][4] = fail
M.composition_mapping.starters[3] = P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P(""))) + P("") * (P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("")) + P("") * P("") + P("") * P("") + P("") * P("") + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * P("") + P("") * P(""))
M.composition_mapping.both[3] = {}
M.composition_mapping.both[3][1] = fail
M.composition_mapping.both[3][2] = P("") * (P("") * (P("") * P("") * P("") / "⊅" + P("") * P("") * P("") / "⊬" + P("") * P("") * P("") / "⋢" + P("") * P("") * P("") / "⊉" + P("") * P("") * P("") / "⊈" + P("") * P("") * P("") / "⋭" + P("") * P("") * P("") / "⋬" + P("") * P("") * P("") / "⊯" + P("") * P("") * P("") / "⋫" + P("") * P("") * P("") / "⊮" + P("") * P("") * P("") / "⊭" + P("") * P("") * P("") / "⋪" + P("") * P("") * P("") / "⋣" + P("") * P("") * P("") / "⊄") + P("") * (P("") * P("") * P("") / "≄" + P("") * P("") * P("") / "≴" + P("") * P("") * P("") / "≢" + P("") * P("") * P("") / "⋡" + P("") * P("") * P("") / "≸" + P("") * P("") * P("") / "≇" + P("") * P("") * P("") / "≰" + P("") * P("") * P("") / "⊁" + P("") * P("") * P("") / "⊀" + P("") * P("") * P("") / "≱" + P("") * P("") * P("") / "≉" + P("") * P("") * P("") / "≹" + P("") * P("") * P("") / "≵" + P("") * P("") * P("") / "≭" + P("") * P("") * P("") / "⋠") + P("") * (P("") * P("") * P("") / "∌" + P("") * P("") * P("") / "∄" + P("") * P("") * P("") / "∉" + P("") * P("") * P("") / "∤" + P("") * P("") * P("") / "∦" + P("") * P("") * P("") / "≁") + P("") * (P("") * P("") * P("") / "⇏" + P("") * P("") * P("") / "⇎" + P("") * P("") * P("") / "⇍") + P("") * (P("") * P("") * P("") / "↛" + P("") * P("") * P("") / "↮" + P("") * P("") * P("") / "↚")) + P("") * (P("") * (P("") * P("") * P("") / "ộ" + P("") * P("") * P("") / "Ộ") + P("") * (P("") * (P("") * (P("") / "ậ" + P("") / "ặ")) + P("") * (P("") * (P("") / "Ậ" + P("") / "Ặ")) + P("") * P("") * P("") / "ệ" + P("") * P("") * P("") / "Ệ") + P("") * (P("") * P("") * P("") / "ṝ" + P("") * P("") * P("") / "Ṩ" + P("") * P("") * P("") / "ṩ" + P("") * P("") * P("") / "Ṝ") + P("") * (P("") * P("") * P("") / "Ḹ" + P("") * P("") * P("") / "ḹ") + P("") * (P("") * P("") * P("") / "ῇ" + P("") * P("") * P("") / "ῷ" + P("") * (P("") * P("") / "῟" + P("") * (P("") / "῝" + P("") / "῞"))) + P("") * (P("") * P("") * P("") / "ᾷ" + P("") * (P("") * P("") / "῏" + P("") * (P("") / "῍" + P("") / "῎"))) + P("") * (P("") * P("") * P("") / "ᾣ" + P("") * P("") * P("") / "ᾢ" + P("") * (P("") * (P("") / "ὧ" + P("") / "ᾡ") + P("") * (P("") / "ὣ" + P("") / "ὥ")) + P("") * (P("") * (P("") / "ὂ" + P("") / "ὄ")) + P("") * P("") * P("") / "ᾧ" + P("") * P("") * P("") / "ᾦ" + P("") * P("") * P("") / "ᾥ" + P("") * P("") * P("") / "ᾤ" + P("") * P("") * P("") / "ᾫ" + P("") * P("") * P("") / "ᾪ" + P("") * (P("") * (P("") / "Ὃ" + P("") / "Ὅ")) + P("") * (P("") * (P("") / "Ὂ" + P("") / "Ὄ")) + P("") * P("") * P("") / "ᾯ" + P("") * P("") * P("") / "ᾮ" + P("") * P("") * P("") / "ᾭ" + P("") * P("") * P("") / "ᾬ" + P("") * (P("") * P("") / "ὗ" + P("") * (P("") / "ὓ" + P("") / "ὕ")) + P("") * (P("") * P("") / "ὖ" + P("") * (P("") / "ὒ" + P("") / "ὔ")) + P("") * P("") * P("") / "ῂ" + P("") * (P("") * (P("") / "ὦ" + P("") / "ᾠ") + P("") * (P("") / "ὢ" + P("") / "ὤ")) + P("") * (P("") * P("") / "Ὗ" + P("") * (P("") / "Ὓ" + P("") / "Ὕ")) + P("") * P("") * P("") / "ᾲ" + P("") * (P("") * (P("") / "ὃ" + P("") / "ὅ")) + P("") * (P("") * (P("") / "Ὧ" + P("") / "ᾩ") + P("") * (P("") / "Ὣ" + P("") / "Ὥ")) + P("") * (P("") * (P("") / "Ὦ" + P("") / "ᾨ") + P("") * (P("") / "Ὢ" + P("") / "Ὤ")) + P("") * P("") * P("") / "ῲ") + P("") * (P("") * P("") * P("") / "ᾓ" + P("") * P("") * P("") / "ᾒ" + P("") * (P("") * (P("") / "ἧ" + P("") / "ᾑ") + P("") * (P("") / "ἣ" + P("") / "ἥ")) + P("") * (P("") * (P("") / "ἦ" + P("") / "ᾐ") + P("") * (P("") / "ἢ" + P("") / "ἤ")) + P("") * P("") * P("") / "ᾗ" + P("") * P("") * P("") / "ᾖ" + P("") * P("") * P("") / "ᾕ" + P("") * P("") * P("") / "ᾔ" + P("") * P("") * P("") / "ᾛ" + P("") * P("") * P("") / "ᾚ" + P("") * (P("") * (P("") / "Ἧ" + P("") / "ᾙ") + P("") * (P("") / "Ἣ" + P("") / "Ἥ")) + P("") * (P("") * (P("") / "Ἦ" + P("") / "ᾘ") + P("") * (P("") / "Ἢ" + P("") / "Ἤ")) + P("") * P("") * P("") / "ᾟ" + P("") * P("") * P("") / "ᾞ" + P("") * P("") * P("") / "ᾝ" + P("") * P("") * P("") / "ᾜ" + P("") * (P("") * P("") / "ἷ" + P("") * (P("") / "ἳ" + P("") / "ἵ")) + P("") * (P("") * P("") / "ἶ" + P("") * (P("") / "ἲ" + P("") / "ἴ")) + P("") * (P("") * P("") / "Ἷ" + P("") * (P("") / "Ἳ" + P("") / "Ἵ")) + P("") * (P("") * P("") / "Ἶ" + P("") * (P("") / "Ἲ" + P("") / "Ἴ")) + P("") * P("") * P("") / "ᾃ" + P("") * P("") * P("") / "ᾂ" + P("") * (P("") * (P("") / "ἇ" + P("") / "ᾁ") + P("") * (P("") / "ἃ" + P("") / "ἅ")) + P("") * (P("") * (P("") / "ἆ" + P("") / "ᾀ") + P("") * (P("") / "ἂ" + P("") / "ἄ")) + P("") * P("") * P("") / "ᾇ" + P("") * P("") * P("") / "ᾆ" + P("") * P("") * P("") / "ᾅ" + P("") * P("") * P("") / "ᾄ" + P("") * P("") * P("") / "ᾋ" + P("") * P("") * P("") / "ᾊ" + P("") * (P("") * (P("") / "Ἇ" + P("") / "ᾉ") + P("") * (P("") / "Ἃ" + P("") / "Ἅ")) + P("") * (P("") * (P("") / "Ἆ" + P("") / "ᾈ") + P("") * (P("") / "Ἂ" + P("") / "Ἄ")) + P("") * P("") * P("") / "ᾏ" + P("") * P("") * P("") / "ᾎ" + P("") * P("") * P("") / "ᾍ" + P("") * P("") * P("") / "ᾌ" + P("") * (P("") * (P("") / "ἓ" + P("") / "ἕ")) + P("") * (P("") * (P("") / "ἒ" + P("") / "ἔ")) + P("") * (P("") * (P("") / "Ἓ" + P("") / "Ἕ")) + P("") * (P("") * (P("") / "Ἒ" + P("") / "Ἔ"))))
M.composition_mapping.both[3][3] = P("") * (P("") * (P("") * P("") * P("") * P("") / "ゴ" + P("") * P("") * P("") * P("") / "ゲ" + P("") * P("") * P("") * P("") / "ヴ" + P("") * P("") * P("") * P("") / "ザ" + P("") * P("") * P("") * P("") / "ダ" + P("") * P("") * P("") * P("") / "ガ" + P("") * P("") * P("") * P("") / "ゾ" + P("") * P("") * P("") * P("") / "ズ" + P("") * P("") * P("") * P("") / "ゼ" + P("") * P("") * P("") * P("") / "グ" + P("") * P("") * P("") * P("") / "ジ" + P("") * P("") * P("") * P("") / "ギ" + P("") * P("") * P("") * P("") / "ゞ") + P("") * (P("") * P("") * P("") * P("") / "ぢ" + P("") * P("") * P("") * P("") / "で" + P("") * P("") * P("") * P("") / "づ" + P("") * P("") * P("") * P("") / "が" + P("") * P("") * P("") * P("") / "ど" + P("") * P("") * P("") * P("") / "ぐ" + P("") * P("") * P("") * P("") / "ぎ" + P("") * P("") * P("") * P("") / "ご" + P("") * (P("") * (P("") * (P("") / "び" + P("") / "ぴ"))) + P("") * P("") * P("") * P("") / "げ" + P("") * P("") * P("") * P("") / "じ" + P("") * P("") * P("") * P("") / "ゔ" + P("") * P("") * P("") * P("") / "ざ" + P("") * (P("") * (P("") * (P("") / "ぼ" + P("") / "ぽ"))) + P("") * P("") * P("") * P("") / "ぜ" + P("") * (P("") * (P("") * (P("") / "ぶ" + P("") / "ぷ"))) + P("") * P("") * P("") * P("") / "ず" + P("") * (P("") * (P("") * (P("") / "べ" + P("") / "ぺ"))) + P("") * P("") * P("") * P("") / "だ" + P("") * (P("") * (P("") * (P("") / "ば" + P("") / "ぱ"))) + P("") * P("") * P("") * P("") / "ぞ") + P("") * (P("") * (P("") * (P("") * (P("") / "ビ" + P("") / "ピ"))) + P("") * P("") * P("") * P("") / "ヂ" + P("") * P("") * P("") * P("") / "ヸ" + P("") * P("") * P("") * P("") / "デ" + P("") * (P("") * (P("") * (P("") / "ブ" + P("") / "プ"))) + P("") * P("") * P("") * P("") / "ヅ" + P("") * (P("") * (P("") * (P("") / "ボ" + P("") / "ポ"))) + P("") * P("") * P("") * P("") / "ヷ" + P("") * P("") * P("") * P("") / "ヺ" + P("") * P("") * P("") * P("") / "ド" + P("") * (P("") * (P("") * (P("") / "バ" + P("") / "パ"))) + P("") * P("") * P("") * P("") / "ヹ" + P("") * P("") * P("") * P("") / "ヾ" + P("") * (P("") * (P("") * (P("") / "ベ" + P("") / "ペ"))))) + P("") * (P("") * (P("") * P("") * P("") * P("") / "ᬒ" + P("") * P("") * P("") * P("") / "ᬆ" + P("") * P("") * P("") * P("") / "ᬌ" + P("") * P("") * P("") * P("") / "ᬻ" + P("") * P("") * P("") * P("") / "ᬊ" + P("") * P("") * P("") * P("") / "ᬈ" + P("") * P("") * P("") * P("") / "ᭁ" + P("") * P("") * P("") * P("") / "ᭀ" + P("") * P("") * P("") * P("") / "ᬎ" + P("") * P("") * P("") * P("") / "ᬽ") + P("") * P("") * P("") * P("") * P("") / "ᭃ" + P("") * P("") * P("") * P("") * P("") / "ဦ") + P("") * (P("") * (P("") * (P("") * (P("") * (P("") / "ೇ" + P("") / "ೈ" + P("") / "ೊ"))) + P("") * P("") * P("") * P("") / "ೋ") + P("") * P("") * P("") * P("") * P("") / "ೀ" + P("") * P("") * P("") * P("") * P("") / "ై" + P("") * (P("") * (P("") * (P("") * P("") / "ো" + P("") * P("") / "ৌ"))) + P("") * (P("") * (P("") * (P("") * P("") / "ൌ" + P("") * P("") / "ൊ")) + P("") * P("") * P("") * P("") / "ോ") + P("") * (P("") * P("") * P("") * P("") / "ऴ" + P("") * P("") * P("") * P("") / "ऱ" + P("") * P("") * P("") * P("") / "ऩ") + P("") * (P("") * (P("") * (P("") * (P("") / "ේ" + P("") / "ො" + P("") / "ෞ"))) + P("") * P("") * P("") * P("") / "ෝ") + P("") * (P("") * (P("") * (P("") * P("") / "ொ" + P("") * P("") / "ௌ")) + P("") * P("") * P("") * P("") / "ோ") + P("") * P("") * P("") * P("") * P("") / "ஔ" + P("") * (P("") * (P("") * (P("") * (P("") / "ୈ" + P("") / "ୌ") + P("") * P("") / "ୋ"))))
M.composition_mapping.both[3][4] = fail
M.composition_mapping.starters[4] = P("") * (P("") * (P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P(""))) + P("") * (P("") * P("") + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * P("") + P("") * P("") + P("") * (P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P(""))) + P("") * (P("") * (P("") + P(""))))
M.composition_mapping.both[4] = {}
M.composition_mapping.both[4][1] = fail
M.composition_mapping.both[4][2] = P("") * (P("") * (P("") * (P("") * P("") * P("") / "𐗉" + P("") * P("") * P("") / "𐗤")))
M.composition_mapping.both[4][3] = fail
M.composition_mapping.both[4][4] = P("") * (P("") * (P("") * (P("") * P("") * P("") * P("") * P("") / "𖵨" + P("") * P("") * P("") * P("") * P("") / "𖵩" + P("") * P("") * P("") * P("") * P("") / "𖵪") + P("") * (P("") * P("") * P("") * P("") * P("") / "𖄧" + P("") * (P("") * (P("") * (P("") * (P("") / "𖄦" + P("") / "𖄨")))) + P("") * (P("") * (P("") * (P("") * (P("") / "𖄡" + P("") / "𖄢" + P("") / "𖄣" + P("") / "𖄥")))) + P("") * P("") * P("") * P("") * P("") / "𖄤")) + P("") * (P("") * (P("") * (P("") * (P("") * (P("") * (P("") / "𑒻" + P("") / "𑒼" + P("") / "𑒾"))))) + P("") * (P("") * P("") * P("") * P("") * P("") / "𑖻" + P("") * P("") * P("") * P("") * P("") / "𑖺") + P("") * (P("") * P("") * P("") * P("") * P("") / "𑄯" + P("") * P("") * P("") * P("") * P("") / "𑄮") + P("") * P("") * P("") * P("") * P("") * P("") / "𑤸" + P("") * (P("") * (P("") * (P("") * (P("") * (P("") / "𑏅" + P("") / "𑏈") + P("") * P("") / "𑏇")))) + P("") * (P("") * P("") * P("") * P("") * P("") / "𑎎" + P("") * P("") * P("") * P("") * P("") / "𑎃" + P("") * P("") * P("") * P("") * P("") / "𑎑" + P("") * P("") * P("") * P("") * P("") / "𑎅") + P("") * (P("") * (P("") * (P("") * (P("") * P("") / "𑍌" + P("") * P("") / "𑍋")))) + P("") * (P("") * P("") * P("") * P("") * P("") / "𑂫" + P("") * P("") * P("") * P("") * P("") / "𑂚" + P("") * P("") * P("") * P("") * P("") / "𑂜")))
M.casefold_mapping = {}
M.casefold_mapping[1] = P("A") / "a" + P("B") / "b" + P("C") / "c" + P("D") / "d" + P("E") / "e" + P("F") / "f" + P("G") / "g" + P("H") / "h" + P("I") / "i" + P("J") / "j" + P("K") / "k" + P("L") / "l" + P("M") / "m" + P("N") / "n" + P("O") / "o" + P("P") / "p" + P("Q") / "q" + P("R") / "r" + P("S") / "s" + P("T") / "t" + P("U") / "u" + P("V") / "v" + P("W") / "w" + P("X") / "x" + P("Y") / "y" + P("Z") / "z"
M.casefold_mapping[2] = P("") * (P("") / "à" + P("") / "á" + P("") / "â" + P("") / "ã" + P("") / "ä" + P("") / "å" + P("") / "æ" + P("") / "ç" + P("") / "è" + P("") / "é" + P("") / "ê" + P("") / "ë" + P("") / "ì" + P("") / "í" + P("") / "î" + P("") / "ï" + P("") / "ð" + P("") / "ñ" + P("") / "ò" + P("") / "ó" + P("") / "ô" + P("") / "õ" + P("") / "ö" + P("") / "ø" + P("") / "ù" + P("") / "ú" + P("") / "û" + P("") / "ü" + P("") / "ý" + P("") / "þ" + P("") / "ss") + P("") * P("") / "μ" + P("") * (P("") / "ǆ" + P("") / "ǆ" + P("") / "ǉ" + P("") / "ǉ" + P("") / "ǌ" + P("") / "ǌ" + P("") / "ǎ" + P("") / "ǐ" + P("") / "ǒ" + P("") / "ǔ" + P("") / "ǖ" + P("") / "ǘ" + P("") / "ǚ" + P("") / "ǜ" + P("") / "ǟ" + P("") / "ǡ" + P("") / "ǣ" + P("") / "ǥ" + P("") / "ǧ" + P("") / "ǩ" + P("") / "ǫ" + P("") / "ǭ" + P("") / "ǯ" + P("") / "ǰ" + P("") / "ǳ" + P("") / "ǳ" + P("") / "ǵ" + P("") / "ƕ" + P("") / "ƿ" + P("") / "ǹ" + P("") / "ǻ" + P("") / "ǽ" + P("") / "ǿ") + P("") * (P("") / "ɓ" + P("") / "ƃ" + P("") / "ƅ" + P("") / "ɔ" + P("") / "ƈ" + P("") / "ɖ" + P("") / "ɗ" + P("") / "ƌ" + P("") / "ǝ" + P("") / "ə" + P("") / "ɛ" + P("") / "ƒ" + P("") / "ɠ" + P("") / "ɣ" + P("") / "ɩ" + P("") / "ɨ" + P("") / "ƙ" + P("") / "ɯ" + P("") / "ɲ" + P("") / "ɵ" + P("") / "ơ" + P("") / "ƣ" + P("") / "ƥ" + P("") / "ʀ" + P("") / "ƨ" + P("") / "ʃ" + P("") / "ƭ" + P("") / "ʈ" + P("") / "ư" + P("") / "ʊ" + P("") / "ʋ" + P("") / "ƴ" + P("") / "ƶ" + P("") / "ʒ" + P("") / "ƹ" + P("") / "ƽ") + P("") * (P("") / "ł" + P("") / "ń" + P("") / "ņ" + P("") / "ň" + P("") / "ʼn" + P("") / "ŋ" + P("") / "ō" + P("") / "ŏ" + P("") / "ő" + P("") / "œ" + P("") / "ŕ" + P("") / "ŗ" + P("") / "ř" + P("") / "ś" + P("") / "ŝ" + P("") / "ş" + P("") / "š" + P("") / "ţ" + P("") / "ť" + P("") / "ŧ" + P("") / "ũ" + P("") / "ū" + P("") / "ŭ" + P("") / "ů" + P("") / "ű" + P("") / "ų" + P("") / "ŵ" + P("") / "ŷ" + P("") / "ÿ" + P("") / "ź" + P("") / "ż" + P("") / "ž" + P("") / "s") + P("") * (P("") / "ā" + P("") / "ă" + P("") / "ą" + P("") / "ć" + P("") / "ĉ" + P("") / "ċ" + P("") / "č" + P("") / "ď" + P("") / "đ" + P("") / "ē" + P("") / "ĕ" + P("") / "ė" + P("") / "ę" + P("") / "ě" + P("") / "ĝ" + P("") / "ğ" + P("") / "ġ" + P("") / "ģ" + P("") / "ĥ" + P("") / "ħ" + P("") / "ĩ" + P("") / "ī" + P("") / "ĭ" + P("") / "į" + P("") / "i̇" + P("") / "ĳ" + P("") / "ĵ" + P("") / "ķ" + P("") / "ĺ" + P("") / "ļ" + P("") / "ľ" + P("") / "ŀ") + P("") * (P("") / "ɂ" + P("") / "ƀ" + P("") / "ʉ" + P("") / "ʌ" + P("") / "ɇ" + P("") / "ɉ" + P("") / "ɋ" + P("") / "ɍ" + P("") / "ɏ") + P("") * (P("") / "ȁ" + P("") / "ȃ" + P("") / "ȅ" + P("") / "ȇ" + P("") / "ȉ" + P("") / "ȋ" + P("") / "ȍ" + P("") / "ȏ" + P("") / "ȑ" + P("") / "ȓ" + P("") / "ȕ" + P("") / "ȗ" + P("") / "ș" + P("") / "ț" + P("") / "ȝ" + P("") / "ȟ" + P("") / "ƞ" + P("") / "ȣ" + P("") / "ȥ" + P("") / "ȧ" + P("") / "ȩ" + P("") / "ȫ" + P("") / "ȭ" + P("") / "ȯ" + P("") / "ȱ" + P("") / "ȳ" + P("") / "ⱥ" + P("") / "ȼ" + P("") / "ƚ" + P("") / "ⱦ") + P("") * (P("") / "σ" + P("") / "ϗ" + P("") / "β" + P("") / "θ" + P("") / "φ" + P("") / "π" + P("") / "ϙ" + P("") / "ϛ" + P("") / "ϝ" + P("") / "ϟ" + P("") / "ϡ" + P("") / "ϣ" + P("") / "ϥ" + P("") / "ϧ" + P("") / "ϩ" + P("") / "ϫ" + P("") / "ϭ" + P("") / "ϯ" + P("") / "κ" + P("") / "ρ" + P("") / "θ" + P("") / "ε" + P("") / "ϸ" + P("") / "ϲ" + P("") / "ϻ" + P("") / "ͻ" + P("") / "ͼ" + P("") / "ͽ") + P("") * (P("") / "ά" + P("") / "έ" + P("") / "ή" + P("") / "ί" + P("") / "ό" + P("") / "ύ" + P("") / "ώ" + P("") / "ΐ" + P("") / "α" + P("") / "β" + P("") / "γ" + P("") / "δ" + P("") / "ε" + P("") / "ζ" + P("") / "η" + P("") / "θ" + P("") / "ι" + P("") / "κ" + P("") / "λ" + P("") / "μ" + P("") / "ν" + P("") / "ξ" + P("") / "ο" + P("") / "π" + P("") / "ρ" + P("") / "σ" + P("") / "τ" + P("") / "υ" + P("") / "φ" + P("") / "χ" + P("") / "ψ" + P("") / "ω" + P("") / "ϊ" + P("") / "ϋ" + P("") / "ΰ") + P("") * (P("") / "ι" + P("") / "ͱ" + P("") / "ͳ" + P("") / "ͷ" + P("") / "ϳ") + P("") * (P("") / "ӏ" + P("") / "ӂ" + P("") / "ӄ" + P("") / "ӆ" + P("") / "ӈ" + P("") / "ӊ" + P("") / "ӌ" + P("") / "ӎ" + P("") / "ӑ" + P("") / "ӓ" + P("") / "ӕ" + P("") / "ӗ" + P("") / "ә" + P("") / "ӛ" + P("") / "ӝ" + P("") / "ӟ" + P("") / "ӡ" + P("") / "ӣ" + P("") / "ӥ" + P("") / "ӧ" + P("") / "ө" + P("") / "ӫ" + P("") / "ӭ" + P("") / "ӯ" + P("") / "ӱ" + P("") / "ӳ" + P("") / "ӵ" + P("") / "ӷ" + P("") / "ӹ" + P("") / "ӻ" + P("") / "ӽ" + P("") / "ӿ") + P("") * (P("") / "ҁ" + P("") / "ҋ" + P("") / "ҍ" + P("") / "ҏ" + P("") / "ґ" + P("") / "ғ" + P("") / "ҕ" + P("") / "җ" + P("") / "ҙ" + P("") / "қ" + P("") / "ҝ" + P("") / "ҟ" + P("") / "ҡ" + P("") / "ң" + P("") / "ҥ" + P("") / "ҧ" + P("") / "ҩ" + P("") / "ҫ" + P("") / "ҭ" + P("") / "ү" + P("") / "ұ" + P("") / "ҳ" + P("") / "ҵ" + P("") / "ҷ" + P("") / "ҹ" + P("") / "һ" + P("") / "ҽ" + P("") / "ҿ") + P("") * (P("") / "ѡ" + P("") / "ѣ" + P("") / "ѥ" + P("") / "ѧ" + P("") / "ѩ" + P("") / "ѫ" + P("") / "ѭ" + P("") / "ѯ" + P("") / "ѱ" + P("") / "ѳ" + P("") / "ѵ" + P("") / "ѷ" + P("") / "ѹ" + P("") / "ѻ" + P("") / "ѽ" + P("") / "ѿ") + P("") * (P("") / "ѐ" + P("") / "ё" + P("") / "ђ" + P("") / "ѓ" + P("") / "є" + P("") / "ѕ" + P("") / "і" + P("") / "ї" + P("") / "ј" + P("") / "љ" + P("") / "њ" + P("") / "ћ" + P("") / "ќ" + P("") / "ѝ" + P("") / "ў" + P("") / "џ" + P("") / "а" + P("") / "б" + P("") / "в" + P("") / "г" + P("") / "д" + P("") / "е" + P("") / "ж" + P("") / "з" + P("") / "и" + P("") / "й" + P("") / "к" + P("") / "л" + P("") / "м" + P("") / "н" + P("") / "о" + P("") / "п" + P("") / "р" + P("") / "с" + P("") / "т" + P("") / "у" + P("") / "ф" + P("") / "х" + P("") / "ц" + P("") / "ч" + P("") / "ш" + P("") / "щ" + P("") / "ъ" + P("") / "ы" + P("") / "ь" + P("") / "э" + P("") / "ю" + P("") / "я") + P("") * P("") / "եւ" + P("") * (P("") / "հ" + P("") / "ձ" + P("") / "ղ" + P("") / "ճ" + P("") / "մ" + P("") / "յ" + P("") / "ն" + P("") / "շ" + P("") / "ո" + P("") / "չ" + P("") / "պ" + P("") / "ջ" + P("") / "ռ" + P("") / "ս" + P("") / "վ" + P("") / "տ" + P("") / "ր" + P("") / "ց" + P("") / "ւ" + P("") / "փ" + P("") / "ք" + P("") / "օ" + P("") / "ֆ") + P("") * (P("") / "ԁ" + P("") / "ԃ" + P("") / "ԅ" + P("") / "ԇ" + P("") / "ԉ" + P("") / "ԋ" + P("") / "ԍ" + P("") / "ԏ" + P("") / "ԑ" + P("") / "ԓ" + P("") / "ԕ" + P("") / "ԗ" + P("") / "ԙ" + P("") / "ԛ" + P("") / "ԝ" + P("") / "ԟ" + P("") / "ԡ" + P("") / "ԣ" + P("") / "ԥ" + P("") / "ԧ" + P("") / "ԩ" + P("") / "ԫ" + P("") / "ԭ" + P("") / "ԯ" + P("") / "ա" + P("") / "բ" + P("") / "գ" + P("") / "դ" + P("") / "ե" + P("") / "զ" + P("") / "է" + P("") / "ը" + P("") / "թ" + P("") / "ժ" + P("") / "ի" + P("") / "լ" + P("") / "խ" + P("") / "ծ" + P("") / "կ")
M.casefold_mapping[3] = P("") * (P("") * (P("") / "Ꮀ" + P("") / "Ꮁ" + P("") / "Ꮂ" + P("") / "Ꮃ" + P("") / "Ꮄ" + P("") / "Ꮅ" + P("") / "Ꮆ" + P("") / "Ꮇ" + P("") / "Ꮈ" + P("") / "Ꮉ" + P("") / "Ꮊ" + P("") / "Ꮋ" + P("") / "Ꮌ" + P("") / "Ꮍ" + P("") / "Ꮎ" + P("") / "Ꮏ" + P("") / "Ꮐ" + P("") / "Ꮑ" + P("") / "Ꮒ" + P("") / "Ꮓ" + P("") / "Ꮔ" + P("") / "Ꮕ" + P("") / "Ꮖ" + P("") / "Ꮗ" + P("") / "Ꮘ" + P("") / "Ꮙ" + P("") / "Ꮚ" + P("") / "Ꮛ" + P("") / "Ꮜ" + P("") / "Ꮝ" + P("") / "Ꮞ" + P("") / "Ꮟ" + P("") / "Ꮠ" + P("") / "Ꮡ" + P("") / "Ꮢ" + P("") / "Ꮣ" + P("") / "Ꮤ" + P("") / "Ꮥ" + P("") / "Ꮦ" + P("") / "Ꮧ" + P("") / "Ꮨ" + P("") / "Ꮩ" + P("") / "Ꮪ" + P("") / "Ꮫ" + P("") / "Ꮬ" + P("") / "Ꮭ" + P("") / "Ꮮ" + P("") / "Ꮯ" + P("") / "Ꮰ" + P("") / "Ꮱ" + P("") / "Ꮲ" + P("") / "Ꮳ" + P("") / "Ꮴ" + P("") / "Ꮵ" + P("") / "Ꮶ" + P("") / "Ꮷ" + P("") / "Ꮸ" + P("") / "Ꮹ" + P("") / "Ꮺ" + P("") / "Ꮻ" + P("") / "Ꮼ" + P("") / "Ꮽ" + P("") / "Ꮾ" + P("") / "Ꮿ") + P("") * (P("") / "ꚁ" + P("") / "ꚃ" + P("") / "ꚅ" + P("") / "ꚇ" + P("") / "ꚉ" + P("") / "ꚋ" + P("") / "ꚍ" + P("") / "ꚏ" + P("") / "ꚑ" + P("") / "ꚓ" + P("") / "ꚕ" + P("") / "ꚗ" + P("") / "ꚙ" + P("") / "ꚛ") + P("") * (P("") / "ꙁ" + P("") / "ꙃ" + P("") / "ꙅ" + P("") / "ꙇ" + P("") / "ꙉ" + P("") / "ꙋ" + P("") / "ꙍ" + P("") / "ꙏ" + P("") / "ꙑ" + P("") / "ꙓ" + P("") / "ꙕ" + P("") / "ꙗ" + P("") / "ꙙ" + P("") / "ꙛ" + P("") / "ꙝ" + P("") / "ꙟ" + P("") / "ꙡ" + P("") / "ꙣ" + P("") / "ꙥ" + P("") / "ꙧ" + P("") / "ꙩ" + P("") / "ꙫ" + P("") / "ꙭ") + P("") * (P("") / "Ꭰ" + P("") / "Ꭱ" + P("") / "Ꭲ" + P("") / "Ꭳ" + P("") / "Ꭴ" + P("") / "Ꭵ" + P("") / "Ꭶ" + P("") / "Ꭷ" + P("") / "Ꭸ" + P("") / "Ꭹ" + P("") / "Ꭺ" + P("") / "Ꭻ" + P("") / "Ꭼ" + P("") / "Ꭽ" + P("") / "Ꭾ" + P("") / "Ꭿ") + P("") * (P("") / "ꟁ" + P("") / "ꟃ" + P("") / "ꞔ" + P("") / "ʂ" + P("") / "ᶎ" + P("") / "ꟈ" + P("") / "ꟊ" + P("") / "ɤ" + P("") / "ꟍ" + P("") / "ꟑ" + P("") / "ꟗ" + P("") / "ꟙ" + P("") / "ꟛ" + P("") / "ƛ" + P("") / "ꟶ") + P("") * (P("") / "ꞁ" + P("") / "ꞃ" + P("") / "ꞅ" + P("") / "ꞇ" + P("") / "ꞌ" + P("") / "ɥ" + P("") / "ꞑ" + P("") / "ꞓ" + P("") / "ꞗ" + P("") / "ꞙ" + P("") / "ꞛ" + P("") / "ꞝ" + P("") / "ꞟ" + P("") / "ꞡ" + P("") / "ꞣ" + P("") / "ꞥ" + P("") / "ꞧ" + P("") / "ꞩ" + P("") / "ɦ" + P("") / "ɜ" + P("") / "ɡ" + P("") / "ɬ" + P("") / "ɪ" + P("") / "ʞ" + P("") / "ʇ" + P("") / "ʝ" + P("") / "ꭓ" + P("") / "ꞵ" + P("") / "ꞷ" + P("") / "ꞹ" + P("") / "ꞻ" + P("") / "ꞽ" + P("") / "ꞿ") + P("") * (P("") / "ꝁ" + P("") / "ꝃ" + P("") / "ꝅ" + P("") / "ꝇ" + P("") / "ꝉ" + P("") / "ꝋ" + P("") / "ꝍ" + P("") / "ꝏ" + P("") / "ꝑ" + P("") / "ꝓ" + P("") / "ꝕ" + P("") / "ꝗ" + P("") / "ꝙ" + P("") / "ꝛ" + P("") / "ꝝ" + P("") / "ꝟ" + P("") / "ꝡ" + P("") / "ꝣ" + P("") / "ꝥ" + P("") / "ꝧ" + P("") / "ꝩ" + P("") / "ꝫ" + P("") / "ꝭ" + P("") / "ꝯ" + P("") / "ꝺ" + P("") / "ꝼ" + P("") / "ᵹ" + P("") / "ꝿ") + P("") * (P("") / "ꜣ" + P("") / "ꜥ" + P("") / "ꜧ" + P("") / "ꜩ" + P("") / "ꜫ" + P("") / "ꜭ" + P("") / "ꜯ" + P("") / "ꜳ" + P("") / "ꜵ" + P("") / "ꜷ" + P("") / "ꜹ" + P("") / "ꜻ" + P("") / "ꜽ" + P("") / "ꜿ")) + P("") * (P("") * (P("") / "ⴠ" + P("") / "ⴡ" + P("") / "ⴢ" + P("") / "ⴣ" + P("") / "ⴤ" + P("") / "ⴥ" + P("") / "ⴧ" + P("") / "ⴭ") + P("") * (P("") / "в" + P("") / "д" + P("") / "о" + P("") / "с" + P("") / "т" + P("") / "т" + P("") / "ъ" + P("") / "ѣ" + P("") / "ꙋ" + P("") / "ᲊ" + P("") / "ა" + P("") / "ბ" + P("") / "გ" + P("") / "დ" + P("") / "ე" + P("") / "ვ" + P("") / "ზ" + P("") / "თ" + P("") / "ი" + P("") / "კ" + P("") / "ლ" + P("") / "მ" + P("") / "ნ" + P("") / "ო" + P("") / "პ" + P("") / "ჟ" + P("") / "რ" + P("") / "ს" + P("") / "ტ" + P("") / "უ" + P("") / "ფ" + P("") / "ქ" + P("") / "ღ" + P("") / "ყ" + P("") / "შ" + P("") / "ჩ" + P("") / "ც" + P("") / "ძ" + P("") / "წ" + P("") / "ჭ" + P("") / "ხ" + P("") / "ჯ" + P("") / "ჰ" + P("") / "ჱ" + P("") / "ჲ" + P("") / "ჳ" + P("") / "ჴ" + P("") / "ჵ" + P("") / "ჶ" + P("") / "ჷ" + P("") / "ჸ" + P("") / "ჹ" + P("") / "ჺ" + P("") / "ჽ" + P("") / "ჾ" + P("") / "ჿ") + P("") * (P("") / "ὴι" + P("") / "ηι" + P("") / "ήι" + P("") / "ῆ" + P("") / "ῆι" + P("") / "ὲ" + P("") / "έ" + P("") / "ὴ" + P("") / "ή" + P("") / "ηι" + P("") / "ῒ" + P("") / "ΐ" + P("") / "ῖ" + P("") / "ῗ" + P("") / "ῐ" + P("") / "ῑ" + P("") / "ὶ" + P("") / "ί" + P("") / "ῢ" + P("") / "ΰ" + P("") / "ῤ" + P("") / "ῦ" + P("") / "ῧ" + P("") / "ῠ" + P("") / "ῡ" + P("") / "ὺ" + P("") / "ύ" + P("") / "ῥ" + P("") / "ὼι" + P("") / "ωι" + P("") / "ώι" + P("") / "ῶ" + P("") / "ῶι" + P("") / "ὸ" + P("") / "ό" + P("") / "ὼ" + P("") / "ώ" + P("") / "ωι") + P("") * (P("") / "ⴀ" + P("") / "ⴁ" + P("") / "ⴂ" + P("") / "ⴃ" + P("") / "ⴄ" + P("") / "ⴅ" + P("") / "ⴆ" + P("") / "ⴇ" + P("") / "ⴈ" + P("") / "ⴉ" + P("") / "ⴊ" + P("") / "ⴋ" + P("") / "ⴌ" + P("") / "ⴍ" + P("") / "ⴎ" + P("") / "ⴏ" + P("") / "ⴐ" + P("") / "ⴑ" + P("") / "ⴒ" + P("") / "ⴓ" + P("") / "ⴔ" + P("") / "ⴕ" + P("") / "ⴖ" + P("") / "ⴗ" + P("") / "ⴘ" + P("") / "ⴙ" + P("") / "ⴚ" + P("") / "ⴛ" + P("") / "ⴜ" + P("") / "ⴝ" + P("") / "ⴞ" + P("") / "ⴟ") + P("") * (P("") / "ề" + P("") / "ể" + P("") / "ễ" + P("") / "ệ" + P("") / "ỉ" + P("") / "ị" + P("") / "ọ" + P("") / "ỏ" + P("") / "ố" + P("") / "ồ" + P("") / "ổ" + P("") / "ỗ" + P("") / "ộ" + P("") / "ớ" + P("") / "ờ" + P("") / "ở" + P("") / "ỡ" + P("") / "ợ" + P("") / "ụ" + P("") / "ủ" + P("") / "ứ" + P("") / "ừ" + P("") / "ử" + P("") / "ữ" + P("") / "ự" + P("") / "ỳ" + P("") / "ỵ" + P("") / "ỷ" + P("") / "ỹ" + P("") / "ỻ" + P("") / "ỽ" + P("") / "ỿ") + P("") * (P("") / "ẁ" + P("") / "ẃ" + P("") / "ẅ" + P("") / "ẇ" + P("") / "ẉ" + P("") / "ẋ" + P("") / "ẍ" + P("") / "ẏ" + P("") / "ẑ" + P("") / "ẓ" + P("") / "ẕ" + P("") / "ẖ" + P("") / "ẗ" + P("") / "ẘ" + P("") / "ẙ" + P("") / "aʾ" + P("") / "ṡ" + P("") / "ss" + P("") / "ạ" + P("") / "ả" + P("") / "ấ" + P("") / "ầ" + P("") / "ẩ" + P("") / "ẫ" + P("") / "ậ" + P("") / "ắ" + P("") / "ằ" + P("") / "ẳ" + P("") / "ẵ" + P("") / "ặ" + P("") / "ẹ" + P("") / "ẻ" + P("") / "ẽ" + P("") / "ế") + P("") * (P("") / "ṁ" + P("") / "ṃ" + P("") / "ṅ" + P("") / "ṇ" + P("") / "ṉ" + P("") / "ṋ" + P("") / "ṍ" + P("") / "ṏ" + P("") / "ṑ" + P("") / "ṓ" + P("") / "ṕ" + P("") / "ṗ" + P("") / "ṙ" + P("") / "ṛ" + P("") / "ṝ" + P("") / "ṟ" + P("") / "ṡ" + P("") / "ṣ" + P("") / "ṥ" + P("") / "ṧ" + P("") / "ṩ" + P("") / "ṫ" + P("") / "ṭ" + P("") / "ṯ" + P("") / "ṱ" + P("") / "ṳ" + P("") / "ṵ" + P("") / "ṷ" + P("") / "ṹ" + P("") / "ṻ" + P("") / "ṽ" + P("") / "ṿ") + P("") * (P("") / "ḁ" + P("") / "ḃ" + P("") / "ḅ" + P("") / "ḇ" + P("") / "ḉ" + P("") / "ḋ" + P("") / "ḍ" + P("") / "ḏ" + P("") / "ḑ" + P("") / "ḓ" + P("") / "ḕ" + P("") / "ḗ" + P("") / "ḙ" + P("") / "ḛ" + P("") / "ḝ" + P("") / "ḟ" + P("") / "ḡ" + P("") / "ḣ" + P("") / "ḥ" + P("") / "ḧ" + P("") / "ḩ" + P("") / "ḫ" + P("") / "ḭ" + P("") / "ḯ" + P("") / "ḱ" + P("") / "ḳ" + P("") / "ḵ" + P("") / "ḷ" + P("") / "ḹ" + P("") / "ḻ" + P("") / "ḽ" + P("") / "ḿ") + P("") * (P("") / "Ᏸ" + P("") / "Ᏹ" + P("") / "Ᏺ" + P("") / "Ᏻ" + P("") / "Ᏼ" + P("") / "Ᏽ") + P("") * (P("") / "ἀι" + P("") / "ἁι" + P("") / "ἂι" + P("") / "ἃι" + P("") / "ἄι" + P("") / "ἅι" + P("") / "ἆι" + P("") / "ἇι" + P("") / "ἀι" + P("") / "ἁι" + P("") / "ἂι" + P("") / "ἃι" + P("") / "ἄι" + P("") / "ἅι" + P("") / "ἆι" + P("") / "ἇι" + P("") / "ἠι" + P("") / "ἡι" + P("") / "ἢι" + P("") / "ἣι" + P("") / "ἤι" + P("") / "ἥι" + P("") / "ἦι" + P("") / "ἧι" + P("") / "ἠι" + P("") / "ἡι" + P("") / "ἢι" + P("") / "ἣι" + P("") / "ἤι" + P("") / "ἥι" + P("") / "ἦι" + P("") / "ἧι" + P("") / "ὠι" + P("") / "ὡι" + P("") / "ὢι" + P("") / "ὣι" + P("") / "ὤι" + P("") / "ὥι" + P("") / "ὦι" + P("") / "ὧι" + P("") / "ὠι" + P("") / "ὡι" + P("") / "ὢι" + P("") / "ὣι" + P("") / "ὤι" + P("") / "ὥι" + P("") / "ὦι" + P("") / "ὧι" + P("") / "ὰι" + P("") / "αι" + P("") / "άι" + P("") / "ᾶ" + P("") / "ᾶι" + P("") / "ᾰ" + P("") / "ᾱ" + P("") / "ὰ" + P("") / "ά" + P("") / "αι" + P("") / "ι") + P("") * (P("") / "ὀ" + P("") / "ὁ" + P("") / "ὂ" + P("") / "ὃ" + P("") / "ὄ" + P("") / "ὅ" + P("") / "ὐ" + P("") / "ὒ" + P("") / "ὔ" + P("") / "ὖ" + P("") / "ὑ" + P("") / "ὓ" + P("") / "ὕ" + P("") / "ὗ" + P("") / "ὠ" + P("") / "ὡ" + P("") / "ὢ" + P("") / "ὣ" + P("") / "ὤ" + P("") / "ὥ" + P("") / "ὦ" + P("") / "ὧ") + P("") * (P("") / "ἀ" + P("") / "ἁ" + P("") / "ἂ" + P("") / "ἃ" + P("") / "ἄ" + P("") / "ἅ" + P("") / "ἆ" + P("") / "ἇ" + P("") / "ἐ" + P("") / "ἑ" + P("") / "ἒ" + P("") / "ἓ" + P("") / "ἔ" + P("") / "ἕ" + P("") / "ἠ" + P("") / "ἡ" + P("") / "ἢ" + P("") / "ἣ" + P("") / "ἤ" + P("") / "ἥ" + P("") / "ἦ" + P("") / "ἧ" + P("") / "ἰ" + P("") / "ἱ" + P("") / "ἲ" + P("") / "ἳ" + P("") / "ἴ" + P("") / "ἵ" + P("") / "ἶ" + P("") / "ἷ")) + P("") * (P("") * (P("") / "ａ" + P("") / "ｂ" + P("") / "ｃ" + P("") / "ｄ" + P("") / "ｅ" + P("") / "ｆ" + P("") / "ｇ" + P("") / "ｈ" + P("") / "ｉ" + P("") / "ｊ" + P("") / "ｋ" + P("") / "ｌ" + P("") / "ｍ" + P("") / "ｎ" + P("") / "ｏ" + P("") / "ｐ" + P("") / "ｑ" + P("") / "ｒ" + P("") / "ｓ" + P("") / "ｔ" + P("") / "ｕ" + P("") / "ｖ" + P("") / "ｗ" + P("") / "ｘ" + P("") / "ｙ" + P("") / "ｚ") + P("") * (P("") / "ff" + P("") / "fi" + P("") / "fl" + P("") / "ffi" + P("") / "ffl" + P("") / "st" + P("") / "st" + P("") / "մն" + P("") / "մե" + P("") / "մի" + P("") / "վն" + P("") / "մխ")) + P("") * (P("") * (P("") / "ⓚ" + P("") / "ⓛ" + P("") / "ⓜ" + P("") / "ⓝ" + P("") / "ⓞ" + P("") / "ⓟ" + P("") / "ⓠ" + P("") / "ⓡ" + P("") / "ⓢ" + P("") / "ⓣ" + P("") / "ⓤ" + P("") / "ⓥ" + P("") / "ⓦ" + P("") / "ⓧ" + P("") / "ⓨ" + P("") / "ⓩ") + P("") * (P("") / "ⓐ" + P("") / "ⓑ" + P("") / "ⓒ" + P("") / "ⓓ" + P("") / "ⓔ" + P("") / "ⓕ" + P("") / "ⓖ" + P("") / "ⓗ" + P("") / "ⓘ" + P("") / "ⓙ") + P("") * (P("") / "ⱡ" + P("") / "ɫ" + P("") / "ᵽ" + P("") / "ɽ" + P("") / "ⱨ" + P("") / "ⱪ" + P("") / "ⱬ" + P("") / "ɑ" + P("") / "ɱ" + P("") / "ɐ" + P("") / "ɒ" + P("") / "ⱳ" + P("") / "ⱶ" + P("") / "ȿ" + P("") / "ɀ") + P("") * (P("") / "ⰰ" + P("") / "ⰱ" + P("") / "ⰲ" + P("") / "ⰳ" + P("") / "ⰴ" + P("") / "ⰵ" + P("") / "ⰶ" + P("") / "ⰷ" + P("") / "ⰸ" + P("") / "ⰹ" + P("") / "ⰺ" + P("") / "ⰻ" + P("") / "ⰼ" + P("") / "ⰽ" + P("") / "ⰾ" + P("") / "ⰿ" + P("") / "ⱀ" + P("") / "ⱁ" + P("") / "ⱂ" + P("") / "ⱃ" + P("") / "ⱄ" + P("") / "ⱅ" + P("") / "ⱆ" + P("") / "ⱇ" + P("") / "ⱈ" + P("") / "ⱉ" + P("") / "ⱊ" + P("") / "ⱋ" + P("") / "ⱌ" + P("") / "ⱍ" + P("") / "ⱎ" + P("") / "ⱏ" + P("") / "ⱐ" + P("") / "ⱑ" + P("") / "ⱒ" + P("") / "ⱓ" + P("") / "ⱔ" + P("") / "ⱕ" + P("") / "ⱖ" + P("") / "ⱗ" + P("") / "ⱘ" + P("") / "ⱙ" + P("") / "ⱚ" + P("") / "ⱛ" + P("") / "ⱜ" + P("") / "ⱝ" + P("") / "ⱞ" + P("") / "ⱟ") + P("") * P("") / "ↄ" + P("") * (P("") / "ⅰ" + P("") / "ⅱ" + P("") / "ⅲ" + P("") / "ⅳ" + P("") / "ⅴ" + P("") / "ⅵ" + P("") / "ⅶ" + P("") / "ⅷ" + P("") / "ⅸ" + P("") / "ⅹ" + P("") / "ⅺ" + P("") / "ⅻ" + P("") / "ⅼ" + P("") / "ⅽ" + P("") / "ⅾ" + P("") / "ⅿ") + P("") * (P("") / "ω" + P("") / "k" + P("") / "å" + P("") / "ⅎ") + P("") * (P("") / "ⳁ" + P("") / "ⳃ" + P("") / "ⳅ" + P("") / "ⳇ" + P("") / "ⳉ" + P("") / "ⳋ" + P("") / "ⳍ" + P("") / "ⳏ" + P("") / "ⳑ" + P("") / "ⳓ" + P("") / "ⳕ" + P("") / "ⳗ" + P("") / "ⳙ" + P("") / "ⳛ" + P("") / "ⳝ" + P("") / "ⳟ" + P("") / "ⳡ" + P("") / "ⳣ" + P("") / "ⳬ" + P("") / "ⳮ" + P("") / "ⳳ") + P("") * (P("") / "ⲁ" + P("") / "ⲃ" + P("") / "ⲅ" + P("") / "ⲇ" + P("") / "ⲉ" + P("") / "ⲋ" + P("") / "ⲍ" + P("") / "ⲏ" + P("") / "ⲑ" + P("") / "ⲓ" + P("") / "ⲕ" + P("") / "ⲗ" + P("") / "ⲙ" + P("") / "ⲛ" + P("") / "ⲝ" + P("") / "ⲟ" + P("") / "ⲡ" + P("") / "ⲣ" + P("") / "ⲥ" + P("") / "ⲧ" + P("") / "ⲩ" + P("") / "ⲫ" + P("") / "ⲭ" + P("") / "ⲯ" + P("") / "ⲱ" + P("") / "ⲳ" + P("") / "ⲵ" + P("") / "ⲷ" + P("") / "ⲹ" + P("") / "ⲻ" + P("") / "ⲽ" + P("") / "ⲿ"))
M.casefold_mapping[4] = P("") * (P("") * (P("") * (P("") / "𑣀" + P("") / "𑣁" + P("") / "𑣂" + P("") / "𑣃" + P("") / "𑣄" + P("") / "𑣅" + P("") / "𑣆" + P("") / "𑣇" + P("") / "𑣈" + P("") / "𑣉" + P("") / "𑣊" + P("") / "𑣋" + P("") / "𑣌" + P("") / "𑣍" + P("") / "𑣎" + P("") / "𑣏" + P("") / "𑣐" + P("") / "𑣑" + P("") / "𑣒" + P("") / "𑣓" + P("") / "𑣔" + P("") / "𑣕" + P("") / "𑣖" + P("") / "𑣗" + P("") / "𑣘" + P("") / "𑣙" + P("") / "𑣚" + P("") / "𑣛" + P("") / "𑣜" + P("") / "𑣝" + P("") / "𑣞" + P("") / "𑣟")) + P("") * (P("") * (P("") / "𐓨" + P("") / "𐓩" + P("") / "𐓪" + P("") / "𐓫" + P("") / "𐓬" + P("") / "𐓭" + P("") / "𐓮" + P("") / "𐓯" + P("") / "𐓰" + P("") / "𐓱" + P("") / "𐓲" + P("") / "𐓳" + P("") / "𐓴" + P("") / "𐓵" + P("") / "𐓶" + P("") / "𐓷" + P("") / "𐓸" + P("") / "𐓹" + P("") / "𐓺" + P("") / "𐓻") + P("") * (P("") / "𐓘" + P("") / "𐓙" + P("") / "𐓚" + P("") / "𐓛" + P("") / "𐓜" + P("") / "𐓝" + P("") / "𐓞" + P("") / "𐓟" + P("") / "𐓠" + P("") / "𐓡" + P("") / "𐓢" + P("") / "𐓣" + P("") / "𐓤" + P("") / "𐓥" + P("") / "𐓦" + P("") / "𐓧") + P("") * (P("") / "𐵰" + P("") / "𐵱" + P("") / "𐵲" + P("") / "𐵳" + P("") / "𐵴" + P("") / "𐵵" + P("") / "𐵶" + P("") / "𐵷" + P("") / "𐵸" + P("") / "𐵹" + P("") / "𐵺" + P("") / "𐵻" + P("") / "𐵼" + P("") / "𐵽" + P("") / "𐵾" + P("") / "𐵿" + P("") / "𐶀" + P("") / "𐶁" + P("") / "𐶂" + P("") / "𐶃" + P("") / "𐶄" + P("") / "𐶅") + P("") * (P("") / "𐐨" + P("") / "𐐩" + P("") / "𐐪" + P("") / "𐐫" + P("") / "𐐬" + P("") / "𐐭" + P("") / "𐐮" + P("") / "𐐯" + P("") / "𐐰" + P("") / "𐐱" + P("") / "𐐲" + P("") / "𐐳" + P("") / "𐐴" + P("") / "𐐵" + P("") / "𐐶" + P("") / "𐐷" + P("") / "𐐸" + P("") / "𐐹" + P("") / "𐐺" + P("") / "𐐻" + P("") / "𐐼" + P("") / "𐐽" + P("") / "𐐾" + P("") / "𐐿" + P("") / "𐑀" + P("") / "𐑁" + P("") / "𐑂" + P("") / "𐑃" + P("") / "𐑄" + P("") / "𐑅" + P("") / "𐑆" + P("") / "𐑇" + P("") / "𐑈" + P("") / "𐑉" + P("") / "𐑊" + P("") / "𐑋" + P("") / "𐑌" + P("") / "𐑍" + P("") / "𐑎" + P("") / "𐑏") + P("") * (P("") / "𐖧" + P("") / "𐖨" + P("") / "𐖩" + P("") / "𐖪" + P("") / "𐖫" + P("") / "𐖬" + P("") / "𐖭" + P("") / "𐖮" + P("") / "𐖯" + P("") / "𐖰" + P("") / "𐖱" + P("") / "𐖳" + P("") / "𐖴" + P("") / "𐖵" + P("") / "𐖶" + P("") / "𐖷" + P("") / "𐖸" + P("") / "𐖹" + P("") / "𐖻" + P("") / "𐖼") + P("") * (P("") / "𐖗" + P("") / "𐖘" + P("") / "𐖙" + P("") / "𐖚" + P("") / "𐖛" + P("") / "𐖜" + P("") / "𐖝" + P("") / "𐖞" + P("") / "𐖟" + P("") / "𐖠" + P("") / "𐖡" + P("") / "𐖣" + P("") / "𐖤" + P("") / "𐖥" + P("") / "𐖦") + P("") * (P("") / "𐳀" + P("") / "𐳁" + P("") / "𐳂" + P("") / "𐳃" + P("") / "𐳄" + P("") / "𐳅" + P("") / "𐳆" + P("") / "𐳇" + P("") / "𐳈" + P("") / "𐳉" + P("") / "𐳊" + P("") / "𐳋" + P("") / "𐳌" + P("") / "𐳍" + P("") / "𐳎" + P("") / "𐳏" + P("") / "𐳐" + P("") / "𐳑" + P("") / "𐳒" + P("") / "𐳓" + P("") / "𐳔" + P("") / "𐳕" + P("") / "𐳖" + P("") / "𐳗" + P("") / "𐳘" + P("") / "𐳙" + P("") / "𐳚" + P("") / "𐳛" + P("") / "𐳜" + P("") / "𐳝" + P("") / "𐳞" + P("") / "𐳟" + P("") / "𐳠" + P("") / "𐳡" + P("") / "𐳢" + P("") / "𐳣" + P("") / "𐳤" + P("") / "𐳥" + P("") / "𐳦" + P("") / "𐳧" + P("") / "𐳨" + P("") / "𐳩" + P("") / "𐳪" + P("") / "𐳫" + P("") / "𐳬" + P("") / "𐳭" + P("") / "𐳮" + P("") / "𐳯" + P("") / "𐳰" + P("") / "𐳱" + P("") / "𐳲")) + P("") * (P("") * (P("") / "𖹠" + P("") / "𖹡" + P("") / "𖹢" + P("") / "𖹣" + P("") / "𖹤" + P("") / "𖹥" + P("") / "𖹦" + P("") / "𖹧" + P("") / "𖹨" + P("") / "𖹩" + P("") / "𖹪" + P("") / "𖹫" + P("") / "𖹬" + P("") / "𖹭" + P("") / "𖹮" + P("") / "𖹯" + P("") / "𖹰" + P("") / "𖹱" + P("") / "𖹲" + P("") / "𖹳" + P("") / "𖹴" + P("") / "𖹵" + P("") / "𖹶" + P("") / "𖹷" + P("") / "𖹸" + P("") / "𖹹" + P("") / "𖹺" + P("") / "𖹻" + P("") / "𖹼" + P("") / "𖹽" + P("") / "𖹾" + P("") / "𖹿")) + P("") * (P("") * (P("") / "𞤢" + P("") / "𞤣" + P("") / "𞤤" + P("") / "𞤥" + P("") / "𞤦" + P("") / "𞤧" + P("") / "𞤨" + P("") / "𞤩" + P("") / "𞤪" + P("") / "𞤫" + P("") / "𞤬" + P("") / "𞤭" + P("") / "𞤮" + P("") / "𞤯" + P("") / "𞤰" + P("") / "𞤱" + P("") / "𞤲" + P("") / "𞤳" + P("") / "𞤴" + P("") / "𞤵" + P("") / "𞤶" + P("") / "𞤷" + P("") / "𞤸" + P("") / "𞤹" + P("") / "𞤺" + P("") / "𞤻" + P("") / "𞤼" + P("") / "𞤽" + P("") / "𞤾" + P("") / "𞤿" + P("") / "𞥀" + P("") / "𞥁" + P("") / "𞥂" + P("") / "𞥃")))
M.categories = {}
M.categories.L = {}
M.categories.L[1] = P("A") + P("B") + P("C") + P("D") + P("E") + P("F") + P("G") + P("H") + P("I") + P("J") + P("K") + P("L") + P("M") + P("N") + P("O") + P("P") + P("Q") + P("R") + P("S") + P("T") + P("U") + P("V") + P("W") + P("X") + P("Y") + P("Z") + P("a") + P("b") + P("c") + P("d") + P("e") + P("f") + P("g") + P("h") + P("i") + P("j") + P("k") + P("l") + P("m") + P("n") + P("o") + P("p") + P("q") + P("r") + P("s") + P("t") + P("u") + P("v") + P("w") + P("x") + P("y") + P("z")
M.categories.L[2] = P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))
M.categories.L[3] = P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("")) + P("") * (P("") * P("") + P("") * P("")) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * P("") * P("") + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")))
M.categories.L[4] = P("") * (P("") * P("") * P("") + P("") * (P("") * (P("") + P("")) + P("") * P("") + P("") * P("")) + P("") * (P("") * P("") + P("") * P("")) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("")) + P("") * P("")) + P("") * (P("") * (P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * P("") * P("") + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * P("")) + P("") * P("") * P("") + P("") * (P("") * (P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * P("") * P(""))
M.categories.N = {}
M.categories.N[1] = P("0") + P("1") + P("2") + P("3") + P("4") + P("5") + P("6") + P("7") + P("8") + P("9")
M.categories.N[2] = P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))
M.categories.N[3] = P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")))
M.categories.N[4] = P("") * (P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))))
M.categories.P = {}
M.categories.P[1] = P("!") + P('"') + P("#") + P("%") + P("&") + P("'") + P("(") + P(")") + P("*") + P(",") + P("-") + P(".") + P("/") + P(":") + P(";") + P("?") + P("@") + P("[") + P("\\") + P("]") + P("_") + P("{") + P("}")
M.categories.P[2] = P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * P("") + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))
M.categories.P[3] = P("") * (P("") * P("") + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P(""))) + P("") * (P("") * P("") + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * P("") + P("") * P("") + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")))
M.categories.P[4] = P("") * (P("") * P("") * P("") + P("") * (P("") * (P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P(""))) + P("") * (P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * P("") + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("")) + P("") * P("") + P("") * P("") + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * P("") + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * P("") + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * P("") + P("") * (P("") + P(""))))
M.categories.Pc = {}
M.categories.Pc[1] = P("_")
M.categories.Pc[2] = fail
M.categories.Pc[3] = P("") * (P("") * (P("") + P("")) + P("") * P("")) + P("") * (P("") * P("") + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("")))
M.categories.Pc[4] = fail
M.categories.S = {}
M.categories.S[1] = P("$") + P("+") + P("<") + P("=") + P(">") + P("^") + P("`") + P("|") + P("~")
M.categories.S[2] = P("") * (P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))
M.categories.S[3] = P("") * (P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * P("") + P("") * P("") + P("") * (P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * P("")) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")))
M.categories.S[4] = P("") * (P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("")) + P("") * (P("") * P("") + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * P("") + P("") * (P("") + P("") + P("") + P(""))) + P("") * P("") * P("") + P("") * (P("") * (P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * (P("") * P("") + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * P("") + P("") * P("")) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * P("") + P("") * (P("") + P("")) + P("") * (P("") + P("")) + P("") * (P("") + P(""))) + P("") * (P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("")) + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))))
M.categories.Z = {}
M.categories.Z[1] = P(" ")
M.categories.Z[2] = P("") * P("")
M.categories.Z[3] = P("") * (P("") * P("") + P("") * (P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P("") + P(""))) + P("") * P("") * P("") + P("") * P("") * P("")
M.categories.Z[4] = fail
M.ccc = {}
M.ccc[1] = fail
M.ccc[2] = P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(222) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(222) + P("") * Cc(228) + P("") * Cc(230) + P("") * Cc(10) + P("") * Cc(11) + P("") * Cc(12) + P("") * Cc(13) + P("") * Cc(14) + P("") * Cc(15) + P("") * Cc(16) + P("") * Cc(17) + P("") * Cc(18) + P("") * Cc(19) + P("") * Cc(19) + P("") * Cc(20) + P("") * Cc(21) + P("") * Cc(22) + P("") * Cc(23)) + P("") * (P("") * Cc(36) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(27) + P("") * Cc(28) + P("") * Cc(29) + P("") * Cc(30) + P("") * Cc(31) + P("") * Cc(32) + P("") * Cc(33) + P("") * Cc(34) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(35)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(30) + P("") * Cc(31) + P("") * Cc(32)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(220)) + P("") * (P("") * Cc(24) + P("") * Cc(25) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(18)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(240) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(232) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(233) + P("") * Cc(234) + P("") * Cc(234) + P("") * Cc(233) + P("") * Cc(234) + P("") * Cc(234) + P("") * Cc(233) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(232) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(232) + P("") * Cc(216) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(202) + P("") * Cc(202) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(202) + P("") * Cc(202) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230))
M.ccc[3] = P("") * (P("") * (P("") * Cc(8) + P("") * Cc(8)) + P("") * (P("") * Cc(218) + P("") * Cc(228) + P("") * Cc(232) + P("") * Cc(222) + P("") * Cc(224) + P("") * Cc(224))) + P("") * (P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * P("") * Cc(9) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230))) + P("") * (P("") * P("") * Cc(220) + P("") * (P("") * Cc(7) + P("") * Cc(9) + P("") * Cc(9)) + P("") * (P("") * Cc(222) + P("") * Cc(230) + P("") * Cc(220)) + P("") * (P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220)) + P("") * (P("") * Cc(9) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220)) + P("") * (P("") * Cc(230) + P("") * Cc(220)) + P("") * (P("") * Cc(7) + P("") * Cc(9) + P("") * Cc(9)) + P("") * (P("") * Cc(9) + P("") * Cc(9)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * P("") * Cc(7) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(1) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * P("") * Cc(7) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(234) + P("") * Cc(214) + P("") * Cc(220) + P("") * Cc(202) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(232) + P("") * Cc(228) + P("") * Cc(228) + P("") * Cc(220) + P("") * Cc(218) + P("") * Cc(230) + P("") * Cc(233) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(220)) + P("") * (P("") * Cc(9) + P("") * Cc(230)) + P("") * P("") * Cc(228) + P("") * (P("") * Cc(9) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(9) + P("") * Cc(9) + P("") * Cc(9))) + P("") * (P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(27) + P("") * Cc(28) + P("") * Cc(29) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(9) + P("") * Cc(230)) + P("") * P("") * Cc(7) + P("") * (P("") * Cc(9) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230)) + P("") * P("") * Cc(7) + P("") * P("") * Cc(9) + P("") * P("") * Cc(7) + P("") * P("") * Cc(9) + P("") * P("") * Cc(7) + P("") * P("") * Cc(9) + P("") * P("") * Cc(9) + P("") * P("") * Cc(7) + P("") * P("") * Cc(9) + P("") * P("") * Cc(7) + P("") * (P("") * Cc(9) + P("") * Cc(84) + P("") * Cc(91)) + P("") * P("") * Cc(7) + P("") * P("") * Cc(9) + P("") * P("") * Cc(9) + P("") * (P("") * Cc(9) + P("") * Cc(9)) + P("") * (P("") * Cc(122) + P("") * Cc(122) + P("") * Cc(122) + P("") * Cc(122)) + P("") * (P("") * Cc(118) + P("") * Cc(118) + P("") * Cc(9)) + P("") * (P("") * Cc(107) + P("") * Cc(107) + P("") * Cc(107) + P("") * Cc(107)) + P("") * (P("") * Cc(103) + P("") * Cc(103) + P("") * Cc(9)) + P("") * P("") * Cc(220) + P("") * (P("") * Cc(130) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(9) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(129) + P("") * Cc(130) + P("") * Cc(132) + P("") * Cc(130) + P("") * Cc(130) + P("") * Cc(130) + P("") * Cc(130)) + P("") * (P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(216))) + P("") * (P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230)) + P("") * P("") * Cc(26)) + P("") * (P("") * (P("") * Cc(9) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(9) + P("") * Cc(9)) + P("") * P("") * Cc(7) + P("") * P("") * Cc(9) + P("") * (P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220)) + P("") * (P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * P("") * Cc(9) + P("") * (P("") * Cc(230) + P("") * Cc(9)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * P("") * Cc(9))
M.ccc[4] = P("") * (P("") * P("") * P("") * Cc(1) + P("") * (P("") * (P("") * Cc(9) + P("") * Cc(7)) + P("") * (P("") * Cc(9) + P("") * Cc(9) + P("") * Cc(9)) + P("") * (P("") * Cc(9) + P("") * Cc(7)) + P("") * (P("") * Cc(9) + P("") * Cc(7)) + P("") * P("") * Cc(7) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(9) + P("") * Cc(9)) + P("") * (P("") * Cc(7) + P("") * Cc(9)) + P("") * P("") * Cc(9) + P("") * P("") * Cc(9) + P("") * (P("") * Cc(9) + P("") * Cc(7)) + P("") * (P("") * Cc(9) + P("") * Cc(9) + P("") * Cc(9)) + P("") * (P("") * Cc(9) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(7) + P("") * Cc(7)) + P("") * (P("") * Cc(9) + P("") * Cc(7)) + P("") * P("") * Cc(7) + P("") * (P("") * Cc(9) + P("") * Cc(7) + P("") * Cc(230)) + P("") * P("") * Cc(9) + P("") * P("") * Cc(9) + P("") * (P("") * Cc(7) + P("") * Cc(9) + P("") * Cc(9)) + P("") * P("") * Cc(9) + P("") * P("") * Cc(9) + P("") * (P("") * Cc(9) + P("") * Cc(7)) + P("") * P("") * Cc(9) + P("") * P("") * Cc(9) + P("") * P("") * Cc(7) + P("") * (P("") * Cc(9) + P("") * Cc(9)) + P("") * (P("") * Cc(9) + P("") * Cc(9)) + P("") * P("") * Cc(9)) + P("") * (P("") * P("") * Cc(220) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(230) + P("") * Cc(220)) + P("") * (P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220)) + P("") * (P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(1) + P("") * Cc(220) + P("") * Cc(9)) + P("") * (P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220)) + P("") * (P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(220)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * P("") * Cc(220)) + P("") * (P("") * (P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(1)) + P("") * (P("") * Cc(6) + P("") * Cc(6)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * P("") * Cc(9)) + P("") * (P("") * (P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(216) + P("") * Cc(216) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(1) + P("") * Cc(226) + P("") * Cc(216) + P("") * Cc(216) + P("") * Cc(216) + P("") * Cc(216) + P("") * Cc(216) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230))) + P("") * (P("") * (P("") * Cc(232) + P("") * Cc(232) + P("") * Cc(220) + P("") * Cc(230)) + P("") * P("") * Cc(230) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(7)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * (P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230) + P("") * Cc(230)) + P("") * P("") * Cc(230) + P("") * (P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220) + P("") * Cc(220)) + P("") * (P("") * Cc(230) + P("") * Cc(220))))
-- luacheck: pop
return M
